package com.yuda.hainafacetofaceai.controller;


import com.yuda.hainafacetofaceai.entity.CandidateExam;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/login")
@Slf4j
public class LoginController {

    @Autowired
    private StringRedisTemplate redisTemplate;

    @Autowired
    private JdbcTemplate DBOperator;

    @PostMapping
    public ResponseEntity LoginGo(@RequestBody CandidateExam candidate){
        try{
            CandidateExam candidateExam = DBOperator.queryForObject("SELECT \n" +
                    "\ta.uuid, \n" +
                    "\tb.NAME, \n" +
                    "\ta.zkz_num, \n" +
                    "\tb.id_card, \n" +
                    "\ta.exam_connection_code, \n" +
                    "\ta.candidate_connect_code  \n" +
                    "FROM\n" +
                    "\tcandidate_exam a join \n" +
                    "\tcandidate b  on a.id_card = b.id_card \n" +
                    "WHERE\n" +
                    "\tb.id_card = ? \n" +
                    "\tAND a.zkz_num = ? ",new Object[]{candidate.getIdCard(),candidate.getZkzNum()},new BeanPropertyRowMapper<>(CandidateExam.class));
            redisTemplate.opsForValue().set(candidateExam.getCandidateConnectCode(),new JSONObject(candidateExam).toString());
            JSONObject responseData =  new JSONObject();
            responseData.put("Token",candidateExam.getCandidateConnectCode());
            responseData.put("code",200);
            responseData.put("message","登录成功");
            return ResponseEntity.ok(responseData.toString());
        }catch (EmptyResultDataAccessException e){
            log.info("准考证号:"+candidate.getZkzNum()+"_身份证号:"+candidate.getIdCard()+"_参加面试编号:"+candidate.getExamConnectionCode()+"_查询结果=>无面试者记录");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code",500);
        jsonObject.put("message","账号密码错误");
        return ResponseEntity.badRequest().body(jsonObject.toString());
    }
}
