package com.yuda.hainafacetofaceai.controller;

import com.yuda.hainafacetofaceai.constant.AppThirdPartUrls;
import com.yuda.hainafacetofaceai.entity.CandidateCreateQuery;
import com.yuda.hainafacetofaceai.entity.CandidateExam;
import com.yuda.hainafacetofaceai.service.impl.ScriptInterfaceServiceImpl;
import com.yuda.hainafacetofaceai.util.AppUtil;
import com.yuda.hainafacetofaceai.util.ExcelUtil;
import com.yuda.hainafacetofaceai.util.RandomNumberUtil;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.UUID;

@RestController
@RequestMapping("/scripts")
@Slf4j
public class ScriptInterfaceController {

   @Autowired
   private RandomNumberUtil randomNumberUtil;
   @Autowired
   private RestTemplate restTemplate;
   @Autowired
   private AppUtil appUtil;
   @Autowired
   private ScriptInterfaceServiceImpl scriptInterfaceService;
   @Autowired
   private JdbcTemplate DBOperator;


   @PostMapping("/batchGenCandidatesOftest")
   @Transactional
   public ResponseEntity batchGenTest(@RequestParam("examConnectionCode")String examConnectionCode){
      for (int i = 0; i < 10; i++) {
         String uuid = UUID.randomUUID().toString().replace("-","");
         HttpHeaders headers = new HttpHeaders();
         headers.set("Content-Type","application/json");
         CandidateCreateQuery candidateCreateQuery = new CandidateCreateQuery();
         candidateCreateQuery.setOutId(uuid);
         candidateCreateQuery.setRepeatVersion("0");
         candidateCreateQuery.setExamConnectCode(examConnectionCode);
         candidateCreateQuery.setPhone(randomNumberUtil.generateRandomPhoneNumber());
         candidateCreateQuery.setShowName(randomNumberUtil.generateRandomChineseNickname());
         JSONObject requestBodyObject =  new JSONObject(candidateCreateQuery);
         HttpEntity<String> entity =  new HttpEntity<>(requestBodyObject.toString(),headers);
         ResponseEntity<String> response =  restTemplate.exchange(
                 appUtil.ApiUrlGen(AppThirdPartUrls.candidateCreate),
                 HttpMethod.POST,
                 entity,
                 String.class
         );
         JSONObject object = new JSONObject(response.getBody());
         //操作库
         log.info("添加成功");
      }
      return ResponseEntity.ok("");
   }

   @PostMapping("/{examConnectionCode}")
   public ResponseEntity importCandidates(@PathVariable String examConnectionCode, @RequestParam(value = "file") MultipartFile file) {
      ExcelUtil<CandidateExam> excelUtil = new ExcelUtil<>();
      List<CandidateExam> candidateExamList = null ;
      try{
         candidateExamList = (excelUtil).parseExcel(file.getInputStream(),CandidateExam.class);
      }catch (Exception e){
         log.info("候选导表解析失败");
         JSONObject bodyResponse = new JSONObject();
         bodyResponse.put("code",500);
         bodyResponse.put("message","导入失败");
         return ResponseEntity.ok(bodyResponse);
      }
      if(candidateExamList!=null&&candidateExamList.size()>0){
         boolean success = scriptInterfaceService.BatchInsert(candidateExamList,examConnectionCode);
         if(!success){
            JSONObject bodyResponse = new JSONObject();
            bodyResponse.put("code",500);
            bodyResponse.put("message","导入失败");
            return ResponseEntity.ok(bodyResponse);
         }
      }
      JSONObject bodyResponse = new JSONObject();
      bodyResponse.put("code",200);
      bodyResponse.put("message","导入成功");
      return ResponseEntity.ok("");
   }

   @PostMapping("/genCandidateConnectionCode")
   public ResponseEntity genCandidateCode(@RequestParam("candidateConnectionCode")String candidateConnectionCode){
      try{
         List<CandidateExam> candidateExamList = DBOperator.queryForList("select\n" +
                 "a.phone, \n" +
                 "b.uuid,\n" +
                 "b.exam_connection_code\n" +
                 "from \n" +
                 "candidate_exam a \n" +
                 "left join\n" +
                 "candidate b on a.id_card = b.id_card\n" +
                 "where\n" +
                 "a.exam_connection_code = ?\n" +
                 "and \n" +
                 "a.candidate_connect_code is not null",new Object[]{candidateConnectionCode},CandidateExam.class);
         if(candidateExamList.size()!=0){
            for (CandidateExam candidateExam : candidateExamList) {
               scriptInterfaceService.sendRequestAndSaveDB(candidateExam);
            }
         }
      }catch (EmptyResultDataAccessException e){
         log.info("面试编号"+candidateConnectionCode+"暂无候选者");
      }
      JSONObject requestData = new JSONObject();
      requestData.put("code",200);
      requestData.put("message","指令发送成功");
      return ResponseEntity.ok(requestData);
   }
}
