package com.yuda.hainafacetofaceai.controller;

import com.yuda.hainafacetofaceai.constant.AppThirdPartUrls;
import com.yuda.hainafacetofaceai.entity.CandidateCreateQuery;
import com.yuda.hainafacetofaceai.entity.CandidateMDelete;
import com.yuda.hainafacetofaceai.entity.ExamQuery;
import com.yuda.hainafacetofaceai.util.AppUtil;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/businessApi")
@Slf4j
public class businessController {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private AppUtil appUtil;

    @PostMapping("/examList")
    public ResponseEntity examList(@RequestBody ExamQuery examQuery){
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type","application/json");
        JSONObject requestBodyObject =  new JSONObject(examQuery);
        HttpEntity<String> entity =  new HttpEntity<>(requestBodyObject.toString(),headers);
        ResponseEntity<String> response =  restTemplate.exchange(
                appUtil.ApiUrlGen(AppThirdPartUrls.examList),
                HttpMethod.POST,
                entity,
                String.class
        );
        return ResponseEntity.ok(response.getBody());
    }
    @PostMapping("/candidateCreate")
    public ResponseEntity candidateCreate(@RequestBody CandidateCreateQuery candidateCreateQuery){
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type","application/json");
        JSONObject requestBodyObject =  new JSONObject(candidateCreateQuery);
        HttpEntity<String> entity =  new HttpEntity<>(requestBodyObject.toString(),headers);
        ResponseEntity<String> response =  restTemplate.exchange(
                appUtil.ApiUrlGen(AppThirdPartUrls.candidateCreate),
                HttpMethod.POST,
                entity,
                String.class
        );
        return ResponseEntity.ok(response.getBody());
    }
    @PostMapping("/candidateGet")
    public ResponseEntity candidateGet(@RequestParam("outId")String outId){
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type","application/json");
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("outId",outId);
        JSONObject requestBodyObject =  new JSONObject(map);
        HttpEntity<JSONObject> entity =  new HttpEntity<>(requestBodyObject,headers);
        ResponseEntity<JSONObject> response =  restTemplate.exchange(
                appUtil.ApiUrlGen(AppThirdPartUrls.candidateGet),
                HttpMethod.POST,
                entity,
                JSONObject.class
        );
        return ResponseEntity.ok(response.getBody());
    }
    @PostMapping("/candidateSendMessage")
    public ResponseEntity candidateSendMessage(@RequestParam("outId")String outId){
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type","application/json");
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("outId",outId);
        JSONObject requestBodyObject =  new JSONObject(map);
        HttpEntity<JSONObject> entity =  new HttpEntity<>(requestBodyObject,headers);
        ResponseEntity<JSONObject> response =  restTemplate.exchange(
                appUtil.ApiUrlGen(AppThirdPartUrls.candidateGet),
                HttpMethod.POST,
                entity,
                JSONObject.class
        );
        return ResponseEntity.ok(response.getBody());
    }
    @PostMapping("/candidateMDelete")
    public ResponseEntity candidateMDelete(@RequestBody CandidateMDelete candidateMDelete){
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type","application/json");
        JSONObject requestBodyObject =  new JSONObject(candidateMDelete);
        HttpEntity<JSONObject> entity =  new HttpEntity<>(requestBodyObject,headers);
        ResponseEntity<JSONObject> response =  restTemplate.exchange(
                appUtil.ApiUrlGen(AppThirdPartUrls.candidateGet),
                HttpMethod.POST,
                entity,
                JSONObject.class
        );
        return ResponseEntity.ok(response.getBody());
    }
}
