package com.yuda.hainafacetofaceai.util;

import org.springframework.stereotype.Component;

import java.util.Random;

@Component
public class RandomNumberUtil {
    // 扩展后的常见姓氏数组
    private static final String[] SURNAMES = {
            "张", "李", "王", "赵", "刘", "陈", "杨", "黄", "周", "吴",
            "徐", "孙", "马", "朱", "胡", "林", "何", "高", "郭", "罗",
            "梁", "宋", "郑", "谢", "唐", "许", "邓", "冯", "程", "曹",
            "邱", "毛", "邹", "谢", "潘", "蒋", "谭", "魏", "戴", "阮",
            "任", "潘", "彭", "黎", "蒋", "尤", "史", "孔", "汪", "余"
    };
    // 扩展后的名字部分数组
    private static final String[] FIRST_NAMES = {
            "伟", "娜", "婷", "敏", "丽", "芳", "杰", "鹏", "军", "洋",
            "超", "静", "琳", "彬", "刚", "磊", "媛", "华", "明", "燕",
            "娟", "强", "立", "磊", "佳", "琪", "冰", "婷", "欣", "晨",
            "露", "云", "媛", "琴", "雪", "涵", "洁", "梅", "颖", "霞",
            "雨", "华", "婧", "舒", "丹", "彤", "珊", "娴", "睿", "宇",
            "泽", "博", "欣", "淼", "蓉", "明", "露", "雯", "思思", "佳怡",
            "子怡", "思琪", "欣妍", "晓琳", "悦琳", "心怡", "晓彤", "美玲"
    };
    public  String generateRandomPhoneNumber() {
        Random random = new Random();
        // 中国手机号通常以 1 开头，第二位是 3-9 中的某个数字
        int secondDigit = random.nextInt(7) + 3; // 3-9
        StringBuilder phoneNumber = new StringBuilder();
        // 构建手机号
        phoneNumber.append("1"); // 第一位是 1
        phoneNumber.append(secondDigit); // 第二位是 3-9 中的数字
        for (int i = 0; i < 8; i++) {
            phoneNumber.append(random.nextInt(10)); // 随机生成接下来的 8 位数字
        }
        return phoneNumber.toString();
    }
    // 随机生成中文昵称的方法
    public  String generateRandomChineseNickname() {
        Random random = new Random();

        // 随机选择姓氏
        String surname = SURNAMES[random.nextInt(SURNAMES.length)];

        // 随机选择名字部分（可以选择一个或两个字）
        String firstName = FIRST_NAMES[random.nextInt(FIRST_NAMES.length)];

        // 拼接姓氏和名字
        return surname + firstName;
    }

}
