package com.yuda.hainafacetofaceai.util;

import com.yuda.hainafacetofaceai.constant.AppStaticParams;
import jdk.nashorn.internal.runtime.logging.Logger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@Component
@Slf4j
public class AppUtil {

    public  String ApiUrlGen(String url){
        String timestamp = String.valueOf(System.currentTimeMillis());
        timestamp = timestamp.substring(0, 10);
        String str = AppStaticParams.appKey + timestamp + AppStaticParams.appSecret;
        String md5Str = md5(str);
        String suffixParams = "?appKey="+ AppStaticParams.appKey+"&sign="+md5Str+"&timestamp="+timestamp;

        return url+suffixParams;
    }


    public  String md5(String input) {
        try {
            // 创建 MD5 摘要实例
            MessageDigest md = MessageDigest.getInstance("MD5");

            // 计算 MD5 值
            byte[] hashBytes = md.digest(input.getBytes());

            // 转换为 32 位小写字符串
            StringBuilder sb = new StringBuilder();
            for (byte b : hashBytes) {
                sb.append(String.format("%02x", b));  // 格式化成 16 进制
            }

            return sb.toString(); // 返回 32 位 MD5 字符串
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

}
