package com.yuda.hainafacetofaceai.controller;

import com.yuda.hainafacetofaceai.constant.AppThirdPartUrls;
import com.yuda.hainafacetofaceai.entity.CandidateCreateQuery;
import com.yuda.hainafacetofaceai.entity.CandidateExam;
import com.yuda.hainafacetofaceai.entity.CandidateMDelete;
import com.yuda.hainafacetofaceai.entity.ExamQuery;
import com.yuda.hainafacetofaceai.util.AppUtil;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/businessApi")
@Slf4j
public class BusinessController {

    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private JdbcTemplate DBOperator;
    @Autowired
    private AppUtil appUtil;
    @PostMapping("/examList")
    public ResponseEntity examList(@RequestBody ExamQuery examQuery){
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type","application/json");
        JSONObject requestBodyObject =  new JSONObject(examQuery);
        HttpEntity<String> entity =  new HttpEntity<>(requestBodyObject.toString(),headers);
        ResponseEntity<String> response =  restTemplate.exchange(
                appUtil.ApiUrlGen(AppThirdPartUrls.examList),
                HttpMethod.POST,
                entity,
                String.class
        );
        return ResponseEntity.ok(response.getBody());
    }
    @PostMapping("/candidateCreate")
    public ResponseEntity candidateCreate(@RequestBody CandidateCreateQuery candidateCreateQuery){
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type","application/json");
        JSONObject requestBodyObject =  new JSONObject(candidateCreateQuery);
        HttpEntity<String> entity =  new HttpEntity<>(requestBodyObject.toString(),headers);
        ResponseEntity<String> response =  restTemplate.exchange(
                appUtil.ApiUrlGen(AppThirdPartUrls.candidateCreate),
                HttpMethod.POST,
                entity,
                String.class
        );
        return ResponseEntity.ok(response.getBody());
    }
    @PostMapping("/candidateGet")
    public ResponseEntity candidateGet(@RequestParam("outId")String outId){
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type","application/json");
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("outId",outId);
        JSONObject requestBodyObject =  new JSONObject(map);
        HttpEntity<JSONObject> entity =  new HttpEntity<>(requestBodyObject,headers);
        ResponseEntity<JSONObject> response =  restTemplate.exchange(
                appUtil.ApiUrlGen(AppThirdPartUrls.candidateGet),
                HttpMethod.POST,
                entity,
                JSONObject.class
        );
        return ResponseEntity.ok(response.getBody());
    }
    @PostMapping("/candidateGetV2")
    public ResponseEntity candidateGetV2(@RequestBody String responseBody){
        try{
            CandidateExam candidateExam = DBOperator.queryForObject("select * from candidate_exam where exam_connect_code = ? order by create_time asc limit 1",new Object[]{new JSONObject(responseBody).getString("examConnectCode")},new BeanPropertyRowMapper<>(CandidateExam.class));
            long timeStamp = candidateExam.getCreateTime().toInstant().getMillis()/1000;
            JSONObject requestBody = new JSONObject(responseBody);
            requestBody.put("fromTimeStamp",timeStamp);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type","application/json");
            HttpEntity<String> entity =  new HttpEntity<>(requestBody.toString(),headers);
            ResponseEntity<String> response =  restTemplate.exchange(
                    appUtil.ApiUrlGen(AppThirdPartUrls.candidateGet),
                    HttpMethod.POST,
                    entity,
                    String.class
            );
            JSONObject data = new JSONObject(response.getBody());
            if(data.getString("code").equals(0)){
               JSONArray candidateList = data.getJSONArray("candidateList");
               if(!candidateList.isEmpty()){
                   for (int i = 0; i < candidateList.length(); i++) {
                       JSONObject candidate = new JSONObject(candidateList.get(i));
                       DBOperator.update("update candiate_exam set result_back = 1,interview_results = ? where candidateConnectionCode = ? and result_back = 0",new Object[]{candidate.toString(),candidate.getString("candidateConnectCode")});
                   }
               }
            }
            log.info("主动查询面试"+new JSONObject(responseBody).getString("examConnectCode")+"面试结果批量更新成功");
        }catch (Exception e){
            log.info("主动查询面试"+new JSONObject(responseBody).getString("examConnectCode")+"面试结果批量过程出错");
            return ResponseEntity.ok(new JSONObject(new HashMap<String,Object>(){{
                put("code",500);
                put("message","面试结果批量更新过程出错");
            }}));
        }
        return ResponseEntity.ok(new JSONObject(new HashMap<String,Object>()){{
            put("code",200);
            put("message","操作成功");
        }});
    }
    @PostMapping("/candidateSendMessage")
    public ResponseEntity candidateSendMessage(@RequestParam("outId")String outId){
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type","application/json");
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("outId",outId);
        JSONObject requestBodyObject =  new JSONObject(map);
        HttpEntity<JSONObject> entity =  new HttpEntity<>(requestBodyObject,headers);
        ResponseEntity<JSONObject> response =  restTemplate.exchange(
                appUtil.ApiUrlGen(AppThirdPartUrls.candidateGet),
                HttpMethod.POST,
                entity,
                JSONObject.class
        );
        return ResponseEntity.ok(response.getBody());
    }
    @PostMapping("/candidateMDelete")
    public ResponseEntity candidateMDelete(@RequestBody CandidateMDelete candidateMDelete){
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type","application/json");
        JSONObject requestBodyObject =  new JSONObject(candidateMDelete);
        HttpEntity<JSONObject> entity =  new HttpEntity<>(requestBodyObject,headers);
        ResponseEntity<JSONObject> response =  restTemplate.exchange(
                appUtil.ApiUrlGen(AppThirdPartUrls.candidateGet),
                HttpMethod.POST,
                entity,
                JSONObject.class
        );
        return ResponseEntity.ok(response.getBody());
    }

}
