package com.yuda.hainafacetofaceai.controller;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@RestController
@RequestMapping("/callBackApi")
@Slf4j
public class CallBackApiController {

    @Autowired
    private JdbcTemplate DBOperator;

    @PostMapping("/interviewResultReceiver")
    public ResponseEntity interviewResultsReceiver(@RequestBody String data){
        try{
            JSONObject result =  JSONObject.parseObject(data);
            String candidateConnectCode = result.getString("candidateConnectCode");
            log.info("候选人链接码"+candidateConnectCode+"面试过程回调"+data);
            String event = result.getString("event");
            if(event.equals("aiExamCandidateReviewV2")){
                try{
                    DBOperator.update("update candidate_exam set result_back = 1,interview_results = ? where candidate_connect_code = ?",new Object[]{data,candidateConnectCode});
                    log.info("候选人链接码"+candidateConnectCode+"面试结果入库完成");
                }catch (Exception e){
                    log.info("候选人链接码"+candidateConnectCode+"面试结果入库回调出错");
                }
            }
        }catch (Exception e){
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code",10000);
            jsonObject.put("message","回到数据解析出错");
            return ResponseEntity.ok(jsonObject.toString());
        }

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code",0);
        jsonObject.put("message","收到回调");
        return ResponseEntity.ok().body(jsonObject.toString());
    }
}
