package com.yuda.hainafacetofaceai.controller;

import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/commitmentLetterApi")
@Slf4j
public class CommitmentLetterController {
    @Autowired
    private JdbcTemplate DBOperator;
    @PostMapping("/uploadLetter/{examConnectionCode}/{zkzNum}")
    public ResponseEntity upLoadCommitmentLetter(@PathVariable String examConnectionCode,@PathVariable String zkzNum,@RequestBody String url){
        JSONObject object = new JSONObject(url);
        url = object.getString("url");
        try{
            DBOperator.update("UPDATE candidate_exam \n" +
                    "SET image_commitment = ? \n" +
                    ", status_commitment = 1 \n" +
                    "WHERE\n" +
                    "\tzkz_num = ? \n" +
                    "\tAND exam_connect_code = ?",new Object[]{url,zkzNum,examConnectionCode});
            log.info("准考证:"+zkzNum+"参加面试编号:"+examConnectionCode+"上传承诺书成功");
            JSONObject responseBody = new JSONObject();
            responseBody.put("code",200);
            responseBody.put("message","承诺书上传成功");
            return ResponseEntity.ok(responseBody.toString());
        }catch (Exception e){
            e.printStackTrace();
            log.info("准考证:"+zkzNum+"参加面试编号:"+examConnectionCode+"上传承诺书失败");
            JSONObject responseBody = new JSONObject();
            responseBody.put("code",500);
            responseBody.put("message","承诺书上传失败");
            return ResponseEntity.badRequest().body(responseBody.toString());
        }
    }
}
