package com.yuda.hainafacetofaceai.controller;

import com.yuda.hainafacetofaceai.util.BaiDuFaceMatchUtil;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;


@RestController
@RequestMapping("/faceMatchApi")
@Slf4j
public class FaceMatchController {
    @Autowired
    private JdbcTemplate DBOperator;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private BaiDuFaceMatchUtil faceMatch;
    @PostMapping("/uploadFacePic/{examConnectionCode}/{zkzNum}")
    public ResponseEntity examFacePicUpload(@PathVariable String examConnectionCode, @PathVariable String zkzNum, @RequestBody String images){
        JSONObject object = new JSONObject(images);
        String faceImage = object.getString("zjImage");
        try{
            DBOperator.update("update candidate_exam set exam_image_face = ? where zkz_num = ? and exam_connect_code = ?",new Object[]{faceImage,zkzNum,examConnectionCode});
            log.info("准考证:"+zkzNum+"参加面试编号:"+examConnectionCode+"上传实时人脸照片成功");
            JSONObject responseBody = new JSONObject();
            responseBody.put("code",200);
            responseBody.put("message","上传成功");
            return ResponseEntity.ok(responseBody.toString());
        }catch (Exception e){
            log.info("准考证:"+zkzNum+"参加面试编号:"+examConnectionCode+"上传实时人脸照片失败");
            JSONObject responseBody = new JSONObject();
            responseBody.put("code",500);
            responseBody.put("message","上传人脸照片失败");
            return ResponseEntity.badRequest().body(responseBody.toString());
        }
    }
    @PostMapping("/faceMatch/{examConnectionCode}/{idCard}/{zkzNum}")
    public ResponseEntity faceMatch(@PathVariable String idCard,@PathVariable String examConnectionCode,@PathVariable String zkzNum,@RequestBody String picName){
        JSONObject object = new JSONObject(picName);
        picName = object.getString("picName");
        log.info("faceMatch正在校验-》身份证号:"+idCard+"参加面试编号:"+examConnectionCode+"_人脸照片");
        if(check(examConnectionCode,idCard).get("result").equals("fail")){
            JSONObject responseBody = new JSONObject();
            responseBody.put("code",5001);
            responseBody.put("message",check(examConnectionCode,idCard).get("message").toString());
            return ResponseEntity.ok(responseBody.toString());
        }
        try{
            String[] result = faceMatch.faceMatchBaidu(idCard,picName);
            JSONObject responseBody = new JSONObject();
            responseBody.put("code",200);
            if(result[0].equals("1")){
                stringRedisTemplate.opsForValue().increment("face_success:" + examConnectionCode + "_" + idCard);
                DBOperator.update("update candidate_exam set status_face = 1 where exam_connect_code = ? and zkz_num = ?",new Object[]{examConnectionCode,zkzNum});
                log.info("身份证:"+idCard+"参加面试编号:"+examConnectionCode+"人脸验证成功");
                responseBody.put("message","检测成功");
                responseBody.put("result",true);
            }else{
                stringRedisTemplate.opsForValue().increment("face_error:" + examConnectionCode + "_" + idCard);
                log.info("身份证:"+idCard+"参加面试编号:"+examConnectionCode+"人脸验证失败");
                responseBody.put("message","检测成功");
                responseBody.put("result",false);
            }
            return ResponseEntity.ok(responseBody.toString());
        }catch (Exception e){
            e.printStackTrace();
            JSONObject data = new JSONObject();
            data.put("code",500);
            data.put("message","检测失败");
            return ResponseEntity.ok(data.toString());
        }
    }
    private HashMap<String,Object> check(String examConnectionCode, String idCard) {
        String success = stringRedisTemplate.opsForValue().get("face_success:" + examConnectionCode + "_" + idCard);
        if (!StringUtils.isEmpty(success)) {
            if (Integer.parseInt(success) >= 1) {
                return new HashMap<String,Object>(){{
                    put("result","fail");
                    put("message","请勿重复上传");
                }};
            }
        }
        String s = stringRedisTemplate.opsForValue().get("face_error:" + examConnectionCode + "_" + idCard);
        if (!StringUtils.isEmpty(s)) {
            if (Integer.parseInt(s) >=3) {
                return new HashMap<String,Object>(){{
                    put("result","fail");
                    put("message","失败次数超过三次");
                }};
            }
        }
        return new HashMap<String,Object>(){{
            put("result","success");
        }};
    }
}
