package com.yuda.hainafacetofaceai.controller;

import com.yuda.hainafacetofaceai.constant.AppThirdPartUrls;
import com.yuda.hainafacetofaceai.entity.CandidateCreateQuery;
import com.yuda.hainafacetofaceai.entity.CandidateExam;
import com.yuda.hainafacetofaceai.entity.ExamQuery;
import com.yuda.hainafacetofaceai.service.impl.ScriptInterfaceServiceImpl;
import com.yuda.hainafacetofaceai.util.AppUtil;
import com.yuda.hainafacetofaceai.util.ExcelUtil;
import com.yuda.hainafacetofaceai.util.RandomNumberUtil;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

@RestController
@RequestMapping("/scripts")
@Slf4j
public class ScriptInterfaceController {

   @Autowired
   private RandomNumberUtil randomNumberUtil;
   @Autowired
   private RestTemplate restTemplate;
   @Autowired
   private AppUtil appUtil;
   @Autowired
   private ScriptInterfaceServiceImpl scriptInterfaceService;
   @Autowired
   private JdbcTemplate DBOperator;
   @PostMapping("/batchGenCandidatesOftest")
   @Transactional
   public ResponseEntity batchGenTest(@RequestParam("examConnectionCode")String examConnectionCode){
      for (int i = 0; i < 10; i++) {
         String uuid = UUID.randomUUID().toString().replace("-","");
         HttpHeaders headers = new HttpHeaders();
         headers.set("Content-Type","application/json");
         CandidateCreateQuery candidateCreateQuery = new CandidateCreateQuery();
         candidateCreateQuery.setOutId(uuid);
         candidateCreateQuery.setRepeatVersion("0");
         candidateCreateQuery.setExamConnectCode(examConnectionCode);
         candidateCreateQuery.setPhone(randomNumberUtil.generateRandomPhoneNumber());
         candidateCreateQuery.setShowName(randomNumberUtil.generateRandomChineseNickname());
         JSONObject requestBodyObject =  new JSONObject(candidateCreateQuery);
         HttpEntity<String> entity =  new HttpEntity<>(requestBodyObject.toString(),headers);
         ResponseEntity<String> response =  restTemplate.exchange(
                 appUtil.ApiUrlGen(AppThirdPartUrls.candidateCreate),
                 HttpMethod.POST,
                 entity,
                 String.class
         );
         JSONObject object = new JSONObject(response.getBody());
         //操作库
         log.info("添加成功");
      }
      return ResponseEntity.ok("");
   }
   @PostMapping("/{examConnectionCode}")
   public ResponseEntity importCandidates(@PathVariable String examConnectionCode,MultipartFile file) {
      ExcelUtil<CandidateExam> excelUtil = new ExcelUtil<>();
      List<CandidateExam> candidateExamList = null ;
      try{
         candidateExamList = (excelUtil).parseExcel(file.getInputStream(),CandidateExam.class);
      }catch (Exception e){
         log.info("候选导表解析失败");
         JSONObject bodyResponse = new JSONObject();
         bodyResponse.put("code",500);
         bodyResponse.put("message","导入失败");
         return ResponseEntity.ok(bodyResponse.toString());
      }
      if(candidateExamList!=null&&candidateExamList.size()>0){
         boolean success = scriptInterfaceService.BatchInsert(candidateExamList,examConnectionCode);
         if(!success){
            JSONObject bodyResponse = new JSONObject();
            bodyResponse.put("code",500);
            bodyResponse.put("message","导入失败");
            return ResponseEntity.ok(bodyResponse.toString());
         }
      }
      JSONObject bodyResponse = new JSONObject();
      bodyResponse.put("code",200);
      bodyResponse.put("message","导入成功");
      return ResponseEntity.ok(bodyResponse.toString());
   }
   @PostMapping("/genCandidateConnectionCode")
   public ResponseEntity genCandidateCode(@RequestParam("candidateConnectionCode")String candidateConnectionCode){
      try{
         List<CandidateExam> candidateExamList = DBOperator.query("select\n" +
                 "a.phone, \n" +
                 "b.id_card, \n" +
                 "b.uuid,\n" +
                 "b.name,\n" +
                 "a.exam_connect_code\n" +
                 "from \n" +
                 "candidate_exam a \n" +
                 "left join\n" +
                 "candidate b on a.id_card = b.id_card\n" +
                 "where\n" +
                 "a.exam_connect_code = ?\n" +
                 "and \n" +
                 "a.candidate_connect_code is null",new Object[]{candidateConnectionCode},new BeanPropertyRowMapper<>(CandidateExam.class));
         if(candidateExamList.size()!=0){
            for (CandidateExam candidateExam : candidateExamList) {
               scriptInterfaceService.sendRequestAndSaveDB(candidateExam);
            }
         }
      }catch (EmptyResultDataAccessException e){
         log.info("面试编号"+candidateConnectionCode+"暂无候选者");
      }
      JSONObject requestData = new JSONObject();
      requestData.put("code",200);
      requestData.put("message","指令发送成功");
      return ResponseEntity.ok(requestData.toString());
   }

   @GetMapping("/{examConnectCode}")
   public ResponseEntity isCandidateCodeGenSuccess(@PathVariable String examConnectCode){
      Integer remain =  DBOperator.queryForObject("select count(1) from candidate_exam where exam_connect_code = ? and candidate_connect_code is null",new Object[]{examConnectCode},Integer.class);
      JSONObject jsonObject = new JSONObject();
      jsonObject.put("code",200);
      if(remain!=0){
         Integer total = DBOperator.queryForObject("select count(1) from candidate_exam where exam_connect_code = ?",new Object[]{examConnectCode},Integer.class);
         jsonObject.put("desc","not finish");
         jsonObject.put("message","面试候选者链接码并未生成完毕,进度"+(total-remain)+"/"+total);
      }else{
         jsonObject.put("desc","finish");
         jsonObject.put("message","面试候选者链接码生成完毕");
      }
      return ResponseEntity.ok(jsonObject.toString());
   }
   @GetMapping("/genBatchJsonFile")
   @Async
   public ResponseEntity GenBatchJsonFile(@RequestParam("examConnectCode")String examConnectionCode){
      List<CandidateExam> results = DBOperator.query("select candidate_connect_code,exam_connect_code,interview_results from candidate_exam where  exam_connect_code = ? and result_back = 1",new Object[]{examConnectionCode},new BeanPropertyRowMapper<>(CandidateExam.class));
      if(!results.isEmpty()){
         int success = 0;
         int fail = 0;
         for (int i = 0; i < results.size(); i++) {
           String jsonString =  results.get(i).getInterviewResults();
           try {
               // 解析字段中的 JSON 字符串
               JSONObject jsonObject = new JSONObject(jsonString);
               String candidateConnectCode = jsonObject.getString("candidateConnectCode");
               // 生成一个单独的 JSON 文件，每条记录一个文件
               File outputFile = new File("D:/jsonResults/"+examConnectionCode+"/"+candidateConnectCode+ ".json");
               if(!outputFile.exists()){
                  outputFile.getParentFile().mkdirs();
               }
               // 使用 FileWriter 将 JSONObject 写入文件
               try (FileWriter fileWriter = new FileWriter(outputFile)) {
                  fileWriter.write(jsonObject.toString(4)); // 美化输出，4为缩进空格数
               }
               log.info("生成进度->成功"+(++success)+"/"+results.size());
            } catch (IOException e) {
               log.info("生成进度->失败"+(++fail)+"/"+results.size());
               e.printStackTrace();
            }
         }
      }
      return ResponseEntity.ok(new JSONObject(new HashMap<String,Object>(){{
         put("code",200);
         put("message","指令发送成功");
      }}).toString());
   }

}
