package com.yuda.hainafacetofaceai.service.impl;

import com.yuda.hainafacetofaceai.constant.AppThirdPartUrls;
import com.yuda.hainafacetofaceai.entity.CandidateExam;
import com.yuda.hainafacetofaceai.service.ScriptInterfaceService;
import com.yuda.hainafacetofaceai.util.AppUtil;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

@Service
@Slf4j
public class ScriptInterfaceServiceImpl implements ScriptInterfaceService {
    @Autowired
    private JdbcTemplate DBOperator;
    private static final ExecutorService executor = Executors.newFixedThreadPool(10);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private AppUtil appUtil;
    @Override
    public boolean BatchInsert(List<CandidateExam> candidateExamList,String examConnectionCode){
        List<String> idCards = new ArrayList<>();
        try{
            idCards = checkIdCardsExistence(candidateExamList.stream().map(CandidateExam::getIdCard).collect(Collectors.toList()));
            log.info("查询候选者是否参加笔试成功:"+idCards.size()+"(笔试)/"+candidateExamList.size()+"(面试)");
        }catch (Exception e){
            log.info("查询候选者是否参加笔试失败");
            return false;
        }
        List<String> finalIdCards = idCards;
        List<CandidateExam> paperExamStudents = candidateExamList.stream().filter(x-> finalIdCards.contains(x.getIdCard())).collect(Collectors.toList());
        List<String> alreadyExistStudentIdCards = DBOperator.queryForList("select id_card from candidate_exam where exam_connect_code = ?",new Object[]{examConnectionCode},String.class);
        if(!alreadyExistStudentIdCards.isEmpty()){
            paperExamStudents = paperExamStudents.stream().filter(x->!alreadyExistStudentIdCards.contains(x.getIdCard())).collect(Collectors.toList());
            for (CandidateExam paperExamStudent : paperExamStudents) {
                paperExamStudent.setExamConnectCode(examConnectionCode);
            }
        }
        if(!paperExamStudents.isEmpty()){
            int chunkSize = 1000; // 每批插入1000条记录
            int total = paperExamStudents.size();
            for (int i = 0; i < total; i += chunkSize) {
                int end = Math.min(i + chunkSize, total);
                List<CandidateExam> chunk = candidateExamList.subList(i, end);
                try{
                    batchInsert(chunk);
                }catch (Exception e){
                    log.info("候选者批量插入失败:(已插入)"+(i>total?total:i)+"/"+"(全部)"+total);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Async
    public void sendRequestAndSaveDB(CandidateExam candidateExam) {
        try{
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type","application/json");
            JSONObject requestBodyObject =  new JSONObject(candidateExam);
            requestBodyObject.put("outId",candidateExam.getUuid());
            requestBodyObject.put("showName",candidateExam.getName());
            HttpEntity<String> entity =  new HttpEntity<>(requestBodyObject.toString(),headers);
            ResponseEntity<String> response =  restTemplate.exchange(
                    appUtil.ApiUrlGen(AppThirdPartUrls.candidateCreate),
                    HttpMethod.POST,
                    entity,
                    String.class
            );
            JSONObject body = new JSONObject(response.getBody());
            if(body.get("code").equals(0)&&body.get("message").equals("ok")){
                JSONObject data = (JSONObject)body.get("data");
                DBOperator.update("update candidate_exam set candidate_connect_code = ? where id_card = ? and exam_connect_code = ?",new Object[]{data.get("candidateConnectCode").toString(),candidateExam.getIdCard(),candidateExam.getExamConnectCode()});
                log.info("面试编号:"+candidateExam.getExamConnectCode()+"候选者:"+candidateExam.getIdCard()+"面试码申请成功");
            }else{
                log.info("面试编号:"+candidateExam.getExamConnectCode()+"候选者:"+candidateExam.getIdCard()+"面试码申请失败,失败原因"+body.getString("message"));
            }
        }catch (Exception e){
            e.printStackTrace();
            log.info("面试编号:"+candidateExam.getExamConnectCode()+"候选者:"+candidateExam.getIdCard()+"请求发送失败");
        }
    }

    @Transactional  // 开启事务，确保操作的一致性
    public void batchInsert(List<CandidateExam> candidateExamList) {
        // 批量插入 SQL 语句
        String sql = "INSERT INTO candidate_exam (id_card,zkz_num,exam_connect_code,phone) VALUES (?,?,?,?)";
        // 将 idCards 转换为批量操作所需的参数数组
        List<Object[]> batchArgs = new ArrayList<>();
        for (CandidateExam candidateExam : candidateExamList) {
            batchArgs.add(new Object[]{candidateExam.getIdCard(),candidateExam.getZkzNum(),candidateExam.getExamConnectCode(),candidateExam.getPhone()});
        }
        // 使用 batchUpdate 方法执行批量插入
        DBOperator.batchUpdate(sql,batchArgs);
    }
    public List<String> checkIdCardsExistence(List<String> idCards) throws InterruptedException, ExecutionException {
        List<String> existingIdCards = Collections.synchronizedList(new ArrayList<>());
        List<Future<List<String>>> futures = new ArrayList<>();
        // 分批处理 idCard
        int batchSize = 100;
        for (int i = 0; i < idCards.size(); i += batchSize) {
            int end = Math.min(i + batchSize, idCards.size());
            List<String> batch = idCards.subList(i, end);
            // 使用线程池异步查询数据库
            futures.add(executor.submit(() -> queryDatabaseForIdCards(batch)));
        }
        // 获取所有线程的结果
        for (Future<List<String>> future : futures) {
            existingIdCards.addAll(future.get());
        }
        return existingIdCards;
    }
    private  List<String> queryDatabaseForIdCards(List<String> idCards) {
        List<String> existingIdCards = new ArrayList<>();
        String query = "SELECT id_card FROM candidate WHERE id_card IN (" + String.join(",", Collections.nCopies(idCards.size(), "?")) + ")";
        existingIdCards = DBOperator.queryForList(query, idCards.toArray(), String.class);
        return existingIdCards;
    }
    public JSONObject senGenCandidateConnectionCode(CandidateExam candidateExam) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json");
        JSONObject requestBodyObject = new JSONObject(candidateExam);
        HttpEntity<String> entity = new HttpEntity<>(requestBodyObject.toString(), headers);
        ResponseEntity<String> response = restTemplate.exchange(
                appUtil.ApiUrlGen(AppThirdPartUrls.candidateCreate),
                HttpMethod.POST,
                entity,
                String.class
        );
        return new JSONObject(response.getBody());
    }
}
