package com.yuda.hainafacetofaceai.util;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.http.HttpMethodName;
import com.yuda.hainafacetofaceai.constant.CosConstant;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.net.URL;
import java.util.*;
import java.util.concurrent.TimeUnit;

@Component
@Slf4j
public class BaiDuFaceMatchUtil {
    private static final Object lock = new Object();
    @Autowired
    private COSClient cosClient;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    private String getToken() {
        String auth = stringRedisTemplate.opsForValue().get("mirror:baiduToken");
        if (auth == null) {
            synchronized (lock) {
                auth = stringRedisTemplate.opsForValue().get("mirror:baiduToken");
                if (auth == null) {
                    auth = AuthUtil.getAuth();
                    stringRedisTemplate.opsForValue().set("mirror:baiduToken", auth, 25, TimeUnit.DAYS);
                }
            }
        }
        return auth;
    }
    /**
     * 百度的人脸检测.
     * @return
     */
    public String[] faceMatchBaidu(String idCard,String picName) {
        // 请求url
        String url = "https://aip.baidubce.com/rest/2.0/face/v3/match";
        try {
            //idCard 和 picName  获取
            Date expiration = new Date(new Date().getTime() + 3600 * 1000);
            com.qcloud.cos.model.GeneratePresignedUrlRequest req = new com.qcloud.cos.model.GeneratePresignedUrlRequest(CosConstant.COS_BUCKET, "info_image/" + idCard + ".jpg", HttpMethodName.GET);
            req.setExpiration(expiration);
            URL stuUrl = cosClient.generatePresignedUrl(req);
            com.qcloud.cos.model.GeneratePresignedUrlRequest req2 = new com.qcloud.cos.model.GeneratePresignedUrlRequest(CosConstant.COS_BUCKET, "face_image/" + picName, HttpMethodName.GET);
            req2.setExpiration(expiration);
            URL camImgUrl = cosClient.generatePresignedUrl(req2);
            //从redis 中获取auth
            String accessToken = getToken();
            List<Map<String, String>> list = new ArrayList<>();
            Map<String, String> map1 = new HashMap<>();
            Map<String, String> map2 = new HashMap<>();
            map1.put("image_type", "URL");
            map1.put("face_type", "HYBRID");
            map1.put("image", stuUrl.toString() + "&imageMogr2/thumbnail/500x");
            map1.put("quality_control", "LOW");
            map2.put("image_type", "URL");
            map2.put("face_type", "HYBRID");
            map2.put("image", camImgUrl.toString() + "&imageMogr2/thumbnail/500x");
            map2.put("quality_control", "NORMAL");
            map2.put("liveness_control", "NORMAL");
            list.add(map1);
            list.add(map2);
            String param = GsonUtils.toJson(list);
            String result = HttpUtil.post(url, accessToken, "application/json", param);
            JSONObject jsonObject = new JSONObject(result);
            log.info("人脸认证--验证结果---->" + jsonObject.toString());
            if (jsonObject != null) {
                if (jsonObject.getString("error_msg").equals("SUCCESS")) {
                    JSONObject result1 = jsonObject.getJSONObject("result");
                    Float score = result1.getFloat("score");
                    if (score != null && score >= 80) {
                        return new String[]{"1", "认证成功"};
                    }
                } else {
                    return new String[]{"0", "认证失败"};
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new String[]{"0", "认证失败"};
    }
}
