package com.yuda.hainafacetofaceai.util;

import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.yuda.hainafacetofaceai.annotations.ExcelColumn;

public class ExcelUtil<T> {

    public List<T> parseExcel(InputStream inputStream, Class<T> clazz) throws IOException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        List<T> resultList = new ArrayList<>();
        // 读取 Excel 文件
        Workbook workbook = new XSSFWorkbook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);  // 假设只读取第一个 sheet
        Row headerRow = sheet.getRow(0);  // 第一行是表头
        // 获取列名
        List<String> columnNames = new ArrayList<>();
        Iterator<Cell> headerCells = headerRow.iterator();
        while (headerCells.hasNext()) {
            columnNames.add(headerCells.next().getStringCellValue());
        }
        // 解析数据
        Iterator<Row> rowIterator = sheet.iterator();
        rowIterator.next(); // 跳过表头

        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            T entity = clazz.getDeclaredConstructor().newInstance();

            // 通过反射匹配表头与字段
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isAnnotationPresent(ExcelColumn.class)) {
                    ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
                    String columnName = excelColumn.headerName();
                    // 找到表头列名匹配的索引
                    int columnIndex = columnNames.indexOf(columnName);
                    if (columnIndex != -1) {
                        // 获取对应列的数据
                        Cell cell = row.getCell(columnIndex);
                        String cellValue = getCellValue(cell);
                        // 设置字段值
                        field.setAccessible(true);
                        setFieldValue(entity, field, cellValue);
                    }
                }
            }
            resultList.add(entity);
        }
        workbook.close();
        return resultList;
    }
    private String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING:
                return cell.getStringCellValue();
            case NUMERIC:
                return new DataFormatter().formatCellValue(cell);
            case BOOLEAN:
                return String.valueOf(cell.getBooleanCellValue());
            default:
                return "";
        }
    }
    private void setFieldValue(T entity, Field field, String value) throws IllegalAccessException {
        if (field.getType() == String.class) {
            field.set(entity, value);
        } else if (field.getType() == Integer.class) {
            field.set(entity, Integer.parseInt(value));
        }
        // 其他类型可以继续添加支持
    }
}
