package com.yuda.hainafacetofaceai.Interceptor;

import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;


@Component
@Slf4j
public class LoginInterceptor implements HandlerInterceptor {
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.info("登录拦截认证");
        String key = request.getHeader("Token");
        if(key!=null&&redisTemplate.opsForValue().get(key)!=null){
            String value  =  redisTemplate.opsForValue().get(key);
            JSONObject jsonObject = new JSONObject(value);
            String zkzNum = jsonObject.get("zkzNum").toString();
            String idCard = jsonObject.get("idCard").toString();
            String examConnectionCode = jsonObject.get("examConnectionCode").toString();
            log.info("准考证号:"+zkzNum+"_身份证号:"+idCard+"_参加面试编号:"+examConnectionCode+"_登入");
            redisTemplate.opsForValue().set(key,value,60*60*2, TimeUnit.SECONDS);
            return true;
        }else{
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            Map data = new HashMap<String,Object>(){{
                put("tag",1);
                put("code",50001);
                put("message","登录状态过期");
            }};
            response.getWriter().write(new JSONObject(data).toString());
            return false;
        }
    }
    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }
    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}
