package com.yuda.hainafacetofaceai.config;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.region.Region;
import com.yuda.hainafacetofaceai.constant.CosConstant;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CosConfig {

    @Bean("cosClient")
    public COSClient cosClient() {
        COSCredentials cred = new BasicCOSCredentials(CosConstant.COS_AccesskeyID, CosConstant.COS_AccesskeySECRET);
        Region region = new Region(CosConstant.COS_ENDPOINT);
        ClientConfig clientConfig = new ClientConfig(region);
        clientConfig.setHttpProtocol(HttpProtocol.https);
        return new COSClient(cred, clientConfig);
    }

}
