package com.yuda.hainafacetofaceai.controller;

import com.yuda.hainafacetofaceai.util.BaiDuFaceMatchUtil;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping("/faceMatchApi")
@Slf4j
public class FaceMatchController {
    @Autowired
    private JdbcTemplate DBOperator;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private BaiDuFaceMatchUtil faceMatch;
    @PostMapping("/uploadFacePic/{examConnectionCode}/{zkzNum}")
    public ResponseEntity examFacePicUpload(@PathVariable String examConnectionCode, @PathVariable String zkzNum, @RequestBody String images){
        JSONObject object = new JSONObject(images);
        String faceImage = object.getString("zjImage");
        try{
            DBOperator.update("update candidate_exam set exam_image_face = ? where zkz_num = ? and exam_connection_code = ?",new Object[]{faceImage,zkzNum,examConnectionCode});
            log.info("准考证:"+zkzNum+"参加面试编号:"+examConnectionCode+"上传实时人脸照片成功");
            JSONObject responseBody = new JSONObject();
            responseBody.put("code",200);
            responseBody.put("message","上传成功");
            return ResponseEntity.ok(responseBody);
        }catch (Exception e){
            log.info("准考证:"+zkzNum+"参加面试编号:"+examConnectionCode+"上传实时人脸照片失败");
            JSONObject responseBody = new JSONObject();
            responseBody.put("code",500);
            responseBody.put("message","上传人脸照片失败");
            return ResponseEntity.badRequest().body(new JSONObject().toString());
        }
    }
    @PostMapping("/faceMatch/{examConnectionCode}/{idCard}/{zkzNum}")
    public ResponseEntity faceMatch(@PathVariable String idCard,@PathVariable String examConnectionCode,@PathVariable String zkzNum,@RequestParam("picName") String picName){
        log.info("faceMatch正在校验-》身份证号:"+idCard+"参加面试编号:"+examConnectionCode+"_人脸照片");
        String message = "";
        if(check(examConnectionCode,idCard,message)){
            JSONObject responseBody = new JSONObject();
            responseBody.put("code",500);
            responseBody.put("message",message);
            return ResponseEntity.badRequest().body(responseBody);
        }
        String[] result = faceMatch.faceMatchBaidu(idCard,picName);
        if(result[0].equals("1")){
            stringRedisTemplate.opsForValue().increment("face_success:" + examConnectionCode + "_" + idCard);
            DBOperator.update("update candidate_exam set status_face = 1 where exam_connection_code = ? and zkz_num = ?",new Object[]{examConnectionCode,zkzNum});
            log.info("身份证:"+idCard+"参加面试编号:"+examConnectionCode+"人脸验证成功");
        }else{
            stringRedisTemplate.opsForValue().increment("face_error:" + examConnectionCode + "_" + idCard);
            log.info("身份证:"+idCard+"参加面试编号:"+examConnectionCode+"人脸验证失败");
        }
        JSONObject responseBody = new JSONObject();
        responseBody.put("code",200);
        responseBody.put("message","校验成功");
        return ResponseEntity.ok(responseBody.toString());
    }
    private boolean check(String examConnectionCode, String idCard,String message) {
        String success = stringRedisTemplate.opsForValue().get("face_success:" + examConnectionCode + "_" + idCard);
        if (!StringUtils.isEmpty(success)) {
            if (Integer.parseInt(success) >= 1) {
                message =  "请勿重复提交";
                return true;
            }
        }
        String s = stringRedisTemplate.opsForValue().get("face_error:" + examConnectionCode + "_" + idCard);
        if (!StringUtils.isEmpty(s)) {
            if (Integer.parseInt(s) >=3) {
                message = "失败次数超3次";
                return true;
            }
        }
        return false;
    }
}
