package com.yuda.hainafacetofaceai.util;


import com.alibaba.fastjson.JSONObject;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.Headers;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.model.GeneratePresignedUrlRequest;
import com.tencent.cloud.CosStsClient;
import com.tencent.cloud.Response;
import com.yuda.hainafacetofaceai.constant.CosConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.net.URL;
import java.util.Date;
import java.util.TreeMap;

@Component
public class CosUtil {

    @Autowired
    private COSClient cosClient;

    private String createTempCosSignUrl(String bucketName, String key){
        GeneratePresignedUrlRequest req =
                new GeneratePresignedUrlRequest(bucketName, key, HttpMethodName.GET);
        // 设置签名过期时间(可选), 若未进行设置则默认使用ClientConfig中的签名过期时间(30分钟)
        // 这里设置签名在一分钟后过期
        Date expirationDate = new Date(System.currentTimeMillis() + 6000 * 1000 * 60 * 24);
        req.setExpiration(expirationDate);
        req.addRequestParameter("x-cos-traffic-limit", "8388608");
        // 填写本次请求的头部。Host 必填
        String name = cosClient.getClientConfig().getEndpointBuilder().buildGeneralApiEndpoint(bucketName);
        req.putCustomRequestHeader(Headers.HOST, name);
        //req.putCustomRequestHeader("header1", "value1");
        URL url = cosClient.generatePresignedUrl(req);
        return url.toString();
    }

    public String getSignatureForWeb(String bucket, String region) throws Exception {
        TreeMap<String, Object> config = new TreeMap<>();
        config.put("SecretId",CosConstant.COS_AccesskeyID);
        config.put("SecretKey",CosConstant.COS_AccesskeySECRET);
        config.put("durationSeconds", 7200);
        config.put("bucket",bucket);
        config.put("region",region);
        config.put("allowPrefix", "*");
        String[] allowActions = new String[]{
                "name/cos:PutObject",
                "name/cos:PostObject",
                "name/cos:InitiateMultipartUpload",
                "name/cos:ListMultipartUploads",
                "name/cos:ListParts",
                "name/cos:UploadPart",
                "name/cos:CompleteMultipartUpload"
        };
        config.put("allowActions", allowActions);
        Response response = CosStsClient.getCredential(config);
        JSONObject credential = new JSONObject();
        credential.put("bucket", bucket);
        credential.put("region", region);
        credential.put("credential",response);
        return credential.toString();
    }

}
