package com.yuda.paperstudentconfig.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yuda.paperstudentconfig.entity.SpartaUser;
import com.yuda.paperstudentconfig.service.impl.SpartaUserServiceImpl;
import com.yuda.paperstudentconfig.utils.Constant;
import com.yuda.paperstudentconfig.utils.ResponseResult;
import com.yuda.paperstudentconfig.vo.AccountVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

@RestController
@RequestMapping("/login")
public class LoginController {

    @Resource
    private SpartaUserServiceImpl spartaUserService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @PostMapping("/signIn")
    public ResponseResult login(@RequestBody AccountVo accountVo){

        String username = accountVo.getUsername();
        String password = accountVo.getPassword();
        if (StringUtils.isEmpty(username)) {
            return ResponseResult.fail(400, "请填写登录账号");
        }

        if (StringUtils.isEmpty(password)) {
            return ResponseResult.fail(400, "请填写登录密码");
        }

        QueryWrapper<SpartaUser> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("username", username).eq("password",password);
//                .eq("password", DigestUtils.md5DigestAsHex(password.getBytes()));
        SpartaUser account = spartaUserService.getOne(queryWrapper);

        if (account != null) { // 账号正确
            String token = spartaUserService.generatorToken(account);
            stringRedisTemplate.opsForValue().set(Constant.token + account.getUsername(), token, 24, TimeUnit.HOURS);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("token", token);
            jsonObject.put("userId", account.getId());
            return ResponseResult.success("操作成功", jsonObject);
        } else {
            return ResponseResult.fail(400, "用户名或密码不正确");
        }
    }

    @PostMapping("/signOut")
    public ResponseResult logout(@RequestBody AccountVo accountVo) {
        // 从Redis中删除token
        String key = Constant.token + accountVo.getUsername();
        Boolean deleted = stringRedisTemplate.delete(key);
        if (Boolean.TRUE.equals(deleted)) {
            return ResponseResult.success("退出成功");
        } else {
            return ResponseResult.fail(400, "退出失败，token不存在或已过期");
        }
    }
}
