package com.yuda.paperstudentconfig.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.yuda.paperstudentconfig.entity.SpartaExamStudent;
import com.yuda.paperstudentconfig.entity.SpartaPaper;
import com.yuda.paperstudentconfig.entity.SpartaUserPaper;
import com.yuda.paperstudentconfig.service.impl.SpartaExamStudentServiceImpl;
import com.yuda.paperstudentconfig.service.impl.SpartaPaperServiceImpl;
import com.yuda.paperstudentconfig.service.impl.SpartaUserPaperServiceImpl;
import com.yuda.paperstudentconfig.utils.ExcelImportUtil;
import com.yuda.paperstudentconfig.utils.ResponseResult;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/main")
public class MainController {
    @Resource
    private SpartaPaperServiceImpl spartaPaperService;
    @Resource
    private SpartaUserPaperServiceImpl spartaUserPaperService;
    @Resource
    private SpartaPaperServiceImpl spartaPaperServiceImpl;
    @Resource
    private SpartaExamStudentServiceImpl spartaExamStudentService;
    @Resource
    private COSClient cosClient;

    @RequestMapping("/index")
    public ResponseResult index(
            @RequestParam String userId,
            @RequestParam(defaultValue = "1") Integer pageNum,
            @RequestParam(defaultValue = "10") Integer pageSize) {
        Page<SpartaPaper> page = new Page<>(pageNum, pageSize);
        Page<SpartaPaper> result = spartaPaperService.getPapersByUserId(page, userId);
        return ResponseResult.success("查询成功", result);
    }



    @PostMapping("/addPaper")
    public ResponseResult addPaper(@RequestBody SpartaUserPaper spartaUserPaper) {
        if (spartaUserPaper.getUserId() == null || spartaUserPaper.getPaperId() == null) {
            return ResponseResult.fail(400, "用户ID和试卷ID不能为空");
        }
        SpartaUserPaper spartaUserPaper1 = spartaUserPaperService.getByUserIdAndPaperId(spartaUserPaper.getUserId(),spartaUserPaper.getPaperId(),spartaUserPaper.getExamUuid());
        if(spartaUserPaper1!=null){
            return ResponseResult.success("试卷添加成功");
        }
        boolean result = spartaUserPaperService.save(spartaUserPaper);
        if (result) {
            return new ResponseResult(200, "试卷添加成功");
        } else {
            return ResponseResult.fail(500, "试卷添加失败");
        }
    }

    @GetMapping("/papers")
    public ResponseResult getPapers(
            @RequestParam(defaultValue = "1") Integer pageNum,
            @RequestParam(defaultValue = "10") Integer pageSize) {

        Page<SpartaPaper> page = new Page<>(pageNum, pageSize);
        Page<SpartaPaper> result = spartaPaperService.page(page);

        return ResponseResult.success("查询成功", result);
    }

    @PostMapping("/importStudents")
    @Transactional(rollbackFor = Exception.class)
    public ResponseResult importStudents(
            @RequestParam("file") MultipartFile file,
            @RequestParam String userId,
            @RequestParam Integer paperId,
            @RequestParam String examUuid) throws IOException {
        // 校验文件类型
        if (!file.getOriginalFilename().endsWith(".xlsx") && !file.getOriginalFilename().endsWith(".xls")) {
            return ResponseResult.fail(400, "仅支持Excel文件上传");
        }
        // 解析Excel文件
        List<SpartaExamStudent> students = ExcelImportUtil.importExcel(file, SpartaExamStudent.class);
        for (SpartaExamStudent student : students) {
            if(student.getZkzNum()==null){
                return ResponseResult.fail(400, "准考证号不能为空");
            }
            if(student.getSfzNum()==null){
                return ResponseResult.fail(400, "身份证号不能为空");
            }
            if(student.getName()==null){
                return ResponseResult.fail(400, "姓名不能为空");
            }
            if(!student.getZkzNum().equals(student.getSfzNum())){
                return ResponseResult.fail(400, "准考证号和身份证号不一致");
            }
        }
        // 绑定用户和试卷关系
        for (SpartaExamStudent student : students) {
            student.setUserId(userId);
            student.setPaperId(paperId);
            student.setExamUuid(examUuid);
            student.setAvatarKey("qj240612/test.png");
            student.setAvatarBucket("xjheadphoto-1317275686");
            student.setAvatarEndpoint("ap-beijing");
        }
        // 批量保存或更新到数据库
        boolean result = true;
        for (SpartaExamStudent student : students) {
            QueryWrapper<SpartaExamStudent> wrapper = new QueryWrapper<>();
            wrapper.eq("sfz_num", student.getSfzNum())
                    .eq("paper_id", paperId)
                    .eq("exam_uuid", examUuid);
            SpartaExamStudent existingStudent = spartaExamStudentService.getOne(wrapper);
            if (existingStudent != null) {
                student.setId(existingStudent.getId()); // 设置ID以便更新
                result &= spartaExamStudentService.updateById(student);
            } else {
                result &= spartaExamStudentService.save(student);
            }
        }
        if (result) {
            return ResponseResult.success("导入成功", students.size());
        } else {
            return ResponseResult.fail(500, "导入失败");
        }
    }

    @GetMapping("/getExamStudents")
    public ResponseResult getExamStudents(
            @RequestParam String userId,
            @RequestParam Long paperId,
            @RequestParam String examUuid,
            @RequestParam(defaultValue = "1") Integer pageNum,
            @RequestParam(defaultValue = "10") Integer pageSize) {
        List<String> subjectOrder = Arrays.asList(
                "语文", "数学", "英语", "物理", "化学", "生物", "政治", "历史", "地理","数理探究1","数理探究2"
        );
        Page<SpartaExamStudent> page = new Page<>(pageNum, pageSize);
        Page<SpartaExamStudent> result = spartaExamStudentService.getExamStudents(page, userId, paperId,examUuid);
        if(result!=null){
            List<SpartaExamStudent> students = result.getRecords();
            for (SpartaExamStudent student : students) {
                // 构建文件前缀
                String prefix = "answer/" + student.getExamUuid()+"_"+ paperId + "_" + student.getSfzNum() + "_";
                // 列出COS中的文件
                ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
                listObjectsRequest.setBucketName("mkty-1317275686");
                listObjectsRequest.setPrefix(prefix);
                ObjectListing objectListing = cosClient.listObjects(listObjectsRequest);
                List<String> fileNames = new ArrayList<>();
                for(COSObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                    fileNames.add(objectSummary.getKey());
                }
                if(!fileNames.isEmpty()){
                    List<String> answerSubjectStatus = fileNames.stream()
                            .map(fileName -> {
                                String[] parts = fileName.split("_");
                                return parts.length > 3 ? parts[3] : "";  // 安全获取第4部分
                            })
                            .filter(s -> !s.isEmpty())  // 过滤空字符串
                            .distinct()  // 去重// 按指定顺序排序
                            .collect(Collectors.toList());
                    String status = answerSubjectStatus.stream()
                            .map(s -> s.replace(".db", ""))
                            .sorted(Comparator.comparingInt(subjectOrder::indexOf))
                            .collect(Collectors.joining("|"));
                    student.setAnswerStatus(status);
                }
            }
        }
        return ResponseResult.success("查询成功", result);
    }

}
