package com.yuda.paperstudentconfig.interceptor;

import com.alibaba.fastjson.JSON;
import com.yuda.paperstudentconfig.utils.Constant;
import com.yuda.paperstudentconfig.utils.ResponseResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @Author ryze
 * @Date 2024/2/22
 */

@Component
@Slf4j
public class LoginInterceptor implements HandlerInterceptor {
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String token = request.getHeader("token");
        Boolean hasKey = stringRedisTemplate.hasKey(Constant.token + token);
        String url = request.getRequestURL().toString();
        log.info("访问接口 {}", url);
        // token过期了
        if (!hasKey) {
            log.info(">>>token过期, 跳至登录页");
            ResponseResult responseResult = ResponseResult.fail(401, "token过期了");
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().write(JSON.toJSONString(responseResult));
            return false;
        }
        return true;
    }

}
