package com.yuda.paperstudentconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yuda.paperstudentconfig.entity.SpartaExamStudent;
import com.yuda.paperstudentconfig.mapper.SpartaExamStudentMapper;
import com.yuda.paperstudentconfig.service.SpartaExamStudentService;
import org.springframework.stereotype.Service;

@Service
public class SpartaExamStudentServiceImpl extends ServiceImpl<SpartaExamStudentMapper, SpartaExamStudent> implements SpartaExamStudentService {
    @Override
    public Page<SpartaExamStudent> getExamStudents(Page<SpartaExamStudent> page, String userId, Long paperId,String examUuid) {
        return baseMapper.selectExamStudents(page, userId, paperId,examUuid);
    }

    @Override
    public boolean removeByUserIdAndPaperId(String userId, Integer paperId) {
        QueryWrapper<SpartaExamStudent> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id", userId).eq("paper_id", paperId);
        return this.remove(queryWrapper);
    }
}