package com.yuda.paperstudentconfig.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yuda.paperstudentconfig.entity.SpartaUser;
import com.yuda.paperstudentconfig.mapper.SpartaUserMapper;
import com.yuda.paperstudentconfig.service.SpartaUserService;
import com.yuda.paperstudentconfig.utils.Constant;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

@Service
public class SpartaUserServiceImpl extends ServiceImpl<SpartaUserMapper, SpartaUser> implements SpartaUserService {
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public String generatorToken(SpartaUser account) {
        String oldToken = stringRedisTemplate.opsForValue().get(Constant.tokenWithUserName + account.getUsername());
        if (!StringUtils.isEmpty(oldToken)) {
            //把老token删除
            stringRedisTemplate.delete(Constant.token + oldToken); //实现第二个人把第一个人顶掉
        }
        //生成一个token
        String token = UUID.randomUUID().toString();
        stringRedisTemplate.opsForValue().set(Constant.token + token, JSON.toJSONString(account), Constant.tokenInvalidTime, TimeUnit.HOURS);
        return token;
    }
}