package com.yuda.paperstudentconfig.utils;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.Headers;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.model.GeneratePresignedUrlRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;

@Component
public class CosUtils {

    @Autowired
    private  COSClient cosClient;

    public String generateSimplePreSignedDownloadUrl(String bucketName, String key) {

        try {
            key  = URLDecoder.decode(key, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        GeneratePresignedUrlRequest req =
                new GeneratePresignedUrlRequest(bucketName, key, HttpMethodName.GET);
        // 设置签名过期时间(可选), 若未进行设置则默认使用ClientConfig中的签名过期时间(30分钟)
        // 这里设置签名在一分钟后过期
        Date expirationDate = new Date(System.currentTimeMillis() + 6000 * 1000 * 60 * 24);
        req.setExpiration(expirationDate);
//        req.addRequestParameter("x-cos-traffic-limit", "8388608");
        // 填写本次请求的头部。Host 必填
        String name = cosClient.getClientConfig().getEndpointBuilder().buildGeneralApiEndpoint(bucketName);
        req.putCustomRequestHeader(Headers.HOST, name);
        URL url = cosClient.generatePresignedUrl(req);
        return url.toString();
    }
}
