package com.yuda.paperstudentconfig.utils;

import java.util.HashMap;

public class PageUtils {

    public static HashMap<String, Object> getPage(Object page) {
        HashMap<String, Object> hashMap = new HashMap<>();
        if (page instanceof org.springframework.data.domain.Page) {
            // 处理 Spring Data 的分页对象
            org.springframework.data.domain.Page<?> springPage = (org.springframework.data.domain.Page<?>) page;
            hashMap.put("data", springPage.getContent());
            hashMap.put("totalElements", springPage.getTotalElements());
            hashMap.put("totalPages", springPage.getTotalPages());
        } else if (page instanceof com.baomidou.mybatisplus.extension.plugins.pagination.Page) {
            // 处理 MyBatis-Plus 的分页对象
            com.baomidou.mybatisplus.extension.plugins.pagination.Page<?> mybatisPage = (com.baomidou.mybatisplus.extension.plugins.pagination.Page<?>) page;
            hashMap.put("data", mybatisPage.getRecords());
            hashMap.put("totalElements", mybatisPage.getTotal());
            hashMap.put("totalPages", mybatisPage.getPages());
        } else {
            throw new IllegalArgumentException("不支持的Page类型");
        }
        return hashMap;
    }

}
