package com.yuda.paperstudentconfig.utils;

import lombok.Data;

@Data
public class ResponseResult {

    /**
     * 结果编码
     */
    private int code;

    /**
     * 返回值
     */
    private Object data;

    /**
     * 提示
     */
    private String message;

    public ResponseResult(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public ResponseResult(int code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static ResponseResult success() {
        return new ResponseResult(200, "操作成功");
    }

    public static ResponseResult success(String message) {
        return new ResponseResult(200, message);
    }


    public static ResponseResult success(String message, Object data) {
        return new ResponseResult(200, message, data);
    }

    public static ResponseResult fail() {
        return new ResponseResult(500, "操作失败");
    }

    public static ResponseResult fail(int code, String message) {
        return new ResponseResult(code, message);
    }
}
