package com.yuda.paperstudentconfig.utils;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class TimeZoneConvert {

    public static String AsiaShangHai(String isoDateString){

        Instant instant = Instant.parse(isoDateString);

        // 将 Instant 对象转换为本地时区的 ZonedDateTime 对象
        ZoneId localZone = ZoneId.systemDefault(); // 获取系统默认时区，你也可以使用特定时区，比如 ZoneId.of("Asia/Shanghai")
        ZonedDateTime localTime = instant.atZone(localZone);

        // 格式化本地时区时间为字符串
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        String localTimeString = localTime.format(formatter);

        return localTimeString;
    }

    public static String DateFormat(Date date){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatDate = sdf.format(date);
        return formatDate;
    }

}
