package com.example.pdfgenerator.LocalFileMule;


import com.example.pdfgenerator.config.MyDataSourceConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@SpringBootTest
public class FIleTogether {

    @Autowired
    private COSClient cosClient;

    private static final String bucketName = "schoolreportpdf-1317275686";




    @Test
    public void fileAllToOne(){

        JdbcTemplate reportTemplate = MyDataSourceConfig.getReportJdbcTemplate();

        String sql = "SELECT\n" +
                "\texam_id,\n" +
                "\tregion1 as region,\n" +
                "\tprovince,\n" +
                "\tschool,\n" +
                "\tsub_subject AS subject \n" +
                "FROM\n" +
                "\tbase_school_subject_tda20241031 \n" +
                "WHERE\n" +
                "\tsubject_type = '常规' \n" +
                "\tAND province = '山东省' \n" +
                "ORDER BY\n" +
                "\tschool,school_subject_score_mean DESC ";

        List<Args> argsList = reportTemplate.query(sql,new Object[]{},new BeanPropertyRowMapper<>(Args.class));

        Map<String, List<Args>>  argsDecideBySchool  = argsList.stream().collect(Collectors.groupingBy(Args::getSchool));

        for (String key : argsDecideBySchool.keySet()) {
            List<Args> args =  argsDecideBySchool.get(key);
            //下载学科报告
            for (Args arg : args) {
                String bucketKey = "PdfSubject/"+arg.getRegion()+arg.getProvince()+arg.getSchool()+arg.getSubject()+arg.getExamId()+".pdf";
                String localFilePath = "D:/"+"schoolReport/"+arg.getProvince()+"/"+arg.getSchool();
                File file = new File(localFilePath);
                if(!file.exists()){
                    file.mkdirs();
                }
                downloadFile(cosClient,bucketName,bucketKey,localFilePath);
            }
            //下载综合报告
            String oneKey = "PdfDir/"+args.get(0).getRegion()+args.get(0).getProvince()+args.get(0).getSchool()+"xxxx"+args.get(0).getExamId()+".pdf";
            String filePath =  "D:/"+"schoolReport/"+args.get(0).getProvince()+"/"+args.get(0).getSchool();
            downloadFile(cosClient,bucketName,oneKey,filePath);
        }


    }

    // 5. 下载文件的具体方法
    public static void downloadFile(COSClient cosClient, String bucketName, String fileKey, String localFolder) {
        try {
            // 获取文件对象
            COSObject cosObject = cosClient.getObject(bucketName,fileKey.replace("xxxx",""));
            COSObjectInputStream inputStream = cosObject.getObjectContent();


            // 设置本地文件路径
            File localFile = new File(localFolder + "/" + fileKey.replace("PdfSubject/","").replace("PdfDir/","").replace("xxxx","综合"));

            // 创建本地文件夹
            if (!localFile.getParentFile().exists()) {
                localFile.getParentFile().mkdirs();  // 如果文件夹不存在，则创建
            }

            // 保存文件到本地
            Files.copy(inputStream, Paths.get(localFile.toURI()));

            System.out.println("File downloaded successfully: " + fileKey + " to " + localFile.getAbsolutePath());
        } catch (IOException e) {
            System.err.println("Error downloading file " + fileKey);
            e.printStackTrace();
        }
    }


}
