package com.example.pdfgenerator;

import com.example.pdfgenerator.Dto.RetryCommand;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jdbc.core.JdbcTemplate;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Author ryze
 * @Date 2025/9/26
 */

@SpringBootTest
@Slf4j
public class UploadPdfToCosTest {

    String bucketName = "schoolreportpdf-1317275686";


    @Autowired
    private COSClient cosClient;

    @Test
    public void test1() {
        // 1.上传学校报告
        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getTestJdbcTemplate();

        reportJdbcTemplate.queryForList("select * from dp_total_score");
        File basicFile = new File("F:\\myworkSpace\\basic\\");
        File[] basicFiles = basicFile.listFiles();
        assert basicFiles != null;

        for (File file : basicFiles) {
            String prefix = "PdfDir/" + file.getName();
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, prefix, file);
            try {
                PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                log.info(putObjectResult.getRequestId());
                //file.delete();
            } catch (CosServiceException e) {
                log.info("cos服务出现问题");
                e.printStackTrace();
            } catch (CosClientException e) {
                log.info("cos客户端出现问题" + file.getName() + "文件上传有误,重新上传");
                e.printStackTrace();
            }
        }


        //3.上传班级综合报告

        //3.上传班级科目分析报告
    }

    // 2.测试上传学校科目报告
    @Test
    public void test2Test() {

        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getTestJdbcTemplate();

        List<Map<String, Object>> mapList = reportJdbcTemplate.queryForList("SELECT DISTINCT\n" +
                "\ta.school_id,\n" +
                "\tc.name,\n" +
                "\ta.subject_id,\n" +
                "\tb.desc\n" +
                "FROM\n" +
                "\tdp_subject_score a\n" +
                "\tLEFT JOIN \n" +
                "\tsparta_subject b \n" +
                "\ton a.subject_id =b.id\n" +
                "\tLEFT JOIN \n" +
                "\tsparta_school c on a.school_id = c.id");
        File basicFile = new File("F:\\myworkSpace\\subject\\");
        File[] basicFiles = basicFile.listFiles();
        assert basicFiles != null;


        List<String> list = new ArrayList<>();


        for (File file : basicFiles) {
            list.add(file.getName());
        }

        for (Map<String, Object> map : mapList) {
            String schoolName = map.get("name").toString();
            String subjectName = map.get("desc").toString();
            if (list.contains(subjectName) && list.contains(schoolName)) {
                System.out.println("包含");
            } else {
                System.out.println("schoolName = " + schoolName + " subjectName = " + subjectName + "不包含");
            }
        }

        //3.上传班级综合报告

        //4.上传班级科目分析报告
    }


    @Test
    public void test2() {
        // 1.上传学校报告
        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getTestJdbcTemplate();

        reportJdbcTemplate.queryForList("select * from dp_total_score");
        File basicFile = new File("F:\\myworkSpace\\subject\\");
        File[] basicFiles = basicFile.listFiles();
        assert basicFiles != null;

        for (File file : basicFiles) {
            String prefix = "PdfSubject/" + file.getName();
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, prefix, file);
            try {
                PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                log.info(putObjectResult.getRequestId());
                //file.delete();
            } catch (CosServiceException e) {
                log.info("cos服务出现问题");
                e.printStackTrace();
            } catch (CosClientException e) {
                log.info("cos客户端出现问题" + file.getName() + "文件上传有误,重新上传");
                e.printStackTrace();
            }
        }


    }

    //3.上传班级综合报告
    @Test
    public void testZh() {


        String examUuid = "TDA20250918G11";
        String typeName = "班级综合报告";

        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getTestJdbcTemplate();

        List<Map<String, Object>> mapList = reportJdbcTemplate.queryForList("\tSELECT DISTINCT\n" +
                "\t c.province_name,\n" +
                "\t IF(c.province_name = '山东省','改革3+3','改革3+1+2') as type,\n" +
                "  a.school_id,\n" +
                "\tc.name,\n" +
                "\ta.banji_name,\n" +
                "\tCONCAT(IF(c.province_name = '山东省','改革3+3','改革3+1+2'),c.province_name,c.name,a.banji_name,'TDA20250918G11','.pdf') as xx\n" +
                "FROM\n" +
                "\tdp_ques_score a\n" +
                "\tLEFT JOIN \n" +
                "\tsparta_school c on a.school_id = c.id\n" +
                "\t\n" +
                "\tORDER BY  a.school_id,a.banji_name ");
        File basicFile = new File("F:\\myworkSpace\\Class\\Basic");

        for (Map<String, Object> map : mapList) {
            String provinceName = map.get("province_name").toString();
            String schoolName = map.get("name").toString();
            String banjiName = map.get("banji_name").toString();
            String path = map.get("xx").toString();

            File file2 = new File(basicFile, path);
            if (!file2.exists()) {
                System.out.println(path + "  不存在");
            } else {
                System.out.println("存在");

                String prefix = "class/" + examUuid + "/" + provinceName + "/" + schoolName + "/" + typeName + "/" + banjiName + "/" + path;
                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, prefix, file2);
                try {
                    PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                    log.info(putObjectResult.getRequestId());
                    //file.delete();
                } catch (CosServiceException e) {
                    log.info("cos服务出现问题");
                    e.printStackTrace();
                } catch (CosClientException e) {
                    log.info("cos客户端出现问题" + file2.getName() + "文件上传有误,重新上传");
                    e.printStackTrace();
                }
            }
        }
    }


    //4.上传班级科目分析报告
    @Test
    public void testFx() {


        String examUuid = "TDA20250918G11";
        String typeName = "班级学科报告";

        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getTestJdbcTemplate();

        List<Map<String, Object>> mapList = reportJdbcTemplate.queryForList("\t\tSELECT DISTINCT\n" +
                "\tc.province_name,\n" +
                "  a.school_id,\n" +
                "\tc.name,\n" +
                "\ta.banji_name,\n" +
                "\td.desc,\n" +
                "\ta.subject_id,\n" +
                "\tCONCAT(IF(c.province_name = '山东省','改革3+3','改革3+1+2'),c.province_name,c.name,d.desc,'TDA20250918G11',d.desc,a.banji_name,'.pdf') as xx\n" +
                "FROM\n" +
                "\tdp_subject_score a\n" +
                "\tLEFT JOIN \n" +
                "\tsparta_school c on a.school_id = c.id\n" +
                "\tLEFT JOIN sparta_subject d on a.subject_id = d.id\n" +
                "\tGROUP BY a.school_id,a.banji_name,a.subject_id");
        File basicFile = new File("F:\\myworkSpace\\Class\\Subject");

        for (Map<String, Object> map : mapList) {
            String provinceName = map.get("province_name").toString();
            String schoolName = map.get("name").toString();
            String banjiName = map.get("banji_name").toString();
            String subjectName = map.get("desc").toString();
            String path = map.get("xx").toString();

            File file2 = new File(basicFile, path);
            if (!file2.exists()) {
                System.out.println(path + "  不存在");
            } else {
                System.out.println("存在");

                String prefix = "class/" + examUuid + "/" + provinceName + "/" + schoolName + "/" + typeName + "/" + banjiName + "/" +subjectName+"/"+ path;
                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, prefix, file2);
                try {
                    PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                    log.info(putObjectResult.getRequestId());
                    //file.delete();
                } catch (CosServiceException e) {
                    log.info("cos服务出现问题");
                    e.printStackTrace();
                } catch (CosClientException e) {
                    log.info("cos客户端出现问题" + file2.getName() + "文件上传有误,重新上传");
                    e.printStackTrace();
                }
            }
        }
    }

}
