package com.example.pdfgenerator.controller;

import com.example.pdfgenerator.Dto.Personal;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.qcloud.cos.demo.BucketRefererDemo.cosClient;

@RestController
@RequestMapping("/per")
public class PersonalPdGenController {
    private static final Logger logger = LoggerFactory.getLogger(PersonalPdGenController.class);
    private static Map<String,String> fileToUrl = new HashMap<>();
    JdbcTemplate jdbcTemplate = MyDataSourceConfig.getBasicTemplate();
    @GetMapping("/gen")
    public ResponseEntity  geBasicReport() throws IOException {
        List<Personal> list = jdbcTemplate.query("select sfz_num,zkz_num from dp_total_score", new BeanPropertyRowMapper<>(Personal.class));
        for (Personal parameter : list) {
            String command = "node /myworkSpace/puppeteer.js \"https://yanzheng.cssat.cn/preReport#/" + parameter.getSfzNum() + "/CACAPRE20250322\" pdf";
            String fileName = "/myworkSpace/personal/" + parameter.getZkzNum() + ".pdf";
            command = command
                    .concat(" ").concat(fileName);
            parameter.setCommand(command);
            parameter.setPrefix("/myworkSpace/personal/");
            fileToUrl.put(fileName.replace("/myworkSpace/personal/", ""), "CACAPRE20250322/" + fileName.replace("/myworkSpace/personal/", ""));
        }
        List<Personal> retryCommands = new ArrayList<>();
        int i = 0;
        for (Personal parameters : list) {
            logger.info("正在生成cacaPre:sfznum="+parameters.getSfzNum()+"zkznum="+parameters.getZkzNum()+"进度"+(++i)+"/"+list.size());
            ProcessBuilder processBuilderSubject = new ProcessBuilder();
            processBuilderSubject.command("cmd.exe", "/c", parameters.getCommand());
            processBuilderSubject.redirectErrorStream(true); // 合并标准输出和错误输出
            Process processSubject = null;
            try {
                processSubject = processBuilderSubject.start();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
            BufferedReader readerSubject = new BufferedReader(new InputStreamReader(processSubject.getInputStream()));
            String lineSubject;
//                        while (true) {
//                            try {
//                                if (!((lineSubject = readerSubject.readLine()) != null)) break;
//                            } catch (IOException e) {
//                                throw new RuntimeException(e);
//                            }
//                        }
            while ((lineSubject = readerSubject.readLine()) != null) {
                // 如果输出了 "DONE"，表示生成完毕
                if ("DONE".equals(lineSubject)) {
                    break;  // 跳出循环
                }
            }
            try {
                int exitCodeSubject = processSubject.waitFor();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            File subjectFile = new File("/myworkSpace/personal/");
            File[] subjectFiles = subjectFile.listFiles();
            assert subjectFiles != null;
            for (File file : subjectFiles) {
                PutObjectRequest putObjectRequest = new PutObjectRequest("scorereport-1317275686", fileToUrl.get(file.getName()), file);
                try {
                    PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                    logger.info(putObjectResult.getRequestId());
                    logger.info("上传文件"+file.getName());
                    file.delete();
                } catch (CosServiceException e) {
                    logger.info("cos服务出现问题");
                    e.printStackTrace();
                } catch (CosClientException e) {
                    logger.info("cos客户端出现问题" + file.getName() + "文件上传有误,重新上传");
                    Personal retryCommand = new Personal();
                    retryCommand.setZkzNum(parameters.getZkzNum());
                    retryCommand.setSfzNum(parameters.getSfzNum());
                    retryCommand.setCommand(parameters.getCommand());
                    retryCommand.setPrefix(parameters.getPrefix());
                    retryCommands.add(retryCommand);
                    e.printStackTrace();
                }
            }
        }
        if (retryCommands.size() > 0) {
            for (Personal parameters : list) {
                ProcessBuilder processBuilderSubject = new ProcessBuilder();
                processBuilderSubject.command("cmd.exe", "/c", parameters.getCommand());
                processBuilderSubject.redirectErrorStream(true); // 合并标准输出和错误输出
                Process processSubject = null;
                try {
                    processSubject = processBuilderSubject.start();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
                BufferedReader readerSubject = new BufferedReader(new InputStreamReader(processSubject.getInputStream()));
                String lineSubject;
//                        while (true) {
//                            try {
//                                if (!((lineSubject = readerSubject.readLine()) != null)) break;
//                            } catch (IOException e) {
//                                throw new RuntimeException(e);
//                            }
//                        }
                while ((lineSubject = readerSubject.readLine()) != null) {
                    // 如果输出了 "DONE"，表示生成完毕
                    if ("DONE".equals(lineSubject)) {
                        break;  // 跳出循环
                    }
                }
                try {
                    int exitCodeSubject = processSubject.waitFor();
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                File subjectFile = new File("/myworkSpace/personal/");
                File[] subjectFiles = subjectFile.listFiles();
                assert subjectFiles != null;
                for (File file : subjectFiles) {
                    PutObjectRequest putObjectRequest = new PutObjectRequest("scorereport-1317275686", fileToUrl.get(file.getName()), file);
                    try {
                        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                        logger.info(putObjectResult.getRequestId());
                        file.delete();
                    } catch (CosServiceException e) {
                        logger.info("cos服务出现问题");
                        e.printStackTrace();
                    } catch (CosClientException e) {
                        logger.info("cos客户端出现问题" + file.getName() + "文件上传有误,重新上传");
                    }
                }
            }
        }
        return ResponseEntity.ok("操作成功");
    }
}
