package com.example.pdfgenerator;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.FileCompressConfig;
import com.qcloud.cos.model.ciModel.job.FileProcessJobResponse;
import com.qcloud.cos.model.ciModel.job.FileProcessJobType;
import com.qcloud.cos.model.ciModel.job.FileProcessRequest;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@SpringBootTest
public class CosClientDownloadZipFile {

    @Autowired
    private COSClient cosClient;

    @Test
    public void CosClientGen() throws IOException {

        String bucketName = "schoolreportpdf-1317275686";
        String folderName = "class/basic/改革/山东省/东平县高级中学";
        String localPath = "D:/classZipInit/东平县高级中学/";
        String finishPath = "D:/classZipFinish/东平县高级中学.zip";

        try {
            downloadFolder(cosClient, bucketName, folderName, localPath);
            zipDirectory(localPath,finishPath);

        } finally {
            cosClient.shutdown();
        }
    }

    private static void downloadFolder(COSClient cosClient, String bucketName, String folderName, String localPath) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest()
                .withBucketName(bucketName)
                .withPrefix(folderName);

        for (COSObjectSummary objectSummary : cosClient.listObjects(listObjectsRequest).getObjectSummaries()) {
            String key = objectSummary.getKey();
            String localFilePath = localPath + key.substring(folderName.length());
            downloadFile(cosClient, bucketName, key, localFilePath);
        }
    }

    private static void downloadFile(COSClient cosClient, String bucketName, String key, String localFilePath) {
        try {
            File localFile = new File(localFilePath);
            localFile.getParentFile().mkdirs(); // 创建目录

            InputStream inputStream = cosClient.getObject(new GetObjectRequest(bucketName, key)).getObjectContent();
            try (FileOutputStream fos = new FileOutputStream(localFile)) {
                byte[] buffer = new byte[1024];
                int length;
                while ((length = inputStream.read(buffer)) > 0) {
                    fos.write(buffer, 0, length);
                }
            }
            System.out.println("Downloaded: " + key);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zipDirectory(String sourceFolder, String zipFilePath) throws IOException {
        Path zipFile = Paths.get(zipFilePath);
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile.toFile()))) {
            Path srcPath = Paths.get(sourceFolder);
            Files.walk(srcPath)
                    .filter(path -> !Files.isDirectory(path))
                    .forEach(path -> {
                        ZipEntry zipEntry = new ZipEntry(srcPath.relativize(path).toString());
                        try {
                            zos.putNextEntry(zipEntry);
                            Files.copy(path, zos);
                            zos.closeEntry();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
        }
    }


    @Test
    public void delDirectory(){

        String directoryPath = "D:/classZipInit/东平县高级中学"; // 替换为你的文件夹路径
        try {
            deleteDirectory(Paths.get(directoryPath));
            System.out.println("文件夹已成功删除");
        } catch (IOException e) {
            System.err.println("删除文件夹时出错: " + e.getMessage());
        }

    }

    public static void deleteDirectory(Path path) throws IOException {
        // 使用Files.walkFileTree来遍历文件夹
        Files.walk(path)
                .sorted((p1, p2) -> p2.compareTo(p1)) // 反向排序以确保从子文件夹到父文件夹删除
                .forEach(p -> {
                    try {
                        Files.delete(p);
                    } catch (IOException e) {
                        System.err.println("无法删除文件: " + p + " " + e.getMessage());
                    }
                });
    }

    @Test
    public void delZipFile() {
        String zipFilePath = "D:/classZipFinish/东平县高级中学.zip"; // 替换为你的ZIP文件路径
        try {
            deleteZipFile(zipFilePath);
            System.out.println("ZIP文件已成功删除");
        } catch (IOException e) {
            System.err.println("删除ZIP文件时出错: " + e.getMessage());
        }
    }

    public static void deleteZipFile(String filePath) throws IOException {
        Path path = Paths.get(filePath);
        Files.delete(path);
    }


    @Test
    public void DownloadZipFile(){

        //1.创建任务请求对象
        FileProcessRequest request=new FileProcessRequest();
        //2.添加请求参数 参数详情请见 API 接口文档
        request.setBucketName("schoolreportpdf-1317275686");
        request.setTag(FileProcessJobType.FileCompress);
        FileCompressConfig fileCompressConfig=request.getOperation().getFileCompressConfig();
        fileCompressConfig.setFormat("zip");
        fileCompressConfig.setFlatten("0");
        fileCompressConfig.setPrefix("class/basic/改革/山东省/东平县高级中学/");
//        List<String> keyList=fileCompressConfig.getKey();
//        keyList.add("mark/pic-1.jpg");
//        keyList.add("mark/pic-1.pdf");
        MediaOutputObject output=request.getOperation().getOutput();
        output.setBucket("schoolreportpdf-1317275686");
        output.setRegion("ap-beijing");
        output.setObject("output/demo.zip");
        //3.调用接口,获取任务响应对象
        FileProcessJobResponse response= cosClient.createFileProcessJob(request);
        response.getJobDetail().getJobId();
        FileProcessRequest  queryRequest = new FileProcessRequest();
        queryRequest.setBucketName("schoolreportpdf-1317275686");
        queryRequest.setJobId(response.getJobDetail().getJobId());
        FileProcessJobResponse queryResponse = null;
        do{

            queryResponse = cosClient.describeFileProcessJob(queryRequest);

        }while(!queryResponse.getJobDetail().getState().equals("SUCCESS"));

        System.out.println(response.getJobDetail().getMessage());

    }

}
