package com.example.pdfgenerator.MKReport;

import com.example.pdfgenerator.MKReport.BeanProject.*;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import com.mysql.cj.xdevapi.SchemaImpl;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@SpringBootTest
public class MkReportTestClass {

    @Test
    public void TestInsertSchool(){

        JdbcTemplate mkReportJdbcTemplate = MyDataSourceConfig.getMkReportJdbcTemplate();

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(mkReportJdbcTemplate);

        String sql = "SELECT\n" +
                "\t'改革' AS region,\n" +
                "\t'博野中学' AS school,\n" +
                "CASE\n" +
                "\t\t\n" +
                "\t\tWHEN a.subject_id = 3002 THEN\n" +
                "\t\t'数学' \n" +
                "\tEND AS sub_subject,\n" +
                "\ta.ques_id,\n" +
                "\ta.ques_index,\n" +
                "\ta.zkz_num,\n" +
                "c.student_name as name,\n" +
                "\ta.score,\n" +
                "\ta.full_score,\n" +
                "\tb.qujian_index as nandu\n" +
                "FROM\n" +
                "\tdp_ques_score a\n" +
                "\tLEFT JOIN tx_nandu_20240314 b ON a.ques_id = b.ques_id \n" +
                "\tAND a.subject_id = b.subject_id \n" +
                "\tJOIN excel_student c on a.zkz_num = c.zkz_num\n" +
                "WHERE\n" +
                "\ta.subject_id = 3002";
        List<SchoolDifficultyPreview> schoolDifficultyPreviewList = namedParameterJdbcTemplate.query(sql,new BeanPropertyRowMapper<>(SchoolDifficultyPreview.class));

        Map<String, List<SchoolDifficultyPreview>> collect = schoolDifficultyPreviewList.stream().collect(Collectors.groupingBy(SchoolDifficultyPreview::getSubSubject));

        List<StudentDifficultyAvgScoreMean> avgScoreMeans = new ArrayList<>();

        for (String subject : collect.keySet()) {

            System.out.println("正在处理"+subject+"学科");

            List<SchoolDifficultyPreview> list = collect.get(subject);

            Map<String, List<SchoolDifficultyPreview>> collect1 = list.stream().collect(Collectors.groupingBy(SchoolDifficultyPreview::getNandu));

            for (String nandu : collect1.keySet()) {

                System.out.println("正在处理"+nandu+"难易数据");

                List<SchoolDifficultyPreview> list1 = collect1.get(nandu);

                Map<String, List<SchoolDifficultyPreview>> collect2 = list1.stream().collect(Collectors.groupingBy(SchoolDifficultyPreview::getName));

                for (String name : collect2.keySet()) {

                    List<SchoolDifficultyPreview> list2 = collect2.get(name);

                    double scoreSum = list2.stream().mapToDouble(SchoolDifficultyPreview::getScore).sum();

                    double fullScoreSum = list2.stream().mapToDouble(SchoolDifficultyPreview::getFullScore).sum();

                    double result = (Double.isNaN(scoreSum/fullScoreSum)||Double.isInfinite(scoreSum/fullScoreSum))?0.0:(scoreSum/fullScoreSum);

                    System.out.println("正在处理"+name+"学生的"+nandu+"难度系数的数据---->结果为:"+result);

                    StudentDifficultyAvgScoreMean studentDifficultyAvgScoreMean = new StudentDifficultyAvgScoreMean();

                    studentDifficultyAvgScoreMean.setDifficulty(nandu.equals("1")?"易":(nandu.equals("2")?"中":"难"));
                    studentDifficultyAvgScoreMean.setName(name);
                    studentDifficultyAvgScoreMean.setScoreMean(result);

                    avgScoreMeans.add(studentDifficultyAvgScoreMean);
                }

            }

            Map<String, List<StudentDifficultyAvgScoreMean>> collections = avgScoreMeans.stream().collect(Collectors.groupingBy(StudentDifficultyAvgScoreMean::getDifficulty));

            for (String difficulty  : collections.keySet()) {

                List<StudentDifficultyAvgScoreMean> listCollections = collections.get(difficulty);

                double schoolStudentDifficultyScoreMean = listCollections.stream().mapToDouble(StudentDifficultyAvgScoreMean::getScoreMean).average().getAsDouble();

                HashMap params= new HashMap(){{
                         put("school","博野中学");
                         put("subSubject",subject);
                         put("difficult",difficulty);
                         put("region","改革");
                         put("scoreMean", schoolStudentDifficultyScoreMean);
                }};

                namedParameterJdbcTemplate.update("insert into school_diffficult20240314(school,sub_subject,difficult,region,score_mean) value(:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(params));

            }



//            List<SchoolDifficultyPreview> schoolDifficultyPreviews = collect.get(subject);
//
//            List<SchoolDifficultyPreview> yi = new ArrayList<>();
//            List<SchoolDifficultyPreview> zhong = new ArrayList<>();
//            List<SchoolDifficultyPreview> nan = new ArrayList<>();
//
//            for (SchoolDifficultyPreview schoolDifficultyPreview : schoolDifficultyPreviews) {
//
//                if(schoolDifficultyPreview.getNandu()>=0&&schoolDifficultyPreview.getNandu()<0.3){
//                    yi.add(schoolDifficultyPreview);
//                } else if(schoolDifficultyPreview.getNandu()>=0.3&&schoolDifficultyPreview.getNandu()<0.7){
//                    zhong.add(schoolDifficultyPreview);
//                }else if(schoolDifficultyPreview.getNandu()>=0.7&&schoolDifficultyPreview.getNandu()<=1){
//                    nan.add(schoolDifficultyPreview);
//                }
//
//            }
//
//            //处理难易程度的得分率
//            double yiStuSum = yi.stream().mapToDouble(SchoolDifficultyPreview::getScore).sum();
//            double yiSum = yi.stream().mapToDouble(SchoolDifficultyPreview::getFullScore).sum();
//
//            double zhongStuSum = zhong.stream().mapToDouble(SchoolDifficultyPreview::getScore).sum();
//            double zhongSum = zhong.stream().mapToDouble(SchoolDifficultyPreview::getFullScore).sum();
//
//            double nanStuSum = nan.stream().mapToDouble(SchoolDifficultyPreview::getScore).sum();
//            double nanSum = nan.stream().mapToDouble(SchoolDifficultyPreview::getFullScore).sum();
//
//            System.out.println(yiStuSum/yiSum);
//            double yiResult = (Double.isNaN(yiStuSum/yiSum)||Double.isInfinite(yiStuSum/yiSum))?0.0:(yiStuSum/yiSum);
//            System.out.println(zhongStuSum/zhongSum);
//            double zhongResult = (Double.isNaN(zhongStuSum/zhongSum)||Double.isInfinite(zhongStuSum/zhongSum))?0.0:(zhongStuSum/zhongSum);
//            System.out.println(nanStuSum/nanSum);
//            double nanResult = (Double.isNaN(nanStuSum/nanSum)||Double.isInfinite(nanStuSum/nanSum))?0.0:(nanStuSum/nanSum);
//
//            HashMap paramsYi = new HashMap(){{
//                put("school",schoolDifficultyPreviews.get(0).getSchool());
//                put("subSubject",subject);
//                put("difficult","易");
//                put("region",schoolDifficultyPreviews.get(0).getRegion());
//                put("scoreMean", yiResult);
//            }};
//
//            HashMap paramsZhong = new HashMap(){{
//                put("school",schoolDifficultyPreviews.get(0).getSchool());
//                put("subSubject",subject);
//                put("difficult","中");
//                put("region",schoolDifficultyPreviews.get(0).getRegion());
//                put("scoreMean", zhongResult);
//            }};
//
//            HashMap paramsNan= new HashMap(){{
//                put("school",schoolDifficultyPreviews.get(0).getSchool());
//                put("subSubject",subject);
//                put("difficult","难");
//                put("region",schoolDifficultyPreviews.get(0).getRegion());
//                put("scoreMean", nanResult);
//            }};
//
//            namedParameterJdbcTemplate.update("insert into school_diffficult20240314(school,sub_subject,difficult,region,score_mean) value(:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsYi));
//            namedParameterJdbcTemplate.update("insert into school_diffficult20240314(school,sub_subject,difficult,region,score_mean) value(:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsZhong));
//            namedParameterJdbcTemplate.update("insert into school_diffficult20240314(school,sub_subject,difficult,region,score_mean) value(:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsNan));

        }

    }



    @Test
    public void TestInsertSchoolScoreMeanQuesType(){

        JdbcTemplate jdbcTemplate = MyDataSourceConfig.getMkReportJdbcTemplate();

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        String sql = " select\n" +
                " ques_type_name,\n" +
                " ques_index,\n" +
                " subject_name as sub_subject\n" +
                " from \n" +
                " th_ques_type_analysis\n" +
                " where\n" +
                " subject_name = '数学' ";

        List<thQuesTypeAnalysis> list = jdbcTemplate.query(sql,new BeanPropertyRowMapper<>(thQuesTypeAnalysis.class));

        List<StudentQuesTypeScoreMean> collection  =  new ArrayList<>();

        for (thQuesTypeAnalysis thQuesTypeAnalysis : list) {

            System.out.println("正在处理题型是"+thQuesTypeAnalysis.getQuesTypeName()+"的平均得分率");

            String queryForObject = " select \n" +
                    " zkz_num,\n" +
                    " ques_index,\n" +
                    " score,\n" +
                    " full_score\n" +
                    " from \n" +
                    " dp_ques_score\n" +
                    " where\n" +
                    " ques_index in (replacement)\n" +
                    " ";

             queryForObject  = queryForObject.replace("replacement",thQuesTypeAnalysis.getQuesIndex());

            List<QuesTypeDto> quesTypeCollects = jdbcTemplate.query(queryForObject,new BeanPropertyRowMapper<>(QuesTypeDto.class));

            Map<String, List<QuesTypeDto>> collect = quesTypeCollects.stream().collect(Collectors.groupingBy(QuesTypeDto::getZkzNum));

            //处理每个学生的对应该种题型的平均得分率
            for (String zkzNum : collect.keySet()) {

                System.out.println("处理"+zkzNum+"同学的数据");
                List<QuesTypeDto>  collectList = collect.get(zkzNum);
                Double scoreSum = collectList.stream().mapToDouble(QuesTypeDto::getScore).sum();
                Double fullScoreSum = collectList.stream().mapToDouble(QuesTypeDto::getFullScore).sum();
                double scoreMeanQuesType = (Double.isNaN(scoreSum/fullScoreSum)||Double.isInfinite(scoreSum/fullScoreSum))?0.0:(scoreSum/fullScoreSum);
                StudentQuesTypeScoreMean studentQuesTypeScoreMean = new StudentQuesTypeScoreMean();
                studentQuesTypeScoreMean.setQuesScoreMean(scoreMeanQuesType);
                studentQuesTypeScoreMean.setZkzNum(zkzNum);
                studentQuesTypeScoreMean.setQuesType(thQuesTypeAnalysis.getQuesTypeName());
                collection.add(studentQuesTypeScoreMean);

            }
        }

        Map<String, List<StudentQuesTypeScoreMean>> collect = collection.stream().collect(Collectors.groupingBy(StudentQuesTypeScoreMean::getQuesType));
        for (String quesType : collect.keySet()) {

            List<StudentQuesTypeScoreMean> quesTypeScoreMeanList = collect.get(quesType);

            Double result = quesTypeScoreMeanList.stream().mapToDouble(StudentQuesTypeScoreMean::getQuesScoreMean).average().getAsDouble();

            HashMap params = new HashMap(){{
                put("subSubject","数学");
                put("quesType",quesType);
                put("school","博野中学");
                put("province","山东省");
                put("scoreMean",result);
                put("region","改革");
            }};

            namedParameterJdbcTemplate.update("insert into school_quesType_score_mean20240314(sub_subject,ques_type,school,province,score_mean,region) value(:subSubject,:quesType,:school,:province,:scoreMean,:region)",new MapSqlParameterSource(params));

        }

    }

    @Test
    public void GeDimensionScoreMean(){

        JdbcTemplate jdbcTemplate = MyDataSourceConfig.getMkReportJdbcTemplate();

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

       String sql = " select \n" +
               " sort_num,\n" +
               " dimension_name,\n" +
               " question_index,\n" +
               " kcpl\n" +
               " from \n" +
               " th_dimension_question\n";

       List<DimensionDto> dimensionList = namedParameterJdbcTemplate.query(sql,new BeanPropertyRowMapper<>(DimensionDto.class));


       List<StudentDimensionScoreMean> collection = new ArrayList<>();

        for (DimensionDto dimensionDto : dimensionList) {

            String queryForDimensionQues = "select\n" +
                    "zkz_num,\n" +
                    "ques_index, \n" +
                    "score,\n" +
                    "full_score\n" +
                    "from\n" +
                    "dp_ques_score\n" +
                    "where\n" +
                    "ques_index in ( replacement )";

            queryForDimensionQues =  queryForDimensionQues.replace("replacement",dimensionDto.getQuestionIndex());

            List<StudentDimension> dimensionDtoS = namedParameterJdbcTemplate.query(queryForDimensionQues,new BeanPropertyRowMapper<>(StudentDimension.class));

            Map<String, List<StudentDimension>> collect = dimensionDtoS.stream().collect(Collectors.groupingBy(StudentDimension::getZkzNum));

            for (String zkzNum : collect.keySet()) {

                List<StudentDimension> studentDimensionList  = collect.get(zkzNum);

                Double scoreSum = studentDimensionList.stream().mapToDouble(StudentDimension::getScore).sum();

                Double fullScoreSum = studentDimensionList.stream().mapToDouble(StudentDimension::getFullScore).sum();

                double scoreMeanDimension = (Double.isNaN(scoreSum/fullScoreSum)||Double.isInfinite(scoreSum/fullScoreSum))?0.0:(scoreSum/fullScoreSum);



                StudentDimensionScoreMean studentDimensionScoreMean = new StudentDimensionScoreMean();

                studentDimensionScoreMean.setDimensionName(dimensionDto.getDimensionName());

                studentDimensionScoreMean.setScoreMean(scoreMeanDimension);

                studentDimensionScoreMean.setSortNum(dimensionDto.getSortNum());

                studentDimensionScoreMean.setZkzNum(zkzNum);

                studentDimensionScoreMean.setFullScore(fullScoreSum);

                studentDimensionScoreMean.setKcpl(dimensionDto.getKcpl());

                collection.add(studentDimensionScoreMean);

            }

        }

        Map<String, List<StudentDimensionScoreMean>> collect = collection.stream().collect(Collectors.groupingBy(StudentDimensionScoreMean::getSortNum));

        for (String sortNum : collect.keySet()) {

            List<StudentDimensionScoreMean> studentDimensions  = collect.get(sortNum);

            Double result = studentDimensions.stream().mapToDouble(StudentDimensionScoreMean::getScoreMean).average().getAsDouble();

            HashMap params  = new HashMap(){{
                put("scoreMean",result);
                put("kcpl",studentDimensions.get(0).getKcpl());
                put("sortNum",sortNum);
                put("dimensionName",studentDimensions.get(0).getDimensionName());
                put("fullScore",studentDimensions.get(0).getFullScore());
                put("school","博野中学");
            }};

            namedParameterJdbcTemplate.update("insert into school_dimesion_score_mean20240314(score_mean,sort_num,dimension_name,school,full_score,kcpl) value(:scoreMean,:sortNum,:dimensionName,:school,:fullScore,:kcpl)",new MapSqlParameterSource(params));

        }

    }


    @Test
    public void percentHistogram(){

        JdbcTemplate jdbcTemplate  = MyDataSourceConfig.getMkReportJdbcTemplate();

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        String sql = "SELECT\n" +
                "  a.zkz_num,\n" +
                "\tb.student_name,\n" +
                "  b.type,\n" +
                "\ta.score,\n" +
                "\tc.percent_g as province_percent,\n" +
                "\td.percent_g as country_percent\n" +
                "FROM\n" +
                "\t ( select\n" +
                "     zkz_num,\n" +
                "     sum(score) as score \n" +
                "     from \n" +
                "     dp_ques_score\n" +
                "     group by zkz_num ) a \n" +
                "left join\n" +
                "   `excel_student` b on a.zkz_num = b.zkz_num\n" +
                "left join \n" +
                "    total_subject_score_perent_mapping c on a.score =  c.score \n" +
                "left join\n" +
                "    total_subject_score_perent_mapping_guo d on a.score = d.score\n" +
                "  ";

        List<StudentHistogram> histogramList = namedParameterJdbcTemplate.query(sql,new BeanPropertyRowMapper<>(StudentHistogram.class));

        for (StudentHistogram studentHistogram : histogramList) {

            HashMap params = new HashMap(){{
                put("school","博野中学");
                put("zkzNum",studentHistogram.getZkzNum());
                put("studentName",studentHistogram.getStudentName());
                put("type",studentHistogram.getType());
                put("score",studentHistogram.getScore());
                put("provincePercent",studentHistogram.getProvincePercent());
                put("countryPercent",studentHistogram.getCountryPercent());
            }};

            namedParameterJdbcTemplate.update("insert into school_histrogram20240314(school,zkz_num,student_name,type,score,province_percent,country_percent) value(:school,:zkzNum,:studentName,:type,:score,:provincePercent,:countryPercent)",new MapSqlParameterSource(params));

        }

    }


    @Test
    public void insertProvinceQuesType(){

        JdbcTemplate jdbcTemplate = MyDataSourceConfig.getMkReportJdbcTemplate();

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        String sql  =  "select\n" +
                "tx_name as ques_type,\n" +
                "zkz_num as zkz_num,\n" +
                "defenlu as score_mean\n" +
                "from\n" +
                "tx_defenlu_20240314\n" +
                "where\n" +
                "province_id in (13,37) \n" +
                "and subject_id = 3002 ";

        List<TempStudentScoreMean> list = namedParameterJdbcTemplate.query(sql,new BeanPropertyRowMapper<>(TempStudentScoreMean.class));

        Map<String, List<TempStudentScoreMean>> collect = list.stream().collect(Collectors.groupingBy(TempStudentScoreMean::getQuesType));   
        //省份 题型
        for (String quesType : collect.keySet()) {

            System.out.println("正在处理"+quesType+"题型的关于"+"山东省和博野中学的数据");

            List<TempStudentScoreMean> tempStudentScoreMeanList =  collect.get(quesType);

            //计算数据的平均得分率

            double provinceAverage = tempStudentScoreMeanList.stream().mapToDouble(TempStudentScoreMean::getScoreMean).average().getAsDouble();

            HashMap params = new HashMap(){{
                put("province","山东省");
                put("scoreMean",provinceAverage);
                put("quesType",quesType);
                put("region","改革");
                put("subSubject","数学");
            }};

            namedParameterJdbcTemplate.update("insert into province_ques_type_score_mean20240314(province,score_mean,ques_type,region,sub_subject) value(:province,:scoreMean,:quesType,:region,:subSubject)",new MapSqlParameterSource(params));

        }

    }

    @Test
    public void  insertQuesTypeProvinceExcellent(){

        JdbcTemplate jdbcTemplate = MyDataSourceConfig.getMkReportJdbcTemplate();

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        String sql  =  "select\n" +
                "a.zkz_num as zkz_num,\n" +
                "a.score,\n" +
                "a.percent_g ,\n" +
                "b.tx_name as ques_type,\n" +
                "b.defenlu as score_mean\n" +
                "from\n" +
                "(select \n" +
                "a.zkz_num,\n" +
                "a.score,\n" +
                "a.subject_id,\n" +
                "a.province_id,\n" +
                "b.percent_g\n" +
                "from\n" +
                "dp_subject_score a \n" +
                "left join total_subject_score_perent_mapping b on a.score = b.score \n" +
                "where \n" +
                "a.subject_id = 3002 \n" +
                "and \n" +
                "a.province_id in(37,13)\n" +
                "and b.percent_g > 73) a\n" +
                "join \n" +
                "tx_defenlu_20240314 b on a.zkz_num = b.zkz_num and a.subject_id = b.subject_id  \n" +
                "order by a.province_id";

        List<TempStudentScoreMean> list = namedParameterJdbcTemplate.query(sql,new BeanPropertyRowMapper<>(TempStudentScoreMean.class));

        Map<String, List<TempStudentScoreMean>> collect = list.stream().collect(Collectors.groupingBy(TempStudentScoreMean::getQuesType));
        //省份 题型
        for (String quesType : collect.keySet()) {

            System.out.println("正在处理"+quesType+"题型的关于"+"山东省和博野中学的数据");

            List<TempStudentScoreMean> tempStudentScoreMeanList =  collect.get(quesType);

            //计算数据的平均得分率

            double provinceAverage = tempStudentScoreMeanList.stream().mapToDouble(TempStudentScoreMean::getScoreMean).average().getAsDouble();

            HashMap params = new HashMap(){{
                put("province","山东省");
                put("scoreMean",provinceAverage);
                put("quesType",quesType);
                put("region","改革");
                put("subSubject","数学");
            }};

            namedParameterJdbcTemplate.update("insert into province_excellent_ques_type_score_mean20240314(province,score_mean,ques_type,region,sub_subject) value(:province,:scoreMean,:quesType,:region,:subSubject)",new MapSqlParameterSource(params));

        }

    }

    @Test
    public void insertProvinceExcellentDifficulty(){

        JdbcTemplate jdbcTemplate = MyDataSourceConfig.getMkReportJdbcTemplate();

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        String sql = "SELECT\n" +
                "\ta.zkz_num AS zkz_num,\n" +
                "\ta.score,\n" +
                "\ta.percent_g,\n" +
                "\tcase\n" +
                "\twhen\n" +
                "\tb.qujian_index = 1 then '易' \n" +
                "\twhen b.qujian_index = 2 then '中' \n" +
                "  when b.qujian_index = 3 then '难'\n" +
                "\tend as difficulty,\n" +
                "\tb.defenlu AS score_mean \n" +
                "FROM\n" +
                "\t(\n" +
                "\tSELECT\n" +
                "\t\ta.zkz_num,\n" +
                "\t\ta.score,\n" +
                "\t\ta.subject_id,\n" +
                "\t\ta.province_id,\n" +
                "\t\tb.percent_g \n" +
                "\tFROM\n" +
                "\t\tdp_subject_score a\n" +
                "\t\tLEFT JOIN total_subject_score_perent_mapping b ON a.score = b.score \n" +
                "\tWHERE\n" +
                "\t\ta.subject_id = 3002 \n" +
                "\t\tAND a.province_id IN ( 37, 13 ) \n" +
                "\t\tAND b.percent_g > 73 \n" +
                "\t) a\n" +
                "\tJOIN tx_nandu_defenlu_20240314 b ON a.zkz_num = b.zkz_num \n" +
                "\tAND a.subject_id = b.subject_id \n" +
                "ORDER BY\n" +
                "\ta.province_id";

        List<ProvinceExcellentDifficulty> list = namedParameterJdbcTemplate.query(sql,new BeanPropertyRowMapper<>(ProvinceExcellentDifficulty.class));

        Map<String, List<ProvinceExcellentDifficulty>> collect = list.stream().collect(Collectors.groupingBy(ProvinceExcellentDifficulty::getDifficulty));

        for (String difficulty : collect.keySet()) {

            System.out.println("处理"+difficulty+"难度题型系数");

            List<ProvinceExcellentDifficulty> collections =  collect.get(difficulty);

            double result = collections.stream().mapToDouble(ProvinceExcellentDifficulty::getScoreMean).average().getAsDouble();

            HashMap params = new HashMap(){{
                put("province","山东省");
                put("scoreMean",result);
                put("difficulty",difficulty);
                put("region","改革");
                put("subSubject","数学");
            }};

            namedParameterJdbcTemplate.update("insert into province_excellent_difficulty_score_mean20240314(province,score_mean,difficulty,region,sub_subject) value(:province,:scoreMean,:difficulty,:region,:subSubject)",new MapSqlParameterSource(params));

        }


    }


    @Test
    public void insertProvinceDifficulty(){

        JdbcTemplate jdbcTemplate =  MyDataSourceConfig.getMkReportJdbcTemplate();

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        String sql = "select\n" +
                "'山东省' as province,\n" +
                "'改革' as region,\n" +
                "AVG(defenlu) as score_mean,\n" +
                "Case\n" +
                "when \n" +
                "qujian_index = 1 then '易'\n" +
                "when \n" +
                "qujian_index = 2 then '中'\n" +
                "when\n" +
                "qujian_index = 3 then '难'\n" +
                "end as difficulty\n" +
                "from \n" +
                "tx_nandu_defenlu_20240314 \n" +
                "where \n" +
                "province_id in (13,37)\n" +
                "group by qujian_index ";

        List<ProvinceDifficultyAvgScoreMean> list =  namedParameterJdbcTemplate.query(sql,new BeanPropertyRowMapper<>(ProvinceDifficultyAvgScoreMean.class));

        for (ProvinceDifficultyAvgScoreMean provinceDifficultyAvgScoreMean : list) {
            HashMap params = new HashMap(){{
                put("province",provinceDifficultyAvgScoreMean.getProvince());
                put("scoreMean",provinceDifficultyAvgScoreMean.getScoreMean());
                put("difficulty",provinceDifficultyAvgScoreMean.getDifficulty());
                put("region",provinceDifficultyAvgScoreMean.getRegion());
                put("subSubject","数学");
            }};

            namedParameterJdbcTemplate.update("insert into province_difficulty_score_mean20240314(province,score_mean,difficulty,region,sub_subject) value(:province,:scoreMean,:difficulty,:region,:subSubject)",new MapSqlParameterSource(params));

        }

    }

}
