package com.example.pdfgenerator.controller;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import java.io.*;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@Controller
public class CosDownloadZipFileController {

    @Autowired
    private COSClient cosClient;



    @GetMapping("/getClassReportPdfZipFile")
    public ResponseEntity<FileSystemResource> CosClientGen(@RequestParam("region")String region,@RequestParam("province")String province,@RequestParam("school")String school) throws IOException {


        String   bucketName = "schoolreportpdf-1317275686";
        String   folderName = "class/"+region+"/"+province+"/"+school;
        String   localPath = "";
        String   finishPath = "";

        String osName = System.getProperty("os.name").toLowerCase();

        // 根据操作系统设置目录
        if (osName.contains("win")) {
           // Windows系统
            localPath = "D:/classZipInit/"+school;
            finishPath = "D:/classZipFinish/"+school+".zip";
        } else if (osName.contains("nix") || osName.contains("nux")) {
            // Linux 系统
            localPath = "/customDir/classZipInit/"+school;
            finishPath = "/customDir/classZipFinish/"+school+".zip";
        }

        try {
            downloadFolder(cosClient, bucketName, folderName, localPath);
            zipDirectory(localPath,finishPath);
        } catch (Exception e){
            e.printStackTrace();
        }finally {
            deleteDirectory(Paths.get(localPath));
            return downloadZip(finishPath);
        }
    }

    private static void downloadFolder(COSClient cosClient, String bucketName, String folderName, String localPath) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest()
                .withBucketName(bucketName)
                .withPrefix(folderName);

        for (COSObjectSummary objectSummary : cosClient.listObjects(listObjectsRequest).getObjectSummaries()) {
            String key = objectSummary.getKey();
            String localFilePath = localPath +"/"+key.substring(folderName.length());
            downloadFile(cosClient, bucketName, key, localFilePath);
        }
    }

    private static void downloadFile(COSClient cosClient, String bucketName, String key, String localFilePath) {
        try {
            File localFile = new File(localFilePath);
            localFile.getParentFile().mkdirs(); // 创建目录

            InputStream inputStream = cosClient.getObject(new GetObjectRequest(bucketName, key)).getObjectContent();
            try (FileOutputStream fos = new FileOutputStream(localFile)) {
                byte[] buffer = new byte[1024];
                int length;
                while ((length = inputStream.read(buffer)) > 0) {
                    fos.write(buffer, 0, length);
                }
            }
            System.out.println("Downloaded: " + key);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zipDirectory(String sourceFolder, String zipFilePath) throws IOException {
        Path zipFile = Paths.get(zipFilePath);
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile.toFile()))) {
            Path srcPath = Paths.get(sourceFolder);
            Files.walk(srcPath)
                    .filter(path -> !Files.isDirectory(path))
                    .forEach(path -> {
                        ZipEntry zipEntry = new ZipEntry(srcPath.relativize(path).toString());
                        try {
                            zos.putNextEntry(zipEntry);
                            Files.copy(path,zos);
                            zos.closeEntry();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
        }
    }

    public static void deleteZipFile(String filePath) throws IOException {
        Path path = Paths.get(filePath);
        Files.delete(path);
    }

    public static void deleteDirectory(Path path) throws IOException {
        // 使用Files.walkFileTree来遍历文件夹
        Files.walk(path)
                .sorted((p1, p2) -> p2.compareTo(p1)) // 反向排序以确保从子文件夹到父文件夹删除
                .forEach(p -> {
                    try {
                        Files.delete(p);
                    } catch (IOException e) {
                        System.err.println("无法删除文件: " + p + " " + e.getMessage());
                    }
                });
    }

    public ResponseEntity<FileSystemResource> downloadZip(String zipPath) throws UnsupportedEncodingException {

        File zipFile = new File(zipPath); // 你的ZIP文件路径

        if (!zipFile.exists()) {
            return ResponseEntity.status(HttpStatus.NOT_FOUND).build();
        }

        FileSystemResource resource = new FileSystemResource(zipFile);
        HttpHeaders headers = new HttpHeaders();
        System.out.println(zipFile.getName());
        headers.add("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(zipFile.getName(), "UTF-8")+"\"");

        new Thread(() -> {
            try {
                // 等待响应发送后再删除文件
                Thread.sleep(2000); // 可根据需要调整延迟
                if (zipFile.exists()) {
                    zipFile.delete();
                }
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();

        return ResponseEntity.ok()
                .headers(headers)
                .contentLength(zipFile.length())
                .contentType(org.springframework.http.MediaType.APPLICATION_OCTET_STREAM)
                .body(resource);

    }

}
