package com.example.pdfgenerator.controller;

import com.example.pdfgenerator.Dto.BasicReportParameters;
import com.example.pdfgenerator.Dto.ClassBasicReportParameters;
import com.example.pdfgenerator.Dto.RetryCommand;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import com.qcloud.cos.COSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.*;
import java.util.stream.Collectors;


@RestController
@RequestMapping("/ycy")
public class GeneratorAllTypePdfByProvinceYcyController {

    private static final Logger logger = LoggerFactory.getLogger(GeneratorAllTypePdfByProvinceYcyController.class);

    @Autowired
    private COSClient cosClient;

    private static final String bucketName = "schoolreportpdf-1317275686";


    private static Map<String,String> fileToUrl = new HashMap<>();

    JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();


    @RequestMapping("/GeneratorByProvinceName")
    public ResponseEntity generatorName(@RequestParam("examId")String examId, @RequestParam(value = "provinceName",required = false)String provinceName,@RequestParam(value = "schoolName",required = false)String schoolName) throws IOException, InterruptedException {

        String suffix  = examId.trim().replace("TDA","").replace("G3","").replace("G2","").replace("G11","").replace("G12","").trim();

        String  synthesisSchoolSubjectReportSql = "select \n" +
                "school,exam_id,province,region1 as  region,sub_subject\n" +
                "from \n" +
                "base_school_subject_tda"+suffix+" \n" +
                " where subject_type = '常规' \n";

        String  synthesisSchoolReportSql = "select \n" +
                "school,exam_id,province,region1 as region\n" +
                "from \n" +
                "base_school_subject_tda"+suffix+"  where subject_type = '常规' \n";

        String synthesisClassSubjectReportSql = "SELECT\n" +
                "\tclass as class_name,\n" +
                "\tsub_subject,\n" +
                "\tschool,\n" +
                "\tprovince,\n" +
                "\tregion1 as region,\n" +
                "\texam_id\n" +
                "FROM\n" +
                "\tbase_student_subject_tda"+suffix+"\n" +
                "where\n" +
                "subject_type = '常规' \n "  ;

        String synthesisClassReportSql = "SELECT\n" +
                "\tclass AS class_name,\n" +
                "\tschool,\n" +
                "\texam_id,\n" +
                "\tprovince,\n" +
                "\tregion1 as region \n" +
                "FROM\n" +
                "\tbase_class_subject_tda"+suffix+"\n" +
                "WHERE\n" +
                "\tsubject_type = '常规'\n" ;

        if(provinceName!=null){

            List<String> provinceList = Arrays.asList(provinceName.split("#"));

            String appendStatement  = " and province in (" ;

            for (String s : provinceList) {
                appendStatement = appendStatement +"'"+s+"',";
            }

            appendStatement = appendStatement.substring(0,appendStatement.length()-1)+") ";

            synthesisSchoolSubjectReportSql = synthesisSchoolSubjectReportSql + " " + appendStatement;
            synthesisSchoolReportSql = synthesisSchoolReportSql + " " + appendStatement ;
            synthesisClassSubjectReportSql = synthesisClassSubjectReportSql + " " + appendStatement;
            synthesisClassReportSql = synthesisClassReportSql + " " + appendStatement;


        }

        if(schoolName!=null){
            List<String> schoolList = Arrays.asList(schoolName.split("#"));

            String appendStatement  = " and school in (" ;

            for (String s : schoolList) {
                appendStatement = appendStatement +"'"+s+"',";
            }

            appendStatement = appendStatement.substring(0,appendStatement.length()-1)+") ";

            synthesisSchoolSubjectReportSql = synthesisSchoolSubjectReportSql + " " + appendStatement;
            synthesisSchoolReportSql = synthesisSchoolReportSql + " " + appendStatement ;
            synthesisClassSubjectReportSql = synthesisClassSubjectReportSql + " " + appendStatement;
            synthesisClassReportSql = synthesisClassReportSql + " " + appendStatement;

        }

        synthesisSchoolSubjectReportSql = synthesisSchoolSubjectReportSql + " group by school,exam_id,province,region1,sub_subject";

        synthesisSchoolReportSql = synthesisSchoolReportSql + " " + " group by school,exam_id,province,region1";

        synthesisClassSubjectReportSql = synthesisClassSubjectReportSql + " " +  "\tGROUP BY\n" +"\tclass,\n" + "\tsub_subject,\n" + "\tschool,\n" + "\tprovince,\n" + "\tregion1,\n" + "\texam_id";

        synthesisClassReportSql = synthesisClassReportSql + " " + " GROUP BY\n" + "\tclass,\n" + "\tschool,\n" + "\texam_id,\n" + "\tprovince,\n" + "\tregion1\n";

//        System.out.println(1);
//        System.out.println(synthesisSchoolSubjectReportSql);
//
//        System.out.println(2);
//        System.out.println(synthesisSchoolReportSql);
//
//        System.out.println(3);
//        System.out.println(synthesisClassSubjectReportSql);
//
//        System.out.println(4);
//        System.out.println(synthesisClassReportSql);

        List<BasicReportParameters> synthesisSchoolSubjectReportParameters = this.reportJdbcTemplate.query(synthesisSchoolSubjectReportSql, new Object[]{}, new BeanPropertyRowMapper<>(BasicReportParameters.class));

        for (BasicReportParameters parameter : synthesisSchoolSubjectReportParameters) {

            if(parameter.getRegion().equals("改革")||parameter.getRegion().equals("改革A")||parameter.getRegion().equals("改革3+3")||parameter.getRegion().equals("改革3+1+2")){
                String command = "node F:/myworkSpace/puppeteer2.js \"http://schoolreport.cssat.cn/pdf/subject?province=condition5&school=condition1&examId=condition4&region=conditionC&subSubject=condition6&subjectType=常规\" pdf";
                String fileName = "/myworkSpace/subject/" + parameter.getRegion() + parameter.getProvince() + parameter.getSchool() + parameter.getSubSubject() + parameter.getExamId() + ".pdf";
                command = command.replace("condition1", parameter.getSchool()).replace("condition5", parameter.getProvince()).replace("conditionC", parameter.getRegion()).replace("condition4", parameter.getExamId()).replace("condition6", parameter.getSubSubject())
                        .concat(" ").concat(fileName);
                parameter.setCommand(command);
                parameter.setPrefix("/myworkSpace/subject/");
                fileToUrl.put(fileName.replace("/myworkSpace/subject/",""),"PdfSubject/"+fileName.replace("/myworkSpace/subject/",""));

            }else{
                String command = "node F:/myworkSpace/puppeteer2.js \"http://schoolreport.cssat.cn/pdf/subject?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subSubject=condition6&subjectType=常规\" pdf";
                String fileName = "/myworkSpace/subject/" + parameter.getRegion() + parameter.getProvince() + parameter.getSchool() + parameter.getSubSubject() + parameter.getExamId() + ".pdf";
                command = command.replace("condition1", parameter.getSchool()).replace("condition5", parameter.getProvince()).replace("condition3", parameter.getRegion()).replace("condition4", parameter.getExamId()).replace("condition6", parameter.getSubSubject())
                        .concat(" ").concat(fileName);
                parameter.setCommand(command);
                parameter.setPrefix("/myworkSpace/subject/");
                fileToUrl.put(fileName.replace("/myworkSpace/subject/",""),"PdfSubject/"+fileName.replace("/myworkSpace/subject/",""));
            }
        }

        List<BasicReportParameters> synthesisSchoolReportParameters = this.reportJdbcTemplate.query(synthesisSchoolReportSql, new Object[]{}, new BeanPropertyRowMapper<>(BasicReportParameters.class));

        for (BasicReportParameters synthesisSchoolReportParameter : synthesisSchoolReportParameters) {
            if(synthesisSchoolReportParameter.getRegion().equals("改革")||synthesisSchoolReportParameter.getRegion().equals("改革A")||synthesisSchoolReportParameter.getRegion().equals("改革3+3")||synthesisSchoolReportParameter.getRegion().equals("改革3+1+2")){
                String command = "node F:/myworkSpace/puppeteer.js \"http://schoolreport.cssat.cn/pdf/basic?province=condition5&school=condition1&examId=condition4&region=conditionC&subjectType=常规\" pdf ";
                String fileName = "/myworkSpace/basic/"+synthesisSchoolReportParameter.getRegion()+synthesisSchoolReportParameter.getProvince()+synthesisSchoolReportParameter.getSchool()+synthesisSchoolReportParameter.getExamId()+".pdf";
                command = command.replace("condition1", synthesisSchoolReportParameter.getSchool()).replace("condition5", synthesisSchoolReportParameter.getProvince()).replace("conditionC",synthesisSchoolReportParameter.getRegion()).replace("condition4", synthesisSchoolReportParameter.getExamId())
                        .concat(" ").concat(fileName);
                synthesisSchoolReportParameter.setCommand(command);
                synthesisSchoolReportParameter.setPrefix("/myworkSpace/basic/");
                fileToUrl.put(fileName.replace("/myworkSpace/basic/",""),"PdfDir/"+fileName.replace("/myworkSpace/basic/",""));
            }else{
                String command = "node F:/myworkSpace/puppeteer.js \"http://schoolreport.cssat.cn/pdf/basic?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subjectType=常规\" pdf ";
                String fileName = "/myworkSpace/basic/"+synthesisSchoolReportParameter.getRegion()+synthesisSchoolReportParameter.getProvince()+synthesisSchoolReportParameter.getSchool()+synthesisSchoolReportParameter.getExamId()+".pdf";
                command = command.replace("condition1", synthesisSchoolReportParameter.getSchool()).replace("condition5", synthesisSchoolReportParameter.getProvince()).replace("condition3",synthesisSchoolReportParameter.getRegion()).replace("condition4", synthesisSchoolReportParameter.getExamId())
                        .concat(" ").concat(fileName);
                synthesisSchoolReportParameter.setCommand(command);
                synthesisSchoolReportParameter.setPrefix("/myworkSpace/basic/");
                fileToUrl.put(fileName.replace("/myworkSpace/basic/",""),"PdfDir/"+fileName.replace("/myworkSpace/basic/",""));

            }
        }

        List<ClassBasicReportParameters> synthesisClassSubjectReportParameters = this.reportJdbcTemplate.query(synthesisClassSubjectReportSql,new Object[]{},new BeanPropertyRowMapper<>(ClassBasicReportParameters.class));

        for (ClassBasicReportParameters synthesisClassSubjectReportParameter : synthesisClassSubjectReportParameters) {

            if (synthesisClassSubjectReportParameter.getRegion().equals("改革")||synthesisClassSubjectReportParameter.getRegion().equals("改革A")||synthesisClassSubjectReportParameter.getRegion().equals("改革3+3")||synthesisClassSubjectReportParameter.getRegion().equals("改革3+1+2")) {
                String command = "node F:/myworkSpace/pdfOfClassSubjectGen.js \"http://schoolreport.cssat.cn/pdf/classSubject?province=condition5&school=condition1&examId=condition4&region=conditionC&subSubject=condition6&subjectType=常规&className=conditionA\" pdf";
                String fileName = "/myworkSpace/Class/subject/" + synthesisClassSubjectReportParameter.getRegion() + synthesisClassSubjectReportParameter.getProvince() + synthesisClassSubjectReportParameter.getSchool() + synthesisClassSubjectReportParameter.getSubSubject() + synthesisClassSubjectReportParameter.getExamId() + synthesisClassSubjectReportParameter.getSubSubject() + synthesisClassSubjectReportParameter.getClassName().replace(" ","")+ ".pdf";
                command = command.replace("condition1", synthesisClassSubjectReportParameter.getSchool()).replace("condition5", synthesisClassSubjectReportParameter.getProvince()).replace("conditionC", synthesisClassSubjectReportParameter.getRegion()).replace("condition4", synthesisClassSubjectReportParameter.getExamId()).replace("condition6", synthesisClassSubjectReportParameter.getSubSubject()).replace("conditionA",synthesisClassSubjectReportParameter.getClassName())
                        .concat(" ").concat(fileName);
                fileToUrl.put(fileName.replace("/myworkSpace/Class/subject/",""),"/class/"+synthesisClassSubjectReportParameter.getExamId()+"/"+synthesisClassSubjectReportParameter.getProvince()+"/"+synthesisClassSubjectReportParameter.getSchool()+"/班级学科报告/"+synthesisClassSubjectReportParameter.getClassName()+"/"+synthesisClassSubjectReportParameter.getSubSubject()+"/"+fileName.replace("/myworkSpace/Class/subject/",""));
                synthesisClassSubjectReportParameter.setCommand(command);
                synthesisClassSubjectReportParameter.setPrefix("/myworkSpace/Class/subject/");
            } else {
                String command = "node F:/myworkSpace/pdfOfClassSubjectGen.js \"http://schoolreport.cssat.cn/pdf/classSubject?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subSubject=condition6&subjectType=常规&className=conditionA\" pdf";

                String fileName = "/myworkSpace/Class/subject/" + synthesisClassSubjectReportParameter.getRegion() + synthesisClassSubjectReportParameter.getProvince() + synthesisClassSubjectReportParameter.getSchool() + synthesisClassSubjectReportParameter.getSubSubject() + synthesisClassSubjectReportParameter.getExamId() + synthesisClassSubjectReportParameter.getSubSubject() + synthesisClassSubjectReportParameter.getClassName().replace(" ","")+".pdf";
                command = command.replace("condition1", synthesisClassSubjectReportParameter.getSchool()).replace("condition5", synthesisClassSubjectReportParameter.getProvince()).replace("condition3", synthesisClassSubjectReportParameter.getRegion()).replace("condition4", synthesisClassSubjectReportParameter.getExamId()).replace("condition6", synthesisClassSubjectReportParameter.getSubSubject()).replace("conditionA",synthesisClassSubjectReportParameter.getClassName())
                        .concat(" ").concat(fileName);
                fileToUrl.put(fileName.replace("/myworkSpace/Class/subject/",""),"/class/"+synthesisClassSubjectReportParameter.getExamId()+"/"+synthesisClassSubjectReportParameter.getProvince()+"/"+synthesisClassSubjectReportParameter.getSchool()+"/班级学科报告/"+synthesisClassSubjectReportParameter.getClassName()+"/"+synthesisClassSubjectReportParameter.getSubSubject()+"/"+fileName.replace("/myworkSpace/Class/subject/",""));
                synthesisClassSubjectReportParameter.setCommand(command);
                synthesisClassSubjectReportParameter.setPrefix("/myworkSpace/Class/subject/");
            }
        }

        List<ClassBasicReportParameters> synthesisClassReportParameters = this.reportJdbcTemplate.query(synthesisClassReportSql,new Object[]{},new BeanPropertyRowMapper<>(ClassBasicReportParameters.class));

        for (ClassBasicReportParameters synthesisClassReportParameter : synthesisClassReportParameters) {

            if(synthesisClassReportParameter.getRegion().equals("改革")||synthesisClassReportParameter.getRegion().equals("改革A")||synthesisClassReportParameter.getRegion().equals("改革3+3")||synthesisClassReportParameter.getRegion().equals("改革3+1+2")){

                String  command = "node F:/myworkSpace/pdfOfClassBasicGen.js \"http://schoolreport.cssat.cn/pdf/classBasic?province=condition5&school=condition1&examId=condition4&region=conditionC&subjectType=常规&className=conditionA\" pdf ";

                String fileName = "/myworkSpace/Class/Basic/"+synthesisClassReportParameter.getRegion()+synthesisClassReportParameter.getProvince()+synthesisClassReportParameter.getSchool()+ synthesisClassReportParameter.getClassName()+synthesisClassReportParameter.getExamId()+".pdf";

                command = command.replace("condition1", synthesisClassReportParameter.getSchool()).replace("condition5", synthesisClassReportParameter.getProvince()).replace("conditionC",synthesisClassReportParameter.getRegion()).replace("condition4", synthesisClassReportParameter.getExamId()).replace("conditionA",synthesisClassReportParameter.getClassName())
                        .concat(" ").concat(fileName);

                fileToUrl.put(fileName.replace("/myworkSpace/Class/Basic/",""),"/class/"+synthesisClassReportParameter.getExamId()+"/"+synthesisClassReportParameter.getProvince()+"/"+synthesisClassReportParameter.getSchool()+"/班级综合报告/"+synthesisClassReportParameter.getClassName()+"/"+fileName.replace("/myworkSpace/Class/Basic/",""));

                synthesisClassReportParameter.setCommand(command);

                synthesisClassReportParameter.setPrefix("/myworkSpace/Class/Basic/");

            } else {

                String command = "node F:/myworkSpace/pdfOfClassBasicGen.js \"http://schoolreport.cssat.cn/pdf/classBasic?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subjectType=常规&className=conditionA\" pdf ";

                String fileName = "/myworkSpace/Class/Basic/"+synthesisClassReportParameter.getRegion()+synthesisClassReportParameter.getProvince()+synthesisClassReportParameter.getSchool()+synthesisClassReportParameter.getClassName()+synthesisClassReportParameter.getExamId()+".pdf";

                command = command.replace("condition1", synthesisClassReportParameter.getSchool()).replace("condition5", synthesisClassReportParameter.getProvince()).replace("condition3",synthesisClassReportParameter.getRegion()).replace("condition4", synthesisClassReportParameter.getExamId()).replace("conditionA",synthesisClassReportParameter.getClassName())
                        .concat(" ").concat(fileName);

                fileToUrl.put(fileName.replace("/myworkSpace/Class/Basic/",""),"/class/"+synthesisClassReportParameter.getExamId()+"/"+synthesisClassReportParameter.getProvince()+"/"+synthesisClassReportParameter.getSchool()+"/班级综合报告/"+synthesisClassReportParameter.getClassName()+"/"+fileName.replace("/myworkSpace/Class/Basic/",""));

                synthesisClassReportParameter.setCommand(command);

                synthesisClassReportParameter.setPrefix("/myworkSpace/Class/Basic/");

            }
        }

//        for (String s : fileToUrl.keySet()) {
//            System.out.println("file="+s+"==mapto=="+"key="+fileToUrl.get(s));
//        }

        // 学校基础报告
        Map<String, List<BasicReportParameters>>  schoolReport = synthesisSchoolReportParameters.stream().collect(Collectors.groupingBy(BasicReportParameters::getProvince));

        Map<String, List<BasicReportParameters>>  schoolSubjectReport = synthesisSchoolSubjectReportParameters.stream().collect(Collectors.groupingBy(BasicReportParameters::getProvince));

        Map<String, List<ClassBasicReportParameters>>  classReport = synthesisClassReportParameters.stream().collect(Collectors.groupingBy(ClassBasicReportParameters::getProvince));

        Map<String, List<ClassBasicReportParameters>>  classSubjectReport = synthesisClassSubjectReportParameters.stream().collect(Collectors.groupingBy(ClassBasicReportParameters::getProvince));

//        分组开始执行记录
        for (String key : schoolReport.keySet()) {
            logger.info("province:"+key+ "Gen");
            List<BasicReportParameters>  schoolBasicReport = schoolReport.get(key);
            List<BasicReportParameters>  schoolSubject = schoolSubjectReport.get(key);
            List<ClassBasicReportParameters> classBasicReport = classReport.get(key);
            List<ClassBasicReportParameters> classSubject = classSubjectReport.get(key);
            for (BasicReportParameters schoolLevel : schoolBasicReport) {
                    List<RetryCommand>  retryCommands = new ArrayList<>();
                    logger.info("school:"+schoolLevel.getSchool()+"loading");
                    Map<String, List<BasicReportParameters>>  schoolMap= schoolSubject.stream().collect(Collectors.groupingBy(BasicReportParameters::getSchool));
                    Map<String, List<ClassBasicReportParameters>> classBasic = classBasicReport.stream().collect(Collectors.groupingBy(ClassBasicReportParameters::getSchool));
                    final Map<String, List<ClassBasicReportParameters>> subjectClass = classSubject.stream().collect(Collectors.groupingBy(ClassBasicReportParameters::getSchool));
                    List<BasicReportParameters> schoolSelf =  schoolMap.get(schoolLevel.getSchool());
                    logger.info("basicReport:loading");
                    logger.info("exitCode:"+schoolLevel.getSchool());
                    ProcessBuilder processBuilder = new ProcessBuilder();
                    processBuilder.command("cmd.exe  ", "/c", schoolLevel.getCommand());
                    processBuilder.redirectErrorStream(true); // 合并标准输出和错误输出
                    Process process = null;
                    try {
                        logger.info("command = {}", schoolLevel.getCommand());
                        process = processBuilder.start();
                    } catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line;
                    while (true) {
                        try {
                            if (!((line = reader.readLine()) != null)) break;
                        } catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }


//                    while ((line = reader.readLine()) != null) {
//                    // 如果输出了 "DONE"，表示生成完毕
//                      if ("DONE".equals(line)) {
//                        break;  // 跳出循环
//                       }
//                    }
                    try {
                        int exitCode = process.waitFor();
                    } catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }

                    //上传文件
//                    File basicFile = new File("/myworkSpace/basic/");
//                    File[] basicFiles = basicFile.listFiles();
//                    assert basicFiles != null;
//                    for (File file : basicFiles) {
//                        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, fileToUrl.get(file.getName()), file);
//                        try {
//                            PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
//                            logger.info(putObjectResult.getRequestId());
//                            file.delete();
//                        } catch (CosServiceException e) {
//                            logger.info("cos服务出现问题");
//                            e.printStackTrace();
//                        } catch (CosClientException e) {
//                            logger.info("cos客户端出现问题"+file.getName()+"文件上传有误,重新上传");
//                            RetryCommand retryCommand = new RetryCommand();
//                            retryCommand.setRetryCommand(schoolLevel.getCommand());
//                            retryCommand.setParams(schoolLevel);
//                            retryCommands.add(retryCommand);
//                            e.printStackTrace();
//                        }
//                    }
                    // 学校科目报告
                    for (BasicReportParameters parameters : schoolSelf) {
                        logger.info("subjectReport:loading");
                        logger.info("exitCode:"+parameters.getSubSubject());
                        ProcessBuilder processBuilderSubject = new ProcessBuilder();
                        processBuilderSubject.command("cmd.exe  ", "/c", parameters.getCommand());
                        processBuilderSubject.redirectErrorStream(true); // 合并标准输出和错误输出
                        Process processSubject = null;
                        try {
                            logger.info("command = {}", parameters.getCommand());
                            processSubject = processBuilderSubject.start();
                        } catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        BufferedReader readerSubject = new BufferedReader(new InputStreamReader(processSubject.getInputStream()));
                        String lineSubject;
                        while (true) {
                            try {
                                if (!((lineSubject = readerSubject.readLine()) != null)) break;
                            } catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
//                        while ((lineSubject = readerSubject.readLine()) != null) {
//                            // 如果输出了 "DONE"，表示生成完毕
//                            if ("DONE".equals(lineSubject)) {
//                                break;  // 跳出循环
//                            }
//                        }
                        try {
                            int exitCodeSubject = processSubject.waitFor();
                        } catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
//                        File subjectFile = new File("/myworkSpace/subject/");
//                        File[] subjectFiles = subjectFile.listFiles();
//                        assert subjectFiles != null;
//                        for (File file : subjectFiles) {
//                            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, fileToUrl.get(file.getName()), file);
//                            try {
//                                PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
//                                logger.info(putObjectResult.getRequestId());
//                                file.delete();
//                            } catch (CosServiceException e) {
//                                logger.info("cos服务出现问题");
//                                e.printStackTrace();
//                            } catch (CosClientException e) {
//                                logger.info("cos客户端出现问题"+file.getName()+"文件上传有误,重新上传");
//                                RetryCommand retryCommand = new RetryCommand();
//                                retryCommand.setParams(parameters);
//                                retryCommand.setRetryCommand(parameters.getCommand());
//                                retryCommands.add(retryCommand);
//                                e.printStackTrace();
//                            }
//                        }
                    }
                    List<ClassBasicReportParameters> args = classBasic.get(schoolLevel.getSchool());
                    List<ClassBasicReportParameters> params = subjectClass.get(schoolLevel.getSchool());
                    for (ClassBasicReportParameters arg : args) {
                        logger.info("classBasic:loading");
                        logger.info("exitCode:"+arg.getClassName());
                        ProcessBuilder processBuilderClass = new ProcessBuilder();
                        processBuilderClass.command("cmd.exe  ", "/c", arg.getCommand());
                        processBuilderClass.redirectErrorStream(true); // 合并标准输出和错误输出
                        Process processClass = null;
                        try {
                            logger.info("command = {}", arg.getCommand());
                            processClass = processBuilderClass.start();
                        } catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        BufferedReader readerClass = new BufferedReader(new InputStreamReader(processClass.getInputStream()));
                        String lineClass;
                        while (true) {
                            try {
                                if (!((lineClass = readerClass.readLine()) != null)) break;
                            } catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
//                        while ((lineClass = readerClass.readLine()) != null) {
//                            // 如果输出了 "DONE"，表示生成完毕
//                            if ("DONE".equals(lineClass)) {
//                                break;  // 跳出循环
//                            }
//                        }
                        try {
                            int exitCodeSubject = processClass.waitFor();
                        } catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
//                        File classBasicFile = new File("/myworkSpace/Class/Basic/");
//                        File[] classBasicFiles = classBasicFile.listFiles();
//                        assert classBasicFiles != null;
//                        for (File file : classBasicFiles) {
//                            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, fileToUrl.get(file.getName()), file);
//                            try {
//                                PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
//                                logger.info(putObjectResult.getRequestId());
//                                file.delete();
//                            } catch (CosServiceException e) {
//                                logger.info("cos服务出现问题");
//                                e.printStackTrace();
//                            } catch (CosClientException e) {
//                                logger.info("cos客户端出现问题"+file.getName()+"文件上传有误,重新上传");
//                                RetryCommand retryCommand = new RetryCommand();
//                                retryCommand.setParams(arg);
//                                retryCommand.setRetryCommand(arg.getCommand());
//                                retryCommands.add(retryCommand);
//                                e.printStackTrace();
//                            }
//                        }
                        final Map<String, List<ClassBasicReportParameters>> collect = params.stream().collect(Collectors.groupingBy(ClassBasicReportParameters::getClassName));
                        List<ClassBasicReportParameters> list = collect.get(arg.getClassName());
                        for (ClassBasicReportParameters classBasicReportParameters : list) {
//                            logger.info("classSubject:loading");
                            logger.info("exitCode:"+classBasicReportParameters.getSubSubject());
                            ProcessBuilder processBuilderClassSubject = new ProcessBuilder();
                            processBuilderClassSubject.command("cmd.exe  ", "/c", classBasicReportParameters.getCommand());
                            processBuilderClassSubject.redirectErrorStream(true); // 合并标准输出和错误输出
                            Process processClassSubject = null;
                            try {
                                logger.info("command = {}", classBasicReportParameters.getCommand());
                                processClassSubject = processBuilderClassSubject.start();
                            } catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            BufferedReader readerClassSubject = new BufferedReader(new InputStreamReader(processClassSubject.getInputStream()));
                            String lineClassSubject;
                            while (true) {
                                try {
                                    if (!((lineClassSubject = readerClassSubject.readLine()) != null)) break;
                                } catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }
////                            while ((lineClassSubject = readerClassSubject.readLine()) != null) {
////                                // 如果输出了 "DONE"，表示生成完毕
////                                if ("DONE".equals(lineClassSubject)) {
////                                    break;  // 跳出循环
////                                }
////                            }
//                            try {
//                                int exitCodeSubjectClass = processClassSubject.waitFor();
//                            } catch (InterruptedException e) {
//                                throw new RuntimeException(e);
//                            }
////                            File classSubjectFile = new File("/myworkSpace/Class/subject/");
////                            File[] classSubjectFiles = classSubjectFile.listFiles();
////                            assert classSubjectFiles != null;
////                            for (File file : classSubjectFiles) {
////                                logger.info(file.getName()+"=file—>key="+fileToUrl.get(file.getName()));
////                                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, fileToUrl.get(file.getName()), file);
////                                try {
////                                    PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
////                                    logger.info(putObjectResult.getRequestId());
////                                    file.delete();
////                                } catch (CosServiceException e) {
////                                    logger.info("cos服务出现问题");
////                                    e.printStackTrace();
////                                } catch (CosClientException e) {
////                                    logger.info("cos客户端出现问题"+file.getName()+"文件上传有误,重新上传");
////                                    RetryCommand retryCommand = new RetryCommand();
////                                    retryCommand.setParams(classBasicReportParameters);
////                                    retryCommand.setRetryCommand(classBasicReportParameters.getCommand());
////                                    retryCommands.add(retryCommand);
////                                    e.printStackTrace();
////                                }
////                            }
//                        }
//
                    }

                    if(retryCommands.size()!=0){
                        logger.info("size"+retryCommands.size());
                        for (RetryCommand retryCommand : retryCommands) {
                            String command = retryCommand.getRetryCommand();
                            Object arguments = retryCommand.getParams();
                            String filePrefix = "";
                            if ( arguments instanceof BasicReportParameters){
                                BasicReportParameters  parametersOne  = (BasicReportParameters) arguments;
                                filePrefix  = parametersOne.getPrefix();
                            }
                            if (arguments instanceof ClassBasicReportParameters) {
                                ClassBasicReportParameters parametersTwo = (ClassBasicReportParameters) arguments;
                                filePrefix  = parametersTwo.getPrefix();
                            }

                            logger.info("RetryCommand:ls");
                            ProcessBuilder processBuilderClassSubject = new ProcessBuilder();
                            processBuilderClassSubject.command("cmd.exe  ", "/c", command);
                            processBuilderClassSubject.redirectErrorStream(true); // 合并标准输出和错误输出
                            Process processClassSubject = null;
                            try {
                                processClassSubject = processBuilderClassSubject.start();
                            } catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            BufferedReader readerClassSubject = new BufferedReader(new InputStreamReader(processClassSubject.getInputStream()));
                            String lineClassSubject;
                            while (true) {
                                try {
                                    if (!((lineClassSubject = readerClassSubject.readLine()) != null)) break;
                                } catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }
//                            while ((lineClassSubject = readerClassSubject.readLine()) != null) {
//                                // 如果输出了 "DONE"，表示生成完毕
//                                if ("DONE".equals(lineClassSubject)) {
//                                    break;  // 跳出循环
//                                }
//                            }
                            try {
                                int exitCodeSubjectClass = processClassSubject.waitFor();
                            } catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
//                            File classSubjectFile = new File(filePrefix);
//                            File[] classSubjectFiles = classSubjectFile.listFiles();
//                            assert classSubjectFiles != null;
//                            for (File file : classSubjectFiles) {
//                                logger.info(file.getName()+"=file—>key="+fileToUrl.get(file.getName()));
//                                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, fileToUrl.get(file.getName()), file);
//                                try {
//                                    PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
//                                    logger.info(putObjectResult.getRequestId());
//                                    file.delete();
//                                } catch (CosServiceException e) {
//                                    logger.info("cos服务出现问题");
//                                    e.printStackTrace();
//                                } catch (CosClientException e) {
//                                    logger.info("cos客户端出现问题"+file.getName()+"文件上传有误,重新上传");
//                                }
                            }

                        }

                    }

                    //插入数据
                    int rowsAffected = reportJdbcTemplate.update("UPDATE school_report_task_generate SET status = ? WHERE exam_id = ? AND region = ? AND province = ? AND school = ?",1,schoolLevel.getExamId(),schoolLevel.getRegion(),schoolLevel.getProvince(),schoolLevel.getSchool());

                    logger.info("Rows affected:" + rowsAffected);
            }
        }


        return ResponseEntity.ok("操作成功");

    }

}
