package com.example.pdfgenerator.DataProcessing;


import com.example.pdfgenerator.DtoKn;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
@SpringBootTest
public class Garbge {


    @Test
    public void meanRegion(){

        JdbcTemplate jdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        String sql = "select region1  from base_school_subject_tda20251023 where subject_type = '常规'  group by region1";

        List<String> regions = jdbcTemplate.queryForList(sql, String.class);
        for (String region : regions) {
            meanRegionTest(region,namedParameterJdbcTemplate);
        }

    }

    public void meanRegionTest(String region, NamedParameterJdbcTemplate reportJdbcTemplate){
        String sql = "select \n" +
                "knowledge,\n" +
                "stu_kn_score_rate,\n" +
                "sub_subject,\n" +
                "stu_id\n" +
                "from\n" +
                "base_student_knowledge_tda20251023\n" +
                "where\n" +
                "region1 = '"+region+"' and subject_type = '常规'";

        List<DtoKn> list =  reportJdbcTemplate.query(sql,new BeanPropertyRowMapper<>(DtoKn.class));
        Map<String, List<DtoKn>> collect = list.stream().collect(Collectors.groupingBy(DtoKn::getSubSubject));
        for (String subject : collect.keySet()) {
            List<DtoKn> subjectLis =collect.get(subject);
            String sql2 = "select \n" +
                    "stu_id\n" +
                    "from \n" +
                    "base_student_subject_tda20251023\n" +
                    "where\n" +
                    "sub_subject =  '"+subject+"'\n" +
                    "and\n" +
                    "subject_type = '常规'\n" +
                    "and\n" +
                    "region1= '"+region+"'\n" +
                    "and  \n" +
                    "stu_subject_score_rate_region_pct_rank >= 0.73";
            List<String> ids = reportJdbcTemplate.queryForList(sql2,new HashMap<>(),String.class);
            List<DtoKn> collect1 = subjectLis.stream().filter(x -> ids.contains(x.getStuId())).collect(Collectors.toList());
            Map<String, List<DtoKn>> collect2 = collect1.stream().collect(Collectors.groupingBy(DtoKn::getKnowledge));
            for (String knowledge : collect2.keySet()) {
                //优生知识点层级
                List<DtoKn> dataList = collect2.get(knowledge);
                Double sumRate = dataList.stream().mapToDouble(DtoKn::getStuKnScoreRate).sum();
                Double resultRate = sumRate/dataList.size();
                if(Double.isNaN(resultRate)||Double.isInfinite(resultRate)){
                    resultRate = 0.0;
                }
                HashMap paramsYi = new HashMap(){{
                    put("subSubject",subject);
                    put("knowledge",knowledge);
                    put("region",region);

                }};

                paramsYi.put("rate",resultRate);

                reportJdbcTemplate.update("insert into knowledge_region_excellent20251023(sub_subject,knowledge,region,rate) value (:subSubject,:knowledge,:region,:rate)",new MapSqlParameterSource(paramsYi));
            }


        }
    }


}
