package com.example.pdfgenerator.controller;

import com.example.pdfgenerator.Dto.BasicReportParameters;
import com.example.pdfgenerator.Dto.ClassBasicReportParameters;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@Controller
public class GeneratorAllTypePdfByProvinceController {

    private static final Logger logger = LoggerFactory.getLogger(GeneratorAllTypePdfByProvinceController.class);

    @Autowired
    private COSClient cosClient;

    private static Map<String,String> fileToUrl = new HashMap<>();

    JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();

    private static final String bucketName = "schoolreportpdf-1317275686";

    @RequestMapping("/GeneratorByProvinceName")
    public void generatorName(@RequestParam("examId")String examId,@RequestParam(value = "provinceName",required = false)String provinceName) throws IOException, InterruptedException {

        String suffix  = examId.trim().replace("TDA","").replace("G3","").replace("G2","").trim();

        String  synthesisSchoolSubjectReportSql = "select \n" +
                "school,exam_id,province,region,sub_subject\n" +
                "from \n" +
                "base_school_subject_tda"+suffix+" \n" +
                " where subject_type = '常规'\n";

        String  synthesisSchoolReportSql = "select \n" +
                "school,exam_id,province,region\n" +
                "from \n" +
                "base_school_total_score_tda"+suffix+"  where subject_type = '常规'\n";

        String synthesisClassSubjectReportSql = "SELECT\n" +
                "\tclass as class_name,\n" +
                "\tsub_subject,\n" +
                "\tschool,\n" +
                "\tprovince,\n" +
                "\tregion,\n" +
                "\texam_id\n" +
                "FROM\n" +
                "\tbase_student_subject_tda"+suffix+"\n" +
                "where\n" +
                "subject_type = '常规'\n" ;

        String synthesisClassReportSql = "SELECT\n" +
                "\tclass AS class_name,\n" +
                "\tschool,\n" +
                "\texam_id,\n" +
                "\tprovince,\n" +
                "\tregion \n" +
                "FROM\n" +
                "\tbase_class_total_score_tda"+suffix+"\n" +
                "WHERE\n" +
                "\tsubject_type = '常规'\n" ;

        if(provinceName!=null){

            List<String> provinceList = Arrays.asList(provinceName.split("#"));

            String appendStatement  = "and province in (" ;

            for (String s : provinceList) {
                appendStatement = appendStatement +"'"+s+"',";
            }

            appendStatement = appendStatement.substring(0,appendStatement.length()-1)+") ";

            synthesisSchoolSubjectReportSql = synthesisSchoolSubjectReportSql + " " + appendStatement;
            synthesisSchoolReportSql = synthesisSchoolReportSql + " " + appendStatement ;
            synthesisClassSubjectReportSql = synthesisClassSubjectReportSql + " " + appendStatement;
            synthesisClassReportSql = synthesisClassReportSql + " " + appendStatement;


        }

        synthesisSchoolSubjectReportSql = synthesisSchoolSubjectReportSql + "group by school,exam_id,province,region,sub_subject";

        synthesisSchoolReportSql = synthesisSchoolReportSql + " " + "group by school,exam_id,province,region";

        synthesisClassSubjectReportSql = synthesisClassSubjectReportSql + " " +  "\tGROUP BY\n" +"\tclass,\n" + "\tsub_subject,\n" + "\tschool,\n" + "\tprovince,\n" + "\tregion,\n" + "\texam_id";

        synthesisClassReportSql = synthesisClassReportSql + " " + "GROUP BY\n" + "\tclass,\n" + "\tschool,\n" + "\texam_id,\n" + "\tprovince,\n" + "\tregion\n";




        List<BasicReportParameters> synthesisSchoolSubjectReportParameters = this.reportJdbcTemplate.query(synthesisSchoolSubjectReportSql, new Object[]{}, new BeanPropertyRowMapper<>(BasicReportParameters.class));

        for (BasicReportParameters parameter : synthesisSchoolSubjectReportParameters) {
            if(parameter.getRegion().equals("改革")||parameter.getRegion().equals("改革A")){
                String command = "node /myworkSpace/puppeteer2.js \"http://localhost:8080/pdf/subject?province=condition5&school=condition1&examId=condition4&region=conditionC&subSubject=condition6&subjectType=常规\" pdf";
                command = command.replace("condition1", parameter.getSchool()).replace("condition5", parameter.getProvince()).replace("conditionC", parameter.getRegion()).replace("condition4", parameter.getExamId()).replace("condition6", parameter.getSubSubject())
                        .concat(" ").concat("/myworkSpace/subject/" + parameter.getRegion() + parameter.getProvince() + parameter.getSchool() + parameter.getSubSubject() + parameter.getExamId() + ".pdf");
                parameter.setCommand(command);
            }else{
                String command = "node /myworkSpace/puppeteer2.js \"http://localhost:8080/pdf/subject?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subSubject=condition6&subjectType=常规\" pdf";
                command = command.replace("condition1", parameter.getSchool()).replace("condition5", parameter.getProvince()).replace("condition3", parameter.getRegion()).replace("condition4", parameter.getExamId()).replace("condition6", parameter.getSubSubject())
                        .concat(" ").concat("/myworkSpace/subject/" + parameter.getRegion() + parameter.getProvince() + parameter.getSchool() + parameter.getSubSubject() + parameter.getExamId() + ".pdf");
                parameter.setCommand(command);
            }
        }

        List<BasicReportParameters> synthesisSchoolReportParameters = this.reportJdbcTemplate.query(synthesisSchoolReportSql, new Object[]{}, new BeanPropertyRowMapper<>(BasicReportParameters.class));

        for (BasicReportParameters synthesisSchoolReportParameter : synthesisSchoolReportParameters) {
            if(synthesisSchoolReportParameter.getRegion().equals("改革")||synthesisSchoolReportParameter.getRegion().equals("改革A")){
                String command = "node /myworkSpace/puppeteer.js \"http://localhost:8080/pdf/basic?province=condition5&school=condition1&examId=condition4&region=conditionC&subjectType=常规\" pdf ";
                command = command.replace("condition1", synthesisSchoolReportParameter.getSchool()).replace("condition5", synthesisSchoolReportParameter.getProvince()).replace("conditionC",synthesisSchoolReportParameter.getRegion()).replace("condition4", synthesisSchoolReportParameter.getExamId())
                        .concat(" ").concat("/myworkSpace/basic/"+synthesisSchoolReportParameter.getRegion()+synthesisSchoolReportParameter.getProvince()+synthesisSchoolReportParameter.getSchool()+synthesisSchoolReportParameter.getExamId()+".pdf");
                synthesisSchoolReportParameter.setCommand(command);
            }else{
                String command = "node /myworkSpace/puppeteer.js \"http://localhost:8080/pdf/basic?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subjectType=常规\" pdf ";
                command = command.replace("condition1", synthesisSchoolReportParameter.getSchool()).replace("condition5", synthesisSchoolReportParameter.getProvince()).replace("condition3",synthesisSchoolReportParameter.getRegion()).replace("condition4", synthesisSchoolReportParameter.getExamId())
                        .concat(" ").concat("/myworkSpace/basic/"+synthesisSchoolReportParameter.getRegion()+synthesisSchoolReportParameter.getProvince()+synthesisSchoolReportParameter.getSchool()+synthesisSchoolReportParameter.getExamId()+".pdf");
                synthesisSchoolReportParameter.setCommand(command);
            }
        }

        List<ClassBasicReportParameters> synthesisClassSubjectReportParameters = this.reportJdbcTemplate.query(synthesisClassSubjectReportSql,new Object[]{},new BeanPropertyRowMapper<>(ClassBasicReportParameters.class));

        for (ClassBasicReportParameters synthesisClassSubjectReportParameter : synthesisClassSubjectReportParameters) {

            if (synthesisClassSubjectReportParameter.getRegion().equals("改革")||synthesisClassSubjectReportParameter.getRegion().equals("改革A")) {
                String command = "node /myworkSpace/pdfOfClassSubjectGen.js \"http://localhost:8080/pdf/classSubject?province=condition5&school=condition1&examId=condition4&region=conditionC&subSubject=condition6&subjectType=常规&className=conditionA\" pdf";
                String fileName = "/myworkSpace/Class/subject/" + synthesisClassSubjectReportParameter.getRegion() + synthesisClassSubjectReportParameter.getProvince() + synthesisClassSubjectReportParameter.getSchool() + synthesisClassSubjectReportParameter.getSubSubject() + synthesisClassSubjectReportParameter.getExamId() + synthesisClassSubjectReportParameter.getSubSubject() + synthesisClassSubjectReportParameter.getClassName().replace(" ","")+ ".pdf";
                command = command.replace("condition1", synthesisClassSubjectReportParameter.getSchool()).replace("condition5", synthesisClassSubjectReportParameter.getProvince()).replace("conditionC", synthesisClassSubjectReportParameter.getRegion()).replace("condition4", synthesisClassSubjectReportParameter.getExamId()).replace("condition6", synthesisClassSubjectReportParameter.getSubSubject()).replace("conditionA",synthesisClassSubjectReportParameter.getClassName())
                        .concat(" ").concat(fileName);
                fileToUrl.put(fileName.replace("/myworkSpace/Class/subject/",""),"/testClass/"+synthesisClassSubjectReportParameter.getExamId()+"/"+synthesisClassSubjectReportParameter.getProvince()+"/"+synthesisClassSubjectReportParameter.getSchool()+"/班级学科报告/"+synthesisClassSubjectReportParameter.getClassName()+"/"+synthesisClassSubjectReportParameter.getSubSubject()+"/"+fileName.replace("/myworkSpace/Class/subject/",""));
                synthesisClassSubjectReportParameter.setCommand(command);
            } else {
                String command = "node /myworkSpace/pdfOfClassSubjectGen.js \"http://localhost:8080/pdf/classSubject?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subSubject=condition6&subjectType=常规&className=conditionA\" pdf";

                String fileName = "/myworkSpace/Class/subject/" + synthesisClassSubjectReportParameter.getRegion() + synthesisClassSubjectReportParameter.getProvince() + synthesisClassSubjectReportParameter.getSchool() + synthesisClassSubjectReportParameter.getSubSubject() + synthesisClassSubjectReportParameter.getExamId() + synthesisClassSubjectReportParameter.getSubSubject() + synthesisClassSubjectReportParameter.getClassName().replace(" ","")+".pdf";
                command = command.replace("condition1", synthesisClassSubjectReportParameter.getSchool()).replace("condition5", synthesisClassSubjectReportParameter.getProvince()).replace("condition3", synthesisClassSubjectReportParameter.getRegion()).replace("condition4", synthesisClassSubjectReportParameter.getExamId()).replace("condition6", synthesisClassSubjectReportParameter.getSubSubject()).replace("conditionA",synthesisClassSubjectReportParameter.getClassName())
                        .concat(" ").concat(fileName);
                fileToUrl.put(fileName.replace("/myworkSpace/Class/subject/",""),"/testClass/"+synthesisClassSubjectReportParameter.getExamId()+"/"+synthesisClassSubjectReportParameter.getProvince()+"/"+synthesisClassSubjectReportParameter.getSchool()+"/班级学科报告/"+synthesisClassSubjectReportParameter.getClassName()+"/"+synthesisClassSubjectReportParameter.getSubSubject()+"/"+fileName.replace("/myworkSpace/Class/subject/",""));
                synthesisClassSubjectReportParameter.setCommand(command);
            }
        }

        List<ClassBasicReportParameters> synthesisClassReportParameters = this.reportJdbcTemplate.query(synthesisClassReportSql,new Object[]{},new BeanPropertyRowMapper<>(ClassBasicReportParameters.class));

        for (ClassBasicReportParameters synthesisClassReportParameter : synthesisClassReportParameters) {
            if(synthesisClassReportParameter.getRegion().equals("改革")||synthesisClassReportParameter.getRegion().equals("改革A")){

                String  command = "node /myworkSpace/pdfOfClassBasicGen.js \"http://localhost:8080/pdf/classBasic?province=condition5&school=condition1&examId=condition4&region=conditionC&subjectType=常规&className=conditionA\" pdf ";

                String fileName = "/myworkSpace/Class/Basic/"+synthesisClassReportParameter.getRegion()+synthesisClassReportParameter.getProvince()+synthesisClassReportParameter.getSchool()+ synthesisClassReportParameter.getClassName()+synthesisClassReportParameter.getExamId()+".pdf";

                command = command.replace("condition1", synthesisClassReportParameter.getSchool()).replace("condition5", synthesisClassReportParameter.getProvince()).replace("conditionC",synthesisClassReportParameter.getRegion()).replace("condition4", synthesisClassReportParameter.getExamId()).replace("conditionA",synthesisClassReportParameter.getClassName())
                        .concat(" ").concat(fileName);
                fileToUrl.put(fileName.replace("/myworkSpace/Class/Basic/",""),"/testClass/"+synthesisClassReportParameter.getExamId()+"/"+synthesisClassReportParameter.getProvince()+"/"+synthesisClassReportParameter.getSchool()+"/班级综合报告/"+synthesisClassReportParameter.getClassName()+"/"+fileName.replace("/myworkSpace/Class/Basic/",""));
                synthesisClassReportParameter.setCommand(command);

            } else {

                String command = "node/myworkSpace/pdfOfClassBasicGen.js \"http://localhost:8080/pdf/classBasic?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subjectType=常规&className=conditionA\" pdf ";

                String fileName = "/myworkSpace/Class/Basic/"+synthesisClassReportParameter.getRegion()+synthesisClassReportParameter.getProvince()+synthesisClassReportParameter.getSchool()+synthesisClassReportParameter.getClassName()+synthesisClassReportParameter.getExamId()+".pdf";

                command = command.replace("condition1", synthesisClassReportParameter.getSchool()).replace("condition5", synthesisClassReportParameter.getProvince()).replace("condition3",synthesisClassReportParameter.getRegion()).replace("condition4", synthesisClassReportParameter.getExamId()).replace("conditionA",synthesisClassReportParameter.getClassName())
                        .concat(" ").concat(fileName);
                fileToUrl.put(fileName.replace("/myworkSpace/Class/Basic/",""),"/testClass/"+synthesisClassReportParameter.getExamId()+"/"+synthesisClassReportParameter.getProvince()+"/"+synthesisClassReportParameter.getSchool()+"/班级综合报告/"+synthesisClassReportParameter.getClassName()+"/"+fileName.replace("/myworkSpace/Class/Basic/",""));
                synthesisClassReportParameter.setCommand(command);

            }
        }

        Map<String, List<BasicReportParameters>>  schoolReport = synthesisSchoolReportParameters.stream().collect(Collectors.groupingBy(BasicReportParameters::getProvince));

        Map<String, List<BasicReportParameters>>  schoolSubjectReport = synthesisSchoolSubjectReportParameters.stream().collect(Collectors.groupingBy(BasicReportParameters::getProvince));

        Map<String, List<ClassBasicReportParameters>>  classReport = synthesisClassReportParameters.stream().collect(Collectors.groupingBy(ClassBasicReportParameters::getProvince));

        Map<String, List<ClassBasicReportParameters>>  classSubjectReport = synthesisClassSubjectReportParameters.stream().collect(Collectors.groupingBy(ClassBasicReportParameters::getProvince));


        //分组开始执行记录
        for (String key : schoolReport.keySet()) {
            logger.info("province:"+key+ "Gen...............................................................");
            List<BasicReportParameters>  schoolBasicReport = schoolReport.get(key);
            List<BasicReportParameters>  schoolSubject = schoolSubjectReport.get(key);
            List<ClassBasicReportParameters> classBasicReport = classReport.get(key);
            List<ClassBasicReportParameters> classSubject = classSubjectReport.get(key);
            for (BasicReportParameters schoolLevel : schoolBasicReport) {
                logger.info("school:"+schoolLevel.getSchool()+"loading---------------------------------------------------------------");
                Map<String, List<BasicReportParameters>>  schoolMap= schoolSubject.stream().collect(Collectors.groupingBy(BasicReportParameters::getSchool));
                Map<String, List<ClassBasicReportParameters>> classBasic = classBasicReport.stream().collect(Collectors.groupingBy(ClassBasicReportParameters::getSchool));
                final Map<String, List<ClassBasicReportParameters>> subjectClass = classSubject.stream().collect(Collectors.groupingBy(ClassBasicReportParameters::getSchool));
                List<BasicReportParameters> schoolSelf =  schoolMap.get(schoolLevel.getSchool());
                logger.info("basicReport:loading******************************************");
                ProcessBuilder processBuilder = new ProcessBuilder();
                processBuilder.command("bash", "-c", schoolLevel.getCommand());
                processBuilder.redirectErrorStream(true); // 合并标准输出和错误输出
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line;
                while ((line = reader.readLine()) != null) {
                }
                int exitCode = process.waitFor();
                logger.info("exitCode:"+schoolLevel.getSchool());
                //上传文件
                File basicFile = new File("/myworkSpace/basic/");
                File[] basicFiles = basicFile.listFiles();
                assert basicFiles != null;
                for (File file : basicFiles) {
                    PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, "PdfTest/"+file.getName(), file);
                    try {
                        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                        logger.info(putObjectResult.getRequestId());
                        file.delete();
                    } catch (CosServiceException e) {
                        logger.info("cos服务出现问题");
                        e.printStackTrace();
                    } catch (CosClientException e) {
                        logger.info("cos客户端出现问题"+file.getName()+"文件上传有误,重新上传");
                        e.printStackTrace();
                    }
                }
                for (BasicReportParameters parameters : schoolSelf) {
                    logger.info("subjectReport:loading***************************************************************");
                    ProcessBuilder processBuilderSubject = new ProcessBuilder();
                    processBuilderSubject.command("bash", "-c", parameters.getCommand());
                    processBuilderSubject.redirectErrorStream(true); // 合并标准输出和错误输出
                    Process processSubject = processBuilderSubject.start();
                    BufferedReader readerSubject = new BufferedReader(new InputStreamReader(processSubject.getInputStream()));
                    String lineSubject;
                    while ((lineSubject = readerSubject.readLine()) != null) {
                    }
                    int exitCodeSubject = processSubject.waitFor();
                    logger.info("exitCode:"+parameters.getSubSubject());
                    File subjectFile = new File("/myworkSpace/subject/");
                    File[] subjectFiles = subjectFile.listFiles();
                    assert subjectFiles != null;
                    for (File file : subjectFiles) {
                        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, "PdfSubjectTest/"+file.getName(), file);
                        try {
                            PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                            logger.info(putObjectResult.getRequestId());
                            file.delete();
                        } catch (CosServiceException e) {
                            logger.info("cos服务出现问题");
                            e.printStackTrace();
                        } catch (CosClientException e) {
                            logger.info("cos客户端出现问题"+file.getName()+"文件上传有误,重新上传");
                            e.printStackTrace();
                        }
                    }
                }
                List<ClassBasicReportParameters> args = classBasic.get(schoolLevel.getSchool());
                List<ClassBasicReportParameters> params = subjectClass.get(schoolLevel.getSchool());
                for (ClassBasicReportParameters arg : args) {
                    logger.info("classBasic:loading++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                    ProcessBuilder processBuilderClass = new ProcessBuilder();
                    processBuilderClass.command("bash", "-c", arg.getCommand());
                    processBuilderClass.redirectErrorStream(true); // 合并标准输出和错误输出
                    Process processClass = processBuilderClass.start();
                    BufferedReader readerClass = new BufferedReader(new InputStreamReader(processClass.getInputStream()));
                    String lineClass;
                    while ((lineClass = readerClass.readLine()) != null) {
                    }
                    int exitCodeSubject = processClass.waitFor();
                    logger.info("exitCode:"+arg.getClassName());
                    File classBasicFile = new File("/myworkSpace/Class/Basic/");
                    File[] classBasicFiles = classBasicFile.listFiles();
                    assert classBasicFiles != null;
                    for (File file : classBasicFiles) {
                        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, fileToUrl.get(file.getName()), file);
                        try {
                            PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                            logger.info(putObjectResult.getRequestId());
                            file.delete();
                        } catch (CosServiceException e) {
                            logger.info("cos服务出现问题");
                            e.printStackTrace();
                        } catch (CosClientException e) {
                            logger.info("cos客户端出现问题"+file.getName()+"文件上传有误,重新上传");
                            e.printStackTrace();
                        }
                    }
                    final Map<String, List<ClassBasicReportParameters>> collect = params.stream().collect(Collectors.groupingBy(ClassBasicReportParameters::getClassName));
                    List<ClassBasicReportParameters> list = collect.get(arg.getClassName());
                    for (ClassBasicReportParameters classBasicReportParameters : list) {
                        logger.info("classSubject:loading++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                        ProcessBuilder processBuilderClassSubject = new ProcessBuilder();
                        processBuilderClassSubject.command("bash", "-c", classBasicReportParameters.getCommand());
                        processBuilderClassSubject.redirectErrorStream(true); // 合并标准输出和错误输出
                        Process processClassSubject = processBuilderClassSubject.start();
                        BufferedReader readerClassSubject = new BufferedReader(new InputStreamReader(processClassSubject.getInputStream()));
                        String lineClassSubject;
                        while ((lineClassSubject = readerClassSubject.readLine()) != null) {
                        }
                        int exitCodeSubjectClass = processClassSubject.waitFor();
                        logger.info("exitCode:"+classBasicReportParameters.getSubSubject());
                        File classSubjectFile = new File("/myworkSpace/Class/subject/");
                        File[] classSubjectFiles = classSubjectFile.listFiles();
                        assert classSubjectFiles != null;
                        for (File file : classSubjectFiles) {
                            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, fileToUrl.get(file.getName()), file);
                            try {
                                PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                                logger.info(putObjectResult.getRequestId());
                                file.delete();
                            } catch (CosServiceException e) {
                                logger.info("cos服务出现问题");
                                e.printStackTrace();
                            } catch (CosClientException e) {
                                logger.info("cos客户端出现问题"+file.getName()+"文件上传有误,重新上传");
                                e.printStackTrace();
                            }
                        }
                    }
                }
                //插入数据
                int rowsAffected = reportJdbcTemplate.update("UPDATE school_report_task_generate SET status = ? WHERE exam_id = ? AND region = ? AND province = ? AND school = ?",1,schoolLevel.getExamId(),schoolLevel.getRegion(),schoolLevel.getProvince(),schoolLevel.getSchool());

                logger.info("Rows affected:" + rowsAffected);

            }

        }

    }

}
