package com.example.pdfgenerator.DataProcessing;


import com.example.pdfgenerator.DeFenLu;
import com.example.pdfgenerator.Dto.DtoArgs;
import com.example.pdfgenerator.Dto.Params;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@SpringBootTest
public class ClassIncrement {


    @Test
    public void GeProvinceQuesTypeSituation(){

        String sql  = "select region1" +
                " as region,province from base_province_subject_tda20241215 where subject_type = '常规' group by region1,province";
        JdbcTemplate jdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();
        List<Params> params  = jdbcTemplate.query(sql,new Object[]{},new BeanPropertyRowMapper<>(Params.class));
        for (Params param : params) {
            ProcessProvinceExcellentQuesTypeSituation(param.getProvince(),param.getRegion(),jdbcTemplate);
        }

    }

    private void ProcessProvinceExcellentQuesTypeSituation(String province, String region, JdbcTemplate jdbcTemplate) {

        String sql =  "select\n" +
                "ques_type,\n" +
                "stu_qt_score_rate,\n" +
                "sub_subject,\n" +
                "stu_id\n" +
                "from\n" +
                "base_student_ques_type_tda20241215\n" +
                "where\n" +
                "region1 = '"+region+"'\n" +
                "AND province = '"+province+"'\n" +
                "\t\t\tAND subject_type = '常规' \n" +
                "\t\t\tAND exam_id = 'TDA20241215G3'\n";
        List<DtoArgs>  list =  jdbcTemplate.query(sql,new Object[]{},new BeanPropertyRowMapper<>(DtoArgs.class));
        Map<String, List<DtoArgs>> collect = list.stream().collect(Collectors.groupingBy(DtoArgs::getSubSubject));
        for(String subject : collect.keySet()){
            String sql2 = "SELECT\n" +
                    "\tstu_id \n" +
                    "FROM\n" +
                    "\tbase_student_subject_tda20241215 \n" +
                    "WHERE\n" +
                    "\tstu_subject_score_rate_province_pct_rank >= ( 1-0.27 ) \n" +
                    "\tAND region1 = '"+region+"' \n" +
                    "\tAND province = '"+province+"' \n" +
                    "\tAND subject_type = '常规' \n" +
                    "\tAND exam_id = 'TDA20241215G3' \n" +
                    "\tAND sub_subject = '"+subject+"'";

            List<String>  excellentIds = jdbcTemplate.queryForList(sql2,String.class);

            //单科
            List<DtoArgs> quesTypeList  = collect.get(subject);

            //本省优生 各种题型的得分率数据
            List<DtoArgs> excellentStuList  = quesTypeList.stream().filter(x->excellentIds.contains(x.getStuId())).collect(Collectors.toList());

            Map<String, List<DtoArgs>> excellentGroupByQuesType = excellentStuList.stream().collect(Collectors.groupingBy(DtoArgs::getQuesType));

            for (String ques_type : excellentGroupByQuesType.keySet()) {
                //进行插入数据
                List<DtoArgs> finalList = excellentGroupByQuesType.get(ques_type);
                Double typeRateMean = finalList.stream().mapToDouble(DtoArgs::getStuQtScoreRate).sum();
                Double resultMean = typeRateMean/finalList.size();
                if(Double.isNaN(resultMean)||Double.isInfinite(resultMean)){
                    resultMean = 0.0;
                }

                System.out.println(resultMean);
                HashMap params = new HashMap(){{
                    put("province",province);
                    put("subSubject",subject);
                    put("region",region);
                    put("quesType",ques_type);
                }};
                params.put("Mean",resultMean);

                NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);
                namedParameterJdbcTemplate.update("insert into province_ques_type_excellent20241215(region,province,sub_subject,mean,ques_type) value (:region,:province,:subSubject,:Mean,:quesType)",new MapSqlParameterSource(params));
            }

        }
    }



    @Test
    public void GeProvinceExcellentDifficultySituations(){

        String sql  = "select region1 as region,province from base_province_subject_tda20241215 where subject_type = '常规' group by region1,province";
        JdbcTemplate jdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();
        List<Params> params  = jdbcTemplate.query(sql,new Object[]{},new BeanPropertyRowMapper<>(Params.class));
        for (Params param : params) {
            ProcessProvinceExcellentQuestTypeDifficultyLevel(param.getProvince(),param.getRegion(),jdbcTemplate);
        }

    }

    private void ProcessProvinceExcellentQuestTypeDifficultyLevel(String province, String region, JdbcTemplate jdbcTemplate) {

        String sql  =  "SELECT\n" +
                "\ta.region1 as region,\n" +
                "\ta.sub_subject,\n" +
                "\ta.subject_type,\n" +
                "\ta.exam_id,\n" +
                "\ta.ques_no,\n" +
                "\ta.region_ques_standard_difficulty,\n" +
                "\tb.stu_ques_score,\n" +
                "\tb.`ques_max_score`,\n" +
                "\tb.`stu_id`\n" +
                "\tFROM\n" +
                "\tbase_area_question_tda20241215 a\n" +
                "\tleft join base_student_question_tda20241215 b  on a.ques_no = b.ques_no and a.sub_subject = b.`sub_subject` and a.region1 = b.region1 and a.subject_type = b.subject_type\n" +
                "\twhere  a.subject_type = '常规' and a.region1 = '"+region+"' and b.province = '"+province+"'";

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);
        System.out.println("emoj--->"+sql);
        List<DeFenLu> list = namedParameterJdbcTemplate.query(sql, new BeanPropertyRowMapper<>(DeFenLu.class));

        //化学 --》list  物理 ----》list
        Map<String, List<DeFenLu>> collect = list.stream().collect(Collectors.groupingBy(DeFenLu::getSubSubject));

        for (String subject : collect.keySet()) {

            String sql2  = "select stu_id from base_student_subject_tda20241215 where sub_subject = '"+subject+"' and region1 = '"+region+"' and province = '"+province +"' and stu_subject_score_rate_province_pct_rank >= 0.73 and subject_type = '常规'";

            List<String> excellentIds =  namedParameterJdbcTemplate.queryForList(sql2,new HashMap<>(),String.class);

            System.out.println("处理"+subject+"学科");

            List<DeFenLu> deFenLus = collect.get(subject);

            //本省优生的难度情况
            deFenLus = deFenLus.stream().filter(x->excellentIds.contains(x.getStuId())).collect(Collectors.toList());

            List<DeFenLu> yi = new ArrayList<>();
            List<DeFenLu> jiaoyi = new ArrayList<>();
            List<DeFenLu> zhong = new ArrayList<>();
            List<DeFenLu> jiaonan = new ArrayList<>();
            List<DeFenLu> nan = new ArrayList<>();

            //单个科目答题记录：记录体型难度情况
            for (DeFenLu fenLus : deFenLus) {
                if(fenLus.getRegionQuesStandardDifficulty()>=0&&fenLus.getRegionQuesStandardDifficulty()<5){
                    yi.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=5&&fenLus.getRegionQuesStandardDifficulty()<10){
                    jiaoyi.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=10&&fenLus.getRegionQuesStandardDifficulty()<15){
                    zhong.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=15&&fenLus.getRegionQuesStandardDifficulty()<20){
                    jiaonan.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=20&&fenLus.getRegionQuesStandardDifficulty()<=25){
                    nan.add(fenLus);
                }
            }
            //处理难易程度的得分率
            double yiStuSum = yi.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double yiSum = yi.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double jiaoyiStuSum = jiaoyi.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double jiaoyiyiSum = jiaoyi.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double zhongStuSum = zhong.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double zhongSum = zhong.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double jiaonanStuSum = jiaonan.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double jiaonanSum = jiaonan.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double nanStuSum = nan.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double nanSum = nan.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            System.out.println(yiStuSum/yiSum);
            double yiResult = (Double.isNaN(yiStuSum/yiSum)||Double.isInfinite(yiStuSum/yiSum))?0.0:(yiStuSum/yiSum);
            System.out.println(jiaoyiStuSum/jiaoyiyiSum);
            double jiaoyiResult = (Double.isNaN(jiaoyiStuSum/jiaoyiyiSum)||Double.isInfinite(jiaoyiStuSum/jiaoyiyiSum))?0.0:(jiaoyiStuSum/jiaoyiyiSum);
            System.out.println(zhongStuSum/zhongSum);
            double zhongResult = (Double.isNaN(zhongStuSum/zhongSum)||Double.isInfinite(zhongStuSum/zhongSum))?0.0:(zhongStuSum/zhongSum);
            System.out.println(jiaonanStuSum/jiaonanSum);
            double jiaonanResult = (Double.isNaN(jiaonanStuSum/jiaonanSum)||Double.isInfinite(jiaonanStuSum/jiaonanSum))?0.0:(jiaonanStuSum/jiaonanSum);
            System.out.println(nanStuSum/nanSum);
            double nanResult = (Double.isNaN(nanStuSum/nanSum)||Double.isInfinite(nanStuSum/nanSum))?0.0:(nanStuSum/nanSum);
            HashMap paramsYi = new HashMap(){{
                put("province",province);
                put("subSubject",subject);
                put("difficult","易");
                put("region",region);
                put("scoreMean", yiResult);
            }};
            HashMap paramsJiaoYi = new HashMap(){{
                put("province",province);
                put("subSubject",subject);
                put("difficult","较易");
                put("region",region);
                put("scoreMean", jiaoyiResult);
            }};
            HashMap paramsZhong = new HashMap(){{
                put("province",province);
                put("subSubject",subject);
                put("difficult","中");
                put("region",region);
                put("scoreMean", zhongResult);
            }};
            HashMap paramsJiaoNan = new HashMap(){{
                put("province",province);
                put("subSubject",subject);
                put("difficult","较难");
                put("region",region);
                put("scoreMean", jiaonanResult);
            }};
            HashMap paramsNan= new HashMap(){{
                put("province",province);
                put("subSubject",subject);
                put("difficult","难");
                put("region",region);
                put("scoreMean", nanResult);
            }};

            namedParameterJdbcTemplate.update("insert into province_excellent_difficult20241215(sub_subject,difficult,region,province,score_mean) value(:subSubject,:difficult,:region,:province,:scoreMean)",new MapSqlParameterSource(paramsYi));
            namedParameterJdbcTemplate.update("insert into province_excellent_difficult20241215(sub_subject,difficult,region,province,score_mean) value(:subSubject,:difficult,:region,:province,:scoreMean)",new MapSqlParameterSource(paramsJiaoYi));
            namedParameterJdbcTemplate.update("insert into province_excellent_difficult20241215(sub_subject,difficult,region,province,score_mean) value(:subSubject,:difficult,:region,:province,:scoreMean)",new MapSqlParameterSource(paramsZhong));
            namedParameterJdbcTemplate.update("insert into province_excellent_difficult20241215(sub_subject,difficult,region,province,score_mean) value(:subSubject,:difficult,:region,:province,:scoreMean)",new MapSqlParameterSource(paramsJiaoNan));
            namedParameterJdbcTemplate.update("insert into province_excellent_difficult20241215(sub_subject,difficult,region,province,score_mean) value(:subSubject,:difficult,:region,:province,:scoreMean)",new MapSqlParameterSource(paramsNan));

        }

    }




}
