package com.example.pdfgenerator.GenerateTable;


import com.example.pdfgenerator.config.MyDataSourceConfig;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jdbc.core.JdbcTemplate;

@SpringBootTest
public class GenerateSchool {


    @Test
    public void GenerateSchool(){
        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();

        String examId = "TDA20241215G3";

        String suffix = examId.replace("TDA","").replace("G2","").replace("G3","");

        String createTableClassDifficult = "CREATE TABLE  IF NOT EXISTS `class_diffficult"+suffix+"` (\n" +
                "  `id` int NOT NULL AUTO_INCREMENT,\n" +
                "  `class` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `school` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `sub_subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `difficult` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `region` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `score_mean` double DEFAULT NULL,\n" +
                "  PRIMARY KEY (`id`) USING BTREE\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=17401 DEFAULT CHARSET=utf8mb3";

        String createTableProvinceDifficult = "CREATE TABLE  IF NOT EXISTS  `province_difficult"+suffix+"` (\n" +
                "  `id` int NOT NULL AUTO_INCREMENT,\n" +
                "  `province` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `region` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `sub_subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `difficult` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `score_mean` double DEFAULT NULL,\n" +
                "  PRIMARY KEY (`id`) USING BTREE\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=371 DEFAULT CHARSET=utf8mb3";

        String createTableProvinceExcellentDifficult = "CREATE TABLE IF NOT EXISTS `province_excellent_difficult"+suffix+"` (\n" +
                "  `id` int NOT NULL AUTO_INCREMENT,\n" +
                "  `region` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `province` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `sub_subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `difficult` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `score_mean` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  PRIMARY KEY (`id`) USING BTREE\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=916 DEFAULT CHARSET=utf8mb3";

        String createTableRegionDifficult = "CREATE TABLE `region_difficult"+suffix+"` (\n" +
                "  `id` int NOT NULL AUTO_INCREMENT,\n" +
                "  `region` varchar(255) DEFAULT NULL,\n" +
                "  `sub_subject` varchar(255) DEFAULT NULL,\n" +
                "  `difficult` varchar(255) DEFAULT NULL,\n" +
                "  `score_mean` varchar(255) DEFAULT NULL,\n" +
                "  PRIMARY KEY (`id`)\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb3";

        String createTableRegionExcellentDifficult = "CREATE TABLE IF NOT EXISTS `region_excellent_difficult"+suffix+"` (\n" +
                "  `id` int NOT NULL AUTO_INCREMENT,\n" +
                "  `region` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `sub_subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `difficult` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `score_mean` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  PRIMARY KEY (`id`) USING BTREE\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb3";

        String createTableSchoolDifficult = "CREATE TABLE  IF NOT EXISTS `school_diffficult"+suffix+"` (\n" +
                "  `id` int NOT NULL AUTO_INCREMENT,\n" +
                "  `school` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `sub_subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `difficult` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `region` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `score_mean` double DEFAULT NULL,\n" +
                "  PRIMARY KEY (`id`) USING BTREE\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=7176 DEFAULT CHARSET=utf8mb3";

        String createTableKnowledgeProvinceExcellent = "CREATE TABLE IF NOT EXISTS `knowledge_province_excellent"+suffix+"` (\n" +
                "  `id` int NOT NULL AUTO_INCREMENT,\n" +
                "  `region` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `province` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `sub_subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `rate` double DEFAULT NULL,\n" +
                "  `knowledge` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  PRIMARY KEY (`id`) USING BTREE\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=811 DEFAULT CHARSET=utf8mb3";

        String createTableKnowledgeRegionExcellent = "CREATE TABLE IF NOT EXISTS  `knowledge_region_excellent"+suffix+"` (\n" +
                "  `id` int NOT NULL AUTO_INCREMENT,\n" +
                "  `region` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `sub_subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `knowledge` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `rate` double DEFAULT NULL,\n" +
                "  PRIMARY KEY (`id`) USING BTREE\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=218 DEFAULT CHARSET=utf8mb3";

        String createTableProvinceExcellentAswTime = "CREATE TABLE  IF NOT EXISTS  `province_excellent_asw_time"+suffix+"` (\n" +
                "  `id` int NOT NULL AUTO_INCREMENT,\n" +
                "  `region` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `province` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `sub_subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `ques_no` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `time` double DEFAULT NULL,\n" +
                "  PRIMARY KEY (`id`) USING BTREE\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=916 DEFAULT CHARSET=utf8mb3";

        String createTableProvinceQuesTypeExcellent = "CREATE TABLE  \n" +
                "IF NOT EXISTS  `province_ques_type_excellent"+suffix+"` (\n" +
                "  `id` int NOT NULL AUTO_INCREMENT,\n" +
                "  `region` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `province` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `sub_subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `ques_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `mean` double DEFAULT NULL,\n" +
                "  PRIMARY KEY (`id`) USING BTREE\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=526 DEFAULT CHARSET=utf8mb3\n";

        String createTableRegionExcellentAswTime = "CREATE TABLE  \n" +
                "IF NOT EXISTS  `region_excellent_asw_time"+suffix+"` (\n" +
                "  `id` int NOT NULL AUTO_INCREMENT,\n" +
                "  `region` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `ques_no` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `sub_subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `time` double DEFAULT NULL,\n" +
                "  PRIMARY KEY (`id`) USING BTREE\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=273 DEFAULT CHARSET=utf8mb3";

        String createTableRegionQuesTypeExcellent = "CREATE TABLE IF NOT EXISTS `region_ques_type_excellent"+suffix+"` (\n" +
                "  `id` int NOT NULL AUTO_INCREMENT,\n" +
                "  `region` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `sub_subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `ques_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,\n" +
                "  `mean` double DEFAULT NULL,\n" +
                "  PRIMARY KEY (`id`) USING BTREE\n" +
                ") ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb3";


        reportJdbcTemplate.update(createTableClassDifficult);
        reportJdbcTemplate.update(createTableProvinceDifficult);
        reportJdbcTemplate.update(createTableProvinceExcellentDifficult);
        reportJdbcTemplate.update(createTableRegionExcellentDifficult);
        reportJdbcTemplate.update(createTableKnowledgeProvinceExcellent);
        reportJdbcTemplate.update(createTableKnowledgeRegionExcellent);
        reportJdbcTemplate.update(createTableProvinceExcellentAswTime);
        reportJdbcTemplate.update(createTableProvinceQuesTypeExcellent);
        reportJdbcTemplate.update(createTableRegionDifficult);
        reportJdbcTemplate.update(createTableSchoolDifficult);
        reportJdbcTemplate.update(createTableRegionExcellentAswTime);
        reportJdbcTemplate.update(createTableRegionQuesTypeExcellent);

    }

}
