package com.example.pdfgenerator.controller;

import com.example.pdfgenerator.Dto.BasicReportParameters;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/logHandle")
public class SchoolReportGenUploadController {

    @Autowired
    private COSClient cosClient;

    JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();


    private static final  String  bucketName = "schoolreportpdf-1317275686";


    @PostMapping("/GeneratorBatchUrls")
    public ResponseEntity GeneratorBatchUrls(@RequestParam("examId")String examId) throws IOException, InterruptedException {
        String suffix  = examId.trim().replace("TDA","").replace("G3","").replace("G2","").trim();
        String sqlStatement = "select \n" +
                "school,exam_id,province,region\n" +
                "from \n" +
                "base_school_total_score_tda"+suffix+"  where subject_type = '常规'\n" +
                "group by school,exam_id,province,region";
        List<BasicReportParameters> parametersList = this.reportJdbcTemplate.query(sqlStatement,new Object[]{},new BeanPropertyRowMapper<>(BasicReportParameters.class));
        Runtime runtime  = Runtime.getRuntime();
        List<String> basicReportCommands  =  new ArrayList<>();
        List<String> files = new ArrayList<>();
        String reformCommand = "http://localhost:8080/pdf/basic?province=condition5&school=condition1&examId=condition4&region=改革&subjectType=常规";
        String unReformCommand = "http://localhost:8080/pdf/basic?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subjectType=常规";
        for (BasicReportParameters basicReportParameters : parametersList) {
            String command = "";
            String fileName = "";
            if(basicReportParameters.getRegion().equals("改革")){
                command = reformCommand.replace("condition1", basicReportParameters.getSchool()).replace("condition5", basicReportParameters.getProvince()).replace("condition3",basicReportParameters.getRegion()).replace("condition4", basicReportParameters.getExamId());
            }else{
                command = unReformCommand.replace("condition1", basicReportParameters.getSchool()).replace("condition5", basicReportParameters.getProvince()).replace("condition3",basicReportParameters.getRegion()).replace("condition4", basicReportParameters.getExamId());
            }
            basicReportCommands.add(command);
            files.add(fileName);
        }

        int i = 0;

        for (String command : basicReportCommands) {
            System.out.println("\""+command+"\""+",");
        }

        return ResponseEntity.ok("done");

    }

   @PostMapping("/BatchBasicPdfGenerator")
   public ResponseEntity batchPdfGenerator(@RequestParam("examId")String examId) throws IOException, InterruptedException {
      String suffix  = examId.trim().replace("TDA","").replace("G3","").replace("G2","").trim();
      String sqlStatement = "select \n" +
              "school,exam_id,province,region\n" +
              "from \n" +
              "base_school_total_score_tda"+suffix+"  where subject_type = '常规'\n" +
              "group by school,exam_id,province,region";
       List<BasicReportParameters> parametersList = this.reportJdbcTemplate.query(sqlStatement,new Object[]{},new BeanPropertyRowMapper<>(BasicReportParameters.class));
       Runtime runtime  = Runtime.getRuntime();
       List<String> basicReportCommands  =  new ArrayList<>();
       List<String> files = new ArrayList<>();
       String reformCommand = "node D:\\myWorkSpace\\puppeteer.js \"http://localhost:8080/pdf/basic?province=condition5&school=condition1&examId=condition4&region=conditionC&subjectType=常规\" pdf ";
       String unReformCommand = "node D:\\myWorkSpace\\puppeteer.js \"http://localhost:8080/pdf/basic?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subjectType=常规\" pdf ";
       for (BasicReportParameters basicReportParameters : parametersList) {
           String command = "";
           String fileName = "";
           if(basicReportParameters.getRegion().equals("改革")||basicReportParameters.getRegion().equals("改革A")){
               fileName = "PdfDir\\"+basicReportParameters.getRegion()+basicReportParameters.getProvince()+basicReportParameters.getSchool()+basicReportParameters.getExamId()+".pdf";
               command = reformCommand.replace("condition1", basicReportParameters.getSchool()).replace("condition5", basicReportParameters.getProvince()).replace("conditionC",basicReportParameters.getRegion()).replace("condition4", basicReportParameters.getExamId())
                       .concat(" ").concat("D:\\PdfDir\\"+basicReportParameters.getRegion()+basicReportParameters.getProvince()+basicReportParameters.getSchool()+basicReportParameters.getExamId()+".pdf");
           }else{
               fileName = "PdfDir\\"+basicReportParameters.getRegion()+basicReportParameters.getProvince()+basicReportParameters.getSchool()+basicReportParameters.getExamId()+".pdf";
               command = unReformCommand.replace("condition1", basicReportParameters.getSchool()).replace("condition5", basicReportParameters.getProvince()).replace("condition3",basicReportParameters.getRegion()).replace("condition4", basicReportParameters.getExamId())
                       .concat(" ").concat("D:\\PdfDir\\"+basicReportParameters.getRegion()+basicReportParameters.getProvince()+basicReportParameters.getSchool()+basicReportParameters.getExamId()+".pdf");;
           }
           basicReportCommands.add(command);
           files.add(fileName);
       }
       int i = 0;
       for (String command : basicReportCommands) {

           System.out.println("基础报告总共需生成:"+basicReportCommands.size());
           System.out.println("正在生成第"+(++i)+"报告");
           System.out.println("执行命令是:");
           System.out.println(command);
           runtime.exec(command);
           Thread.sleep(15000);
           //上传到cos当中去

           File file = new File("D:\\PdfDir");
           File[] files1 = file.listFiles();
           assert files1 != null;
           for (File file1 : files1) {
               PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, "PdfDir/"+file1.getName(), file1);
               try {
                   PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                   System.out.println(putObjectResult.getRequestId());
                   file1.delete();
               } catch (CosServiceException e) {
                   System.out.println("cos服务出现问题");
                   e.printStackTrace();
               } catch (CosClientException e) {
                   System.out.println("cos客户端出现问题出现问题的文件是"+files.get(i));
                   e.printStackTrace();
               }
           }
       }
      return ResponseEntity.ok("done");
   }

    @PostMapping("/BatchSubjectPdfGenerator")
    public ResponseEntity BatchSubjectPdfGenerator(@RequestParam(value = "examId",defaultValue = "TDA20240919G2")String examId) throws IOException, InterruptedException {
        String suffix  = examId.trim().replace("TDA","").replace("G3","").replace("G2","").trim();
        String sqlStatement = "select \n" +
                "school,exam_id,province,region,sub_subject\n" +
                "from \n" +
                "base_school_subject_tda"+suffix+" \n" +
                " where subject_type = '常规'\n"+
                "group by school,exam_id,province,region,sub_subject";
        List<BasicReportParameters> parametersList = this.reportJdbcTemplate.query(sqlStatement, new Object[]{}, new BeanPropertyRowMapper<>(BasicReportParameters.class));
        Runtime runtime = Runtime.getRuntime();
        List<String> basicReportCommands = new ArrayList<>();
        List<String> files = new ArrayList<>();
        String reformCommand = "node /myworkSpace/puppeteer2.js \"https://schoolreport.cssatest.com/pdf/subject?province=condition5&school=condition1&examId=condition4&region=conditionC&subSubject=condition6&subjectType=常规\" pdf";
        String unReformCommand = "node /myworkSpace/puppeteer2.js \"https://schoolreport.cssatest.com/pdf/subject?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subSubject=condition6&subjectType=常规\" pdf";

        for (BasicReportParameters basicReportParameters : parametersList) {
            String command = "";
            String fileName = "";
            if (basicReportParameters.getRegion().equals("改革")||basicReportParameters.getRegion().equals("改革A")) {
//                fileName = "PdfSubject\\" + basicReportParameters.getRegion() + basicReportParameters.getProvince() + basicReportParameters.getSchool() + basicReportParameters.getSubSubject() + basicReportParameters.getExamId() + ".pdf";
                fileName = "/myworkSpace/" + basicReportParameters.getRegion() + basicReportParameters.getProvince() + basicReportParameters.getSchool() + basicReportParameters.getSubSubject() + basicReportParameters.getExamId() + ".pdf";
                command = reformCommand.replace("condition1", basicReportParameters.getSchool()).replace("condition5", basicReportParameters.getProvince()).replace("conditionC", basicReportParameters.getRegion()).replace("condition4", basicReportParameters.getExamId()).replace("condition6", basicReportParameters.getSubSubject())
//                        .concat(" ").concat("D:\\PdfSubject\\" + basicReportParameters.getRegion() + basicReportParameters.getProvince() + basicReportParameters.getSchool() + basicReportParameters.getSubSubject() + basicReportParameters.getExamId() + ".pdf");
                        .concat(" ").concat("/myworkSpace/subject/" + basicReportParameters.getRegion() + basicReportParameters.getProvince() + basicReportParameters.getSchool() + basicReportParameters.getSubSubject() + basicReportParameters.getExamId() + ".pdf");
            } else {
                fileName = "/myworkSpace/" + basicReportParameters.getRegion() + basicReportParameters.getProvince() + basicReportParameters.getSchool() + basicReportParameters.getSubSubject() + basicReportParameters.getExamId() + ".pdf";
                command = unReformCommand.replace("condition1", basicReportParameters.getSchool()).replace("condition5", basicReportParameters.getProvince()).replace("condition3", basicReportParameters.getRegion()).replace("condition4", basicReportParameters.getExamId()).replace("condition6", basicReportParameters.getSubSubject())
                        .concat(" ").concat("/myworkSpace/subject/" + basicReportParameters.getRegion() + basicReportParameters.getProvince() + basicReportParameters.getSchool() + basicReportParameters.getSubSubject() + basicReportParameters.getExamId() + ".pdf");
                ;
            }
            basicReportCommands.add(command);
            files.add(fileName);
        }

        int i = 0;
        for (String basicReportCommand : basicReportCommands) {
            try {
            System.err.println("学科报告总共需生成:" + basicReportCommands.size());
            System.err.println("正在生成第" + (++i) + "报告");
            System.err.println("执行命令是:");
            System.err.println(basicReportCommand);
                // 使用 ProcessBuilder 创建进程
                ProcessBuilder processBuilder = new ProcessBuilder();
                processBuilder.command("bash", "-c", basicReportCommand);
                processBuilder.redirectErrorStream(true); // 合并标准输出和错误输出

                // 启动进程
                Process process = processBuilder.start();

                // 获取输出流并读取命令输出
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }

                // 等待进程结束并获取退出值
                int exitCode = process.waitFor();
                System.out.println("\nExited with error code : " + exitCode);

            } catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
        //偶有出现 遗留两个文件的情况
//        for (String command : basicReportCommands) {
//            Thread.sleep(6000);
//            System.err.println("学科报告总共需生成:" + basicReportCommands.size());
//            System.err.println("正在生成第" + (++i) + "报告");
//            System.err.println("执行命令是:");
//            System.err.println(command);
//            runtime.exec(command);
//            执行完 上传文件 cos
//            File file = new File("D:\\PdfSubject");
//            File[] files1 = file.listFiles();
//            assert files1 != null;
//            for (File file1 : files1) {
//                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, "PdfSubject/" + file1.getName(), file1);
//                try {
//                    PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
//                    System.out.println(putObjectResult.getRequestId());
//                    file1.delete();
//                } catch (CosServiceException e) {
//                    System.out.println("cos服务出现问题");
//                    e.printStackTrace();
//                } catch (CosClientException e) {
//                    System.out.println("cos客户端出现问题出现问题的文件是" + files.get(i));
//                    e.printStackTrace();
//                }
//            }
//        }

        return ResponseEntity.ok("done");
    }

}
