package com.example.pdfgenerator.DataProcessing;


import com.example.pdfgenerator.Dto.TaskPoolDto;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

@SpringBootTest
public class GenerateTaskPool {

    @Test
    public void GenerateTaskPoolUnit(){

        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();

        String sql = "SELECT\n" +
                "\texam_id,\n" +
                "\tregion1 as region,\n" +
                "\tprovince,\n" +
                "\tschool,\n" +
                "\t0 as status\n" +
                "FROM\n" +
                "\tbase_school_subject_tda20250918 \n" +
                "GROUP BY\n" +
                "\tregion1,\n" +
                "\tprovince,\n" +
                "\tschool,\n" +
                "\texam_id";

        List<TaskPoolDto>  taskPoolDtoList =  reportJdbcTemplate.query(sql,new Object[]{},new BeanPropertyRowMapper<>(TaskPoolDto.class));

        batchInsert(taskPoolDtoList,reportJdbcTemplate);

        System.out.println("生成任务已经结束");

    }


    public void batchInsert(List<TaskPoolDto> taskPoolDtoList,JdbcTemplate reportJdbcTemplate){
        String sql = "insert into school_report_task_generate (exam_id,region,province,school,status) values (?,?,?,?,?)";
        reportJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {
            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                TaskPoolDto taskPoolDto = taskPoolDtoList.get(i);
                ps.setString(1,taskPoolDto.getExamId());
                ps.setString(2,taskPoolDto.getRegion());
                ps.setString(3,taskPoolDto.getProvince());
                ps.setString(4,taskPoolDto.getSchool());
                ps.setInt(5,taskPoolDto.getStatus());
            }

            @Override
            public int getBatchSize() {
                return taskPoolDtoList.size();
            }
        });
    }

}
