package com.example.pdfgenerator.DataProcessing;

import com.example.pdfgenerator.DeFenLu;
import com.example.pdfgenerator.Dto.*;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@SpringBootTest
class PdfGeneratorApplicationTests {

    @Test
    void contextLoads() {

    }

    @Test
    public void TestInsertSchoolClass(){

        JdbcTemplate reportJdbcTemplate =  MyDataSourceConfig.getReportJdbcTemplate();

        String sql = "SELECT\n" +
                "\tregion1 as region,\n" +
                "\tschool,\n" +
                "\tclass as className\n" +
                "FROM\n" +
                "\tbase_class_subject_tda20251023 \n" +
                "WHERE\n" +
                "\tsubject_type = '常规' \n" +
                "GROUP BY\n" +
                "\tschool,\n" +
                "\tregion1,\n" +
                "\tclass\n" +
                "order by region1,school,class";

        List<ClassDtoArgs> paramsList = reportJdbcTemplate.query(sql,new Object[]{},new BeanPropertyRowMapper<>(ClassDtoArgs.class));

        for(ClassDtoArgs param : paramsList){
            System.out.println("运行"+param.getSchool()+param.getClassName()+"难度解析");
            TestInsertClassName(param.getSchool(), param.getRegion(), param.getClassName(), reportJdbcTemplate);
        }
    }

    public void TestInsertClassName(String school,String region,String className,JdbcTemplate jdbcTemplate){
        //学校的
        String sql = "SELECT\n" +
                "\ta.region1 as region, \n" +
                "\ta.sub_subject,\n" +
                "\ta.subject_type,\n" +
                "\ta.exam_id,\n" +
                "\ta.ques_no,\n" +
                "\ta.region_ques_standard_difficulty,\n" +
                "\tb.stu_ques_score,\n" +
                "\tb.`ques_max_score`,b.stu_ques_score\n" +
                "\tFROM\n" +
                "\tbase_area_question_tda20251023 a\n" +
                "\tleft join base_student_question_tda20251023 b  on a.ques_no = b.ques_no and a.sub_subject = b.`sub_subject`\n" +"and a.region1 = b.region1 "+
                "\twhere b.school = '"+school+"' and b.subject_type = '常规' and a.region1 = '"+region+"'"+"and class = '"+className+"'";

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        List<DeFenLu> list = namedParameterJdbcTemplate.query(sql, new BeanPropertyRowMapper<>(DeFenLu.class));

        //化学 --》list  物理 ----》list
        Map<String, List<DeFenLu>> collect = list.stream().collect(Collectors.groupingBy(DeFenLu::getSubSubject));



        //学科粒度
        for (String subject : collect.keySet()) {

            System.out.println("处理"+subject+"学科");
            List<DeFenLu> deFenLus = collect.get(subject);

            List<DeFenLu> yi = new ArrayList<>();
            List<DeFenLu> jiaoyi = new ArrayList<>();
            List<DeFenLu> zhong = new ArrayList<>();
            List<DeFenLu> jiaonan = new ArrayList<>();
            List<DeFenLu> nan = new ArrayList<>();

            //单个科目答题记录：记录体型难度情况
            for (DeFenLu fenLus : deFenLus) {
                if(fenLus.getRegionQuesStandardDifficulty()>=0&&fenLus.getRegionQuesStandardDifficulty()<5){
                    yi.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=5&&fenLus.getRegionQuesStandardDifficulty()<10){
                    jiaoyi.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=10&&fenLus.getRegionQuesStandardDifficulty()<15){
                    zhong.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=15&&fenLus.getRegionQuesStandardDifficulty()<20){
                    jiaonan.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=20&&fenLus.getRegionQuesStandardDifficulty()<=25){
                    nan.add(fenLus);
                }
            }
            //处理难易程度的得分率
            double yiStuSum = yi.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double yiSum = yi.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double jiaoyiStuSum = jiaoyi.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double jiaoyiyiSum = jiaoyi.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double zhongStuSum = zhong.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double zhongSum = zhong.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double jiaonanStuSum = jiaonan.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double jiaonanSum = jiaonan.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double nanStuSum = nan.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double nanSum = nan.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

//            System.out.println(yiStuSum/yiSum);
            double yiResult = (Double.isNaN(yiStuSum/yiSum)||Double.isInfinite(yiStuSum/yiSum))?0.0:(yiStuSum/yiSum);
//            System.out.println(jiaoyiStuSum/jiaoyiyiSum);
            double jiaoyiResult = (Double.isNaN(jiaoyiStuSum/jiaoyiyiSum)||Double.isInfinite(jiaoyiStuSum/jiaoyiyiSum))?0.0:(jiaoyiStuSum/jiaoyiyiSum);
//            System.out.println(zhongStuSum/zhongSum);
            double zhongResult = (Double.isNaN(zhongStuSum/zhongSum)||Double.isInfinite(zhongStuSum/zhongSum))?0.0:(zhongStuSum/zhongSum);
//            System.out.println(jiaonanStuSum/jiaonanSum);
            double jiaonanResult = (Double.isNaN(jiaonanStuSum/jiaonanSum)||Double.isInfinite(jiaonanStuSum/jiaonanSum))?0.0:(jiaonanStuSum/jiaonanSum);
//            System.out.println(nanStuSum/nanSum);
            double nanResult = (Double.isNaN(nanStuSum/nanSum)||Double.isInfinite(nanStuSum/nanSum))?0.0:(nanStuSum/nanSum);
            HashMap paramsYi = new HashMap(){{
                put("class",className);
                put("school",school);
                put("subSubject",subject);
                put("difficult","易");
                put("region",region);
                put("scoreMean", yiResult);
            }};
            HashMap paramsJiaoYi = new HashMap(){{
                put("class",className);
                put("school",school);
                put("subSubject",subject);
                put("difficult","较易");
                put("region",region);
                put("scoreMean", jiaoyiResult);
            }};
            HashMap paramsZhong = new HashMap(){{
                put("class",className);
                put("school",school);
                put("subSubject",subject);
                put("difficult","中");
                put("region",region);
                put("scoreMean", zhongResult);
            }};
            HashMap paramsJiaoNan = new HashMap(){{
                put("class",className);
                put("school",school);
                put("subSubject",subject);
                put("difficult","较难");
                put("region",region);
                put("scoreMean", jiaonanResult);
            }};
            HashMap paramsNan= new HashMap(){{
                put("class",className);
                put("school",school);
                put("subSubject",subject);
                put("difficult","难");
                put("region",region);
                put("scoreMean", nanResult);
            }};
            namedParameterJdbcTemplate.update("insert into class_diffficult20251023(class,school,sub_subject,difficult,region,score_mean) value(:class,:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsYi));
            namedParameterJdbcTemplate.update("insert into class_diffficult20251023(class,school,sub_subject,difficult,region,score_mean) value(:class,:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsJiaoYi));
            namedParameterJdbcTemplate.update("insert into class_diffficult20251023(class,school,sub_subject,difficult,region,score_mean) value(:class,:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsZhong));
            namedParameterJdbcTemplate.update("insert into class_diffficult20251023(class,school,sub_subject,difficult,region,score_mean) value(:class,:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsJiaoNan));
            namedParameterJdbcTemplate.update("insert into class_diffficult20251023(class,school,sub_subject,difficult,region,score_mean) value(:class,:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsNan));
        }
    }

    // school_diffficult
    @Test
    public void  TestInsertSchool(){

        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();

        String sql = "select school,region1 as  region from base_school_subject_tda20251023 where subject_type = '常规' group by school,region1";

        List<Dto> listParams = reportJdbcTemplate.query(sql,new Object[]{},new BeanPropertyRowMapper<>(Dto.class));

        for (Dto listParam : listParams) {
            System.out.println("运行"+listParam.getSchool()+listParam.getRegion());
            test(listParam.getSchool(), listParam.getRegion(),reportJdbcTemplate);
        }

    }

    public void test(String school,String region,JdbcTemplate jdbcTemplate) {

        //学校的
        String sql = "SELECT\n" +
                "\ta.region1 as region,\n" +
                "\ta.sub_subject,\n" +
                "\ta.subject_type,\n" +
                "\ta.exam_id,\n" +
                "\ta.ques_no,\n" +
                "\ta.region_ques_standard_difficulty,\n" +
                "\tb.stu_ques_score,\n" +
                "\tb.`ques_max_score`\n" +
                "\tFROM\n" +
                "\tbase_area_question_tda20251023 a\n" +
                "\tleft join base_student_question_tda20251023 b  on a.ques_no = b.ques_no and a.sub_subject = b.`sub_subject`\n" +"and a.region1 = b.region1 "+
                "\twhere b.school = '"+school+"' and b.subject_type = '常规' and a.region1 = '"+region+"'";

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        List<DeFenLu> list = namedParameterJdbcTemplate.query(sql, new BeanPropertyRowMapper<>(DeFenLu.class));

        //化学 --》list  物理 ----》list
        Map<String, List<DeFenLu>> collect = list.stream().collect(Collectors.groupingBy(DeFenLu::getSubSubject));

        //学科粒度
        for (String subject : collect.keySet()) {

            System.out.println("处理"+subject+"学科");

            List<DeFenLu> deFenLus = collect.get(subject);

            List<DeFenLu> yi       = new ArrayList<>();

            List<DeFenLu> jiaoyi   = new ArrayList<>();

            List<DeFenLu> zhong    = new ArrayList<>();

            List<DeFenLu> jiaonan  = new ArrayList<>();

            List<DeFenLu> nan      = new ArrayList<>();

            //单个科目答题记录：记录体型难度情况
            for (DeFenLu fenLus : deFenLus) {

                if(fenLus.getRegionQuesStandardDifficulty()>=0&&fenLus.getRegionQuesStandardDifficulty()<5){

                    yi.add(fenLus);

                }else if(fenLus.getRegionQuesStandardDifficulty()>=5&&fenLus.getRegionQuesStandardDifficulty()<10){

                    jiaoyi.add(fenLus);

                }else if(fenLus.getRegionQuesStandardDifficulty()>=10&&fenLus.getRegionQuesStandardDifficulty()<15){

                    zhong.add(fenLus);

                }else if(fenLus.getRegionQuesStandardDifficulty()>=15&&fenLus.getRegionQuesStandardDifficulty()<20){

                    jiaonan.add(fenLus);

                }else if(fenLus.getRegionQuesStandardDifficulty()>=20&&fenLus.getRegionQuesStandardDifficulty()<=25){

                    nan.add(fenLus);

                }

            }

            //处理难易程度的得分率
            double yiStuSum = yi.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double yiSum = yi.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double jiaoyiStuSum = jiaoyi.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double jiaoyiyiSum = jiaoyi.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double zhongStuSum = zhong.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double zhongSum = zhong.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double jiaonanStuSum = jiaonan.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double jiaonanSum = jiaonan.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double nanStuSum = nan.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double nanSum = nan.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

//            System.out.println(yiStuSum/yiSum);
            double yiResult = (Double.isNaN(yiStuSum/yiSum)||Double.isInfinite(yiStuSum/yiSum))?0.0:(yiStuSum/yiSum);
//            System.out.println(jiaoyiStuSum/jiaoyiyiSum);
            double jiaoyiResult = (Double.isNaN(jiaoyiStuSum/jiaoyiyiSum)||Double.isInfinite(jiaoyiStuSum/jiaoyiyiSum))?0.0:(jiaoyiStuSum/jiaoyiyiSum);
//            System.out.println(zhongStuSum/zhongSum);
            double zhongResult = (Double.isNaN(zhongStuSum/zhongSum)||Double.isInfinite(zhongStuSum/zhongSum))?0.0:(zhongStuSum/zhongSum);
//            System.out.println(jiaonanStuSum/jiaonanSum);
            double jiaonanResult = (Double.isNaN(jiaonanStuSum/jiaonanSum)||Double.isInfinite(jiaonanStuSum/jiaonanSum))?0.0:(jiaonanStuSum/jiaonanSum);
//            System.out.println(nanStuSum/nanSum);
            double nanResult = (Double.isNaN(nanStuSum/nanSum)||Double.isInfinite(nanStuSum/nanSum))?0.0:(nanStuSum/nanSum);

            HashMap paramsYi = new HashMap(){{
                put("school",school);
                put("subSubject",subject);
                put("difficult","易");
                put("region",region);
                put("scoreMean", yiResult);
            }};

            HashMap paramsJiaoYi = new HashMap(){{
                put("school",school);
                put("subSubject",subject);
                put("difficult","较易");
                put("region",region);
                put("scoreMean", jiaoyiResult);
            }};

            HashMap paramsZhong = new HashMap(){{
                put("school",school);
                put("subSubject",subject);
                put("difficult","中");
                put("region",region);
                put("scoreMean", zhongResult);
            }};

            HashMap paramsJiaoNan = new HashMap(){{
                put("school",school);
                put("subSubject",subject);
                put("difficult","较难");
                put("region",region);
                put("scoreMean", jiaonanResult);
            }};

            HashMap paramsNan= new HashMap(){{
                put("school",school);
                put("subSubject",subject);
                put("difficult","难");
                put("region",region);
                put("scoreMean", nanResult);
            }};

            namedParameterJdbcTemplate.update("insert into school_diffficult20251023(school,sub_subject,difficult,region,score_mean) value(:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsYi));
            namedParameterJdbcTemplate.update("insert into school_diffficult20251023(school,sub_subject,difficult,region,score_mean) value(:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsJiaoYi));
            namedParameterJdbcTemplate.update("insert into school_diffficult20251023(school,sub_subject,difficult,region,score_mean) value(:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsZhong));
            namedParameterJdbcTemplate.update("insert into school_diffficult20251023(school,sub_subject,difficult,region,score_mean) value(:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsJiaoNan));
            namedParameterJdbcTemplate.update("insert into school_diffficult20251023(school,sub_subject,difficult,region,score_mean) value(:school,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsNan));
        }
//        DeFenLu deFenLu = yi.get(0);
    }



    // region
    @Test
    public void TestInsertRegion(){
        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();

        String sql = "select region1 from base_school_subject_tda20251023 where subject_type = '常规' group by region1";

        List<String> listParams = reportJdbcTemplate.queryForList(sql,String.class);

        for (String region : listParams) {
            System.out.println("运行"+region);
            TestRegion(region,reportJdbcTemplate);
        }

    }

    public void TestRegion(String region,JdbcTemplate jdbcTemplate){


        String sql = "SELECT\n" +
                "\ta.region1,\n" +
                "\ta.sub_subject,\n" +
                "\ta.subject_type,\n" +
                "\ta.exam_id,\n" +
                "\ta.ques_no,\n" +
                "\ta.region_ques_standard_difficulty,\n" +
                "\tb.stu_ques_score,\n" +
                "\tb.`ques_max_score`\n" +
                "\tFROM\n" +
                "\tbase_area_question_tda20251023 a\n" +
                "\tleft join base_student_question_tda20251023 b  on a.ques_no = b.ques_no and a.sub_subject = b.`sub_subject` and a.region1 = b.region1 and a.subject_type = b.subject_type\n" +
                "\twhere  a.subject_type = '常规' and a.region1 = '"+region+"'\n";

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        List<DeFenLu> list = namedParameterJdbcTemplate.query(sql, new BeanPropertyRowMapper<>(DeFenLu.class));

        //化学 --》list  物理 ----》list
        Map<String, List<DeFenLu>> collect = list.stream().collect(Collectors.groupingBy(DeFenLu::getSubSubject));




        //学科粒度
        for (String subject : collect.keySet()) {

            System.out.println("处理"+subject+"学科");
            List<DeFenLu> deFenLus = collect.get(subject);

            List<DeFenLu> yi = new ArrayList<>();
            List<DeFenLu> jiaoyi = new ArrayList<>();
            List<DeFenLu> zhong = new ArrayList<>();
            List<DeFenLu> jiaonan = new ArrayList<>();
            List<DeFenLu> nan = new ArrayList<>();

            //单个科目答题记录：记录体型难度情况
            for (DeFenLu fenLus : deFenLus) {
                if(fenLus.getRegionQuesStandardDifficulty()>=0&&fenLus.getRegionQuesStandardDifficulty()<5){
                    yi.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=5&&fenLus.getRegionQuesStandardDifficulty()<10){
                    jiaoyi.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=10&&fenLus.getRegionQuesStandardDifficulty()<15){
                    zhong.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=15&&fenLus.getRegionQuesStandardDifficulty()<20){
                    jiaonan.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=20&&fenLus.getRegionQuesStandardDifficulty()<=25){
                    nan.add(fenLus);
                }
            }
            //处理难易程度的得分率
            double yiStuSum = yi.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double yiSum = yi.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double jiaoyiStuSum = jiaoyi.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double jiaoyiyiSum = jiaoyi.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double zhongStuSum = zhong.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double zhongSum = zhong.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double jiaonanStuSum = jiaonan.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double jiaonanSum = jiaonan.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double nanStuSum = nan.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double nanSum = nan.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            System.out.println(yiStuSum/yiSum);
            double yiResult = (Double.isNaN(yiStuSum/yiSum)||Double.isInfinite(yiStuSum/yiSum))?0.0:(yiStuSum/yiSum);
            System.out.println(jiaoyiStuSum/jiaoyiyiSum);
            double jiaoyiResult = (Double.isNaN(jiaoyiStuSum/jiaoyiyiSum)||Double.isInfinite(jiaoyiStuSum/jiaoyiyiSum))?0.0:(jiaoyiStuSum/jiaoyiyiSum);
            System.out.println(zhongStuSum/zhongSum);
            double zhongResult = (Double.isNaN(zhongStuSum/zhongSum)||Double.isInfinite(zhongStuSum/zhongSum))?0.0:(zhongStuSum/zhongSum);
            System.out.println(jiaonanStuSum/jiaonanSum);
            double jiaonanResult = (Double.isNaN(jiaonanStuSum/jiaonanSum)||Double.isInfinite(jiaonanStuSum/jiaonanSum))?0.0:(jiaonanStuSum/jiaonanSum);
            System.out.println(nanStuSum/nanSum);
            double nanResult = (Double.isNaN(nanStuSum/nanSum)||Double.isInfinite(nanStuSum/nanSum))?0.0:(nanStuSum/nanSum);
            HashMap paramsYi = new HashMap(){{
                put("subSubject",subject);
                put("difficult","易");
                put("region",region);
                put("scoreMean", yiResult);
            }};
            HashMap paramsJiaoYi = new HashMap(){{
                put("subSubject",subject);
                put("difficult","较易");
                put("region",region);
                put("scoreMean", jiaoyiResult);
            }};
            HashMap paramsZhong = new HashMap(){{
                put("subSubject",subject);
                put("difficult","中");
                put("region",region);
                put("scoreMean", zhongResult);
            }};
            HashMap paramsJiaoNan = new HashMap(){{
                put("subSubject",subject);
                put("difficult","较难");
                put("region",region);
                put("scoreMean", jiaonanResult);
            }};
            HashMap paramsNan= new HashMap(){{
                put("subSubject",subject);
                put("difficult","难");
                put("region",region);
                put("scoreMean", nanResult);
            }};

            namedParameterJdbcTemplate.update("insert into region_difficult20251023(sub_subject,difficult,region,score_mean) value(:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsYi));
            namedParameterJdbcTemplate.update("insert into region_difficult20251023(sub_subject,difficult,region,score_mean) value(:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsJiaoYi));
            namedParameterJdbcTemplate.update("insert into region_difficult20251023(sub_subject,difficult,region,score_mean) value(:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsZhong));
            namedParameterJdbcTemplate.update("insert into region_difficult20251023(sub_subject,difficult,region,score_mean) value(:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsJiaoNan));
            namedParameterJdbcTemplate.update("insert into region_difficult20251023(sub_subject,difficult,region,score_mean) value(:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsNan));

        }

    }


    // province
    @Test
    public void TestProvinceInsert(){

        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();

        String sql = "select region1 as region ,province from base_school_subject_tda20251023_mix where subject_type = '常规' group by region1,province";

        List<Params>  paramsList = reportJdbcTemplate.query(sql,new Object[]{},new BeanPropertyRowMapper<>(Params.class));

        for (Params param : paramsList) {
            System.out.println("运行"+param.getProvince()+param.getRegion());
            TestProvince(param.getProvince(),param.getRegion(),reportJdbcTemplate);
        }

//        TestProvince("江西省","改革",reportJdbcTemplate);

    }




    public void TestProvince(String province,String region,JdbcTemplate jdbcTemplate){

        String sql  =  "SELECT\n" +
                "\ta.region1 as region,\n" +
                "\ta.sub_subject,\n" +
                "\ta.subject_type,\n" +
                "\ta.exam_id,\n" +
                "\ta.ques_no,\n" +
                "\ta.region_ques_standard_difficulty,\n" +
                "\tb.stu_ques_score,\n" +
                "\tb.`ques_max_score`\n" +
                "\tFROM\n" +
                "\tbase_area_question_tda20251023_mix a\n" +
                "\tleft join base_student_question_tda20251023_mix b  on a.ques_no = b.ques_no and a.sub_subject = b.`sub_subject` and a.region1 = b.region1 and a.subject_type = b.subject_type\n" +
                "\twhere a.subject_type = '常规' and a.region1 = '"+region+"' and b.province = '"+province+"'";

        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        List<DeFenLu> list = namedParameterJdbcTemplate.query(sql, new BeanPropertyRowMapper<>(DeFenLu.class));

        //化学 --》list  物理 ----》list
        Map<String, List<DeFenLu>> collect = list.stream().collect(Collectors.groupingBy(DeFenLu::getSubSubject));

        //学科粒度
        for (String subject : collect.keySet()) {

            System.out.println("处理"+subject+"学科");
            List<DeFenLu> deFenLus = collect.get(subject);

            List<DeFenLu> yi = new ArrayList<>();
            List<DeFenLu> jiaoyi = new ArrayList<>();
            List<DeFenLu> zhong = new ArrayList<>();
            List<DeFenLu> jiaonan = new ArrayList<>();
            List<DeFenLu> nan = new ArrayList<>();

            //单个科目答题记录：记录体型难度情况
            for (DeFenLu fenLus : deFenLus) {
                if(fenLus.getRegionQuesStandardDifficulty()>=0&&fenLus.getRegionQuesStandardDifficulty()<5){
                    yi.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=5&&fenLus.getRegionQuesStandardDifficulty()<10){
                    jiaoyi.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=10&&fenLus.getRegionQuesStandardDifficulty()<15){
                    zhong.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=15&&fenLus.getRegionQuesStandardDifficulty()<20){
                    jiaonan.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=20&&fenLus.getRegionQuesStandardDifficulty()<=25){
                    nan.add(fenLus);
                }
            }
            //处理难易程度的得分率
            double yiStuSum = yi.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double yiSum = yi.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double jiaoyiStuSum = jiaoyi.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double jiaoyiyiSum = jiaoyi.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double zhongStuSum = zhong.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double zhongSum = zhong.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double jiaonanStuSum = jiaonan.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double jiaonanSum = jiaonan.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double nanStuSum = nan.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double nanSum = nan.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            System.out.println(yiStuSum/yiSum);
            double yiResult = (Double.isNaN(yiStuSum/yiSum)||Double.isInfinite(yiStuSum/yiSum))?0.0:(yiStuSum/yiSum);
            System.out.println(jiaoyiStuSum/jiaoyiyiSum);
            double jiaoyiResult = (Double.isNaN(jiaoyiStuSum/jiaoyiyiSum)||Double.isInfinite(jiaoyiStuSum/jiaoyiyiSum))?0.0:(jiaoyiStuSum/jiaoyiyiSum);
            System.out.println(zhongStuSum/zhongSum);
            double zhongResult = (Double.isNaN(zhongStuSum/zhongSum)||Double.isInfinite(zhongStuSum/zhongSum))?0.0:(zhongStuSum/zhongSum);
            System.out.println(jiaonanStuSum/jiaonanSum);
            double jiaonanResult = (Double.isNaN(jiaonanStuSum/jiaonanSum)||Double.isInfinite(jiaonanStuSum/jiaonanSum))?0.0:(jiaonanStuSum/jiaonanSum);
            System.out.println(nanStuSum/nanSum);
            double nanResult = (Double.isNaN(nanStuSum/nanSum)||Double.isInfinite(nanStuSum/nanSum))?0.0:(nanStuSum/nanSum);
            HashMap paramsYi = new HashMap(){{
                put("province",province);
                put("subSubject",subject);
                put("difficult","易");
                put("region",region);
                put("scoreMean", yiResult);
            }};
            HashMap paramsJiaoYi = new HashMap(){{
                put("province",province);
                put("subSubject",subject);
                put("difficult","较易");
                put("region",region);
                put("scoreMean", jiaoyiResult);
            }};
            HashMap paramsZhong = new HashMap(){{
                put("province",province);
                put("subSubject",subject);
                put("difficult","中");
                put("region",region);
                put("scoreMean", zhongResult);
            }};
            HashMap paramsJiaoNan = new HashMap(){{
                put("province",province);
                put("subSubject",subject);
                put("difficult","较难");
                put("region",region);
                put("scoreMean", jiaonanResult);
            }};
            HashMap paramsNan= new HashMap(){{
                put("province",province);
                put("subSubject",subject);
                put("difficult","难");
                put("region",region);
                put("scoreMean", nanResult);
            }};
            namedParameterJdbcTemplate.update("insert into province_difficult20251023(province,sub_subject,difficult,region,score_mean) value(:province,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsYi));
            namedParameterJdbcTemplate.update("insert into province_difficult20251023(province,sub_subject,difficult,region,score_mean) value(:province,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsJiaoYi));
            namedParameterJdbcTemplate.update("insert into province_difficult20251023(province,sub_subject,difficult,region,score_mean) value(:province,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsZhong));
            namedParameterJdbcTemplate.update("insert into province_difficult20251023(province,sub_subject,difficult,region,score_mean) value(:province,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsJiaoNan));
            namedParameterJdbcTemplate.update("insert into province_difficult20251023(province,sub_subject,difficult,region,score_mean) value(:province,:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsNan));

        }

    }



    // region_excellent
    @Test
    public void excellentRegion(){

        JdbcTemplate jdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();

        String sql = "select region1  from base_school_subject_tda20251023 where subject_type ='常规' group by region1";

        List<String> regions = jdbcTemplate.queryForList(sql,new Object[]{},String.class);
        for (String region : regions) {
            testExcellent(region,jdbcTemplate);
        }


    }

    public void testExcellent(String region,JdbcTemplate  jdbcTemplate){

        String sql = "SELECT\n" +
                "                a.region1,\n" +
                "                a.sub_subject,\n" +
                "                a.subject_type,\n" +
                "                a.exam_id,\n" +
                "                a.ques_no,\n" +
                "                a.region_ques_standard_difficulty,\n" +
                "                b.stu_ques_score,\n" +
                "                b.`ques_max_score`,\n" +
                "                b.`stu_id`\n" +
                "                FROM\n" +
                "                base_area_question_tda20251023 a\n" +
                "                left join base_student_question_tda20251023 b  on a.ques_no = b.ques_no and a.sub_subject = b.`sub_subject` and a.region1 = b.region1 and a.subject_type = b.subject_type\n" +
                "                where  a.subject_type = '常规' and a.region1 = '"+region+"'";


        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        List<DeFenLu> list = namedParameterJdbcTemplate.query(sql, new BeanPropertyRowMapper<>(DeFenLu.class));

        //化学 --》list  物理 ----》list
        Map<String, List<DeFenLu>> collect = list.stream().collect(Collectors.groupingBy(DeFenLu::getSubSubject));




        //学科粒度
        for (String subject : collect.keySet()) {


            //这个级别开始晒数据

            String sql2  = "select stu_id from base_student_subject_tda20251023 where sub_subject = '"+subject+"' and region1 = '"+region+"' and stu_subject_score_rate_region_pct_rank >= 0.73 and subject_type = '常规'";

            List<String> excellent =  namedParameterJdbcTemplate.queryForList(sql2,new HashMap<>(),String.class);

            System.out.println("处理"+subject+"学科");
            List<DeFenLu> deFenLus = collect.get(subject);

            deFenLus = deFenLus.stream().filter(x->excellent.contains(x.getStuId())).collect(Collectors.toList());

            List<DeFenLu> yi = new ArrayList<>();
            List<DeFenLu> jiaoyi = new ArrayList<>();
            List<DeFenLu> zhong = new ArrayList<>();
            List<DeFenLu> jiaonan = new ArrayList<>();
            List<DeFenLu> nan = new ArrayList<>();

            //单个科目答题记录：记录体型难度情况
            for (DeFenLu fenLus : deFenLus) {
                if(fenLus.getRegionQuesStandardDifficulty()>=0&&fenLus.getRegionQuesStandardDifficulty()<5){
                    yi.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=5&&fenLus.getRegionQuesStandardDifficulty()<10){
                    jiaoyi.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=10&&fenLus.getRegionQuesStandardDifficulty()<15){
                    zhong.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=15&&fenLus.getRegionQuesStandardDifficulty()<20){
                    jiaonan.add(fenLus);
                }else if(fenLus.getRegionQuesStandardDifficulty()>=20&&fenLus.getRegionQuesStandardDifficulty()<=25){
                    nan.add(fenLus);
                }
            }
            //处理难易程度的得分率
            double yiStuSum = yi.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double yiSum = yi.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double jiaoyiStuSum = jiaoyi.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double jiaoyiyiSum = jiaoyi.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double zhongStuSum = zhong.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double zhongSum = zhong.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double jiaonanStuSum = jiaonan.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double jiaonanSum = jiaonan.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            double nanStuSum = nan.stream().mapToDouble(DeFenLu::getStuQuesScore).sum();
            double nanSum = nan.stream().mapToDouble(DeFenLu::getQuesMaxScore).sum();

            System.out.println(yiStuSum/yiSum);
            double yiResult = (Double.isNaN(yiStuSum/yiSum)||Double.isInfinite(yiStuSum/yiSum))?0.0:(yiStuSum/yiSum);
            System.out.println(jiaoyiStuSum/jiaoyiyiSum);
            double jiaoyiResult = (Double.isNaN(jiaoyiStuSum/jiaoyiyiSum)||Double.isInfinite(jiaoyiStuSum/jiaoyiyiSum))?0.0:(jiaoyiStuSum/jiaoyiyiSum);
            System.out.println(zhongStuSum/zhongSum);
            double zhongResult = (Double.isNaN(zhongStuSum/zhongSum)||Double.isInfinite(zhongStuSum/zhongSum))?0.0:(zhongStuSum/zhongSum);
            System.out.println(jiaonanStuSum/jiaonanSum);
            double jiaonanResult = (Double.isNaN(jiaonanStuSum/jiaonanSum)||Double.isInfinite(jiaonanStuSum/jiaonanSum))?0.0:(jiaonanStuSum/jiaonanSum);
            System.out.println(nanStuSum/nanSum);
            double nanResult = (Double.isNaN(nanStuSum/nanSum)||Double.isInfinite(nanStuSum/nanSum))?0.0:(nanStuSum/nanSum);
            HashMap paramsYi = new HashMap(){{
                put("subSubject",subject);
                put("difficult","易");
                put("region",region);
                put("scoreMean", yiResult);
            }};
            HashMap paramsJiaoYi = new HashMap(){{
                put("subSubject",subject);
                put("difficult","较易");
                put("region",region);
                put("scoreMean", jiaoyiResult);
            }};
            HashMap paramsZhong = new HashMap(){{
                put("subSubject",subject);
                put("difficult","中");
                put("region",region);
                put("scoreMean", zhongResult);
            }};
            HashMap paramsJiaoNan = new HashMap(){{
                put("subSubject",subject);
                put("difficult","较难");
                put("region",region);
                put("scoreMean", jiaonanResult);
            }};
            HashMap paramsNan= new HashMap(){{
                put("subSubject",subject);
                put("difficult","难");
                put("region",region);
                put("scoreMean", nanResult);
            }};

            namedParameterJdbcTemplate.update("insert into region_excellent_difficult20251023(sub_subject,difficult,region,score_mean) value(:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsYi));
            namedParameterJdbcTemplate.update("insert into region_excellent_difficult20251023(sub_subject,difficult,region,score_mean) value(:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsJiaoYi));
            namedParameterJdbcTemplate.update("insert into region_excellent_difficult20251023(sub_subject,difficult,region,score_mean) value(:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsZhong));
            namedParameterJdbcTemplate.update("insert into region_excellent_difficult20251023(sub_subject,difficult,region,score_mean) value(:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsJiaoNan));
            namedParameterJdbcTemplate.update("insert into region_excellent_difficult20251023(sub_subject,difficult,region,score_mean) value(:subSubject,:difficult,:region,:scoreMean)",new MapSqlParameterSource(paramsNan));

        }

    }
    // province_excellent_asw_time
    @Test
    public void ExcellentAswTimeProvince(){

        String sql  = "select region1 as region,province from base_province_subject_tda20251023_mix where subject_type = '常规' group by region1,province";
        JdbcTemplate jdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();
        List<Params> params  = jdbcTemplate.query(sql,new Object[]{},new BeanPropertyRowMapper<>(Params.class));
        for (Params param : params) {
            ExcellentAswTime(param.getProvince(),param.getRegion(),jdbcTemplate);
        }

    }


    public void ExcellentAswTime(String province,String region,JdbcTemplate jdbcTemplate){

        String sql = "select\n" +
                "ques_no,\n" +
                "stu_id ,\n" +
                "stu_ques_asw_time,\n" +
                "sub_subject\n" +
                "from \n" +
                "base_student_question_log_time_tda20251023_mix\n" +
                "where\n" +
                "region1 = '"+region+"'\n" +
                "and \n" +
                "province = '"+province+"'\n" +
                "and \n" +
                "subject_type='常规'\n" +
                "and \n" +
                "exam_id = 'TDA20251023G12'\n" ;
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        List<DtoAsw> listDtoAsw = jdbcTemplate.query(sql,new Object[]{},new BeanPropertyRowMapper<>(DtoAsw.class));

        Map<String,List<DtoAsw>>  collect = listDtoAsw.stream().collect(Collectors.groupingBy(DtoAsw::getSubSubject));

        //科目粒度
        for (String subject : collect.keySet()) {
            System.out.println("operator"+subject+"科目");
            String sql2 = "select stu_id from base_student_subject_tda20251023_mix where " +
                    "region1 = '"+region+"'\n" +
                    "and \n" +
                    "sub_subject = '"+subject+"'\n" +
                    "and \n" +
                    "province = '"+province+"' \n" +
                    "and \n" +
                    "subject_type= '常规'\n" +
                    "and \n" +
                    "exam_id = 'TDA20251023G12'\n" +
                    "and  \n" +
                    "stu_subject_score_rate_province_pct_rank >= (1-0.27)";

            List<String> excellent = jdbcTemplate.queryForList(sql2,String.class);

            List<DtoAsw> list = collect.get(subject);

            List<DtoAsw> exCollect = list.stream().filter(x->excellent.contains(x.getStuId())).collect(Collectors.toList());

            Map<String, List<DtoAsw>> collect1 = exCollect.stream().collect(Collectors.groupingBy(DtoAsw::getQuesNo));
            for (String ques_no : collect1.keySet()) {
                System.out.println("计算题目编号:"+ques_no);
                List<DtoAsw> aswList  =  collect1.get(ques_no);
                Double sumTime =  aswList.stream().mapToDouble(DtoAsw::getStuQuesAswTime).sum();
                Double avgTime =  sumTime/aswList.size();
                System.out.println(avgTime);
                HashMap params = new HashMap(){{
                    put("subSubject",subject);
                    put("province",province);
                    put("region",region);
                    put("quesNo",ques_no);
                    put("time",avgTime);
                }};
                namedParameterJdbcTemplate.update("insert into province_excellent_asw_time20251023(sub_subject,province,region,ques_no,time) value (:subSubject,:province,:region,:quesNo,:time)",new MapSqlParameterSource(params));
            }
        }

    }

   // region_excellent_asw_time
    @Test
    public void ExcellentRegionAswTime(){
       String sql = "select region1 from base_province_subject_tda20251023 where subject_type = '常规' group by region1\n";
       JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();
       List<String> regions = reportJdbcTemplate.queryForList(sql,String.class);
        for (String region : regions) {
            ExcellentRegionAsw(region,reportJdbcTemplate);
        }
//        ExcellentRegionAsw("",reportJdbcTemplate);
    }

    public void ExcellentRegionAsw(String region,JdbcTemplate jdbcTemplate){

        String sql = "select\n" +
                "ques_no,\n" +
                "sub_subject,\n" +
                "stu_id,\n" +
                "stu_ques_asw_time\n" +
                "from \n" +
                "base_student_question_log_time_tda20251023\n" +
                "where\n" +
                "region1 = '"+region+"'\n" +
                "and \n" +
                "subject_type= '常规'\n" +
                "and \n" +
                "exam_id = 'TDA20251023G12'\n";
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);

        List<DtoAsw> list = jdbcTemplate.query(sql,new Object[]{},new BeanPropertyRowMapper<>(DtoAsw.class));

        Map<String, List<DtoAsw>> collect = list.stream().collect(Collectors.groupingBy(DtoAsw::getSubSubject));

        for (String subject : collect.keySet()) {
            String sql2 = "select stu_id from base_student_subject_tda20251023 where " +
                    "region1 = '"+region+"'\n" +
                    "and \n" +
                    "sub_subject = '"+subject+"'\n" +
                    "and \n" +
                    "subject_type= '常规'\n" +
                    "and \n" +
                    "exam_id = 'TDA20251023G12'\n" +
                    "and  \n" +
                    "stu_subject_score_rate_region_pct_rank >= (1-0.27)";
            List<String> yousheng = jdbcTemplate.queryForList(sql2,String.class);
            List<DtoAsw> col = collect.get(subject);
            List<DtoAsw> youshengList = col.stream().filter(x->yousheng.contains(x.getStuId())).collect(Collectors.toList());
            Map<String, List<DtoAsw>> collect1 = youshengList.stream().collect(Collectors.groupingBy(DtoAsw::getQuesNo));
            for (String ques_no : collect1.keySet()) {
                System.out.println("计算编号为:"+ques_no);
                Double sumTime = collect1.get(ques_no).stream().mapToDouble(DtoAsw::getStuQuesAswTime).sum();
                Double avgTime = sumTime/collect1.get(ques_no).size();
                HashMap params = new HashMap(){{
                    put("subSubject",subject);
                    put("region",region);
                    put("quesNo",ques_no);
                    put("time",avgTime);
                }};

                namedParameterJdbcTemplate.update("insert into region_excellent_asw_time20251023(sub_subject,region,ques_no,time) value (:subSubject,:region,:quesNo,:time)",new MapSqlParameterSource(params));
            }

        }

    }

    // region_ques_type_excellent
    @Test
    public void testQuesType(){
        String sql = "select region1 from base_province_subject_tda20251023 where subject_type = '常规' group by region1\n";
        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();
        List<String> regions = reportJdbcTemplate.queryForList(sql,String.class);
        for (String region : regions) {
            testQuesTypeScoreMean(region,reportJdbcTemplate);
        }
    }

    public void testQuesTypeScoreMean(String region,JdbcTemplate jdbcTemplate){

        String sql = "select\n" +
                "ques_type,\n" +
                "stu_qt_score_rate,\n" +
                "sub_subject,\n" +
                "stu_id\n" +
                "from\n" +
                "base_student_ques_type_tda20251023\n" +
                "where\n" +
                "region1 = '"+region+"'\n" +
                "\t\t\tAND subject_type = '常规' \n" +
                "\t\t\tAND exam_id = 'TDA20251023G12'\n";

        List<DtoArgs> list = jdbcTemplate.query(sql,new Object[]{},new BeanPropertyRowMapper<>(DtoArgs.class));
        Map<String, List<DtoArgs>> collect = list.stream().collect(Collectors.groupingBy(DtoArgs::getSubSubject));
        for (String subject : collect.keySet()) {
            String sql2 = "SELECT\n" +
                    "\tstu_id \n" +
                    "FROM\n" +
                    "\tbase_student_subject_tda20251023 \n" +
                    "WHERE\n" +
                    "\tstu_subject_score_rate_region_pct_rank >= ( 1-0.27 ) \n" +
                    "\tAND region1 = '"+region+"' \n" +
                    "\tAND subject_type = '常规' \n" +
                    "\tAND exam_id = 'TDA20251023G12' \n" +
                    "\tAND sub_subject = '"+subject+"'";
            List<String> youshengIds = jdbcTemplate.queryForList(sql2, String.class);

            //单科
            List<DtoArgs> subejectList =  collect.get(subject);

            List<DtoArgs> collect1 = subejectList.stream().filter(x -> youshengIds.contains(x.getStuId())).collect(Collectors.toList());

            //优生
            Map<String, List<DtoArgs>> collect2 = collect1.stream().collect(Collectors.groupingBy(DtoArgs::getQuesType));

            for (String ques_type : collect2.keySet()) {
                //进行插入数据
                List<DtoArgs> finalList = collect2.get(ques_type);
                Double typeRateMean = finalList.stream().mapToDouble(DtoArgs::getStuQtScoreRate).sum();
                Double resultMean = typeRateMean/finalList.size();
                if(Double.isNaN(resultMean)||Double.isInfinite(resultMean)){
                    resultMean = 0.0;
                }

                System.out.println(resultMean);
                HashMap params = new HashMap(){{
                    put("subSubject",subject);
                    put("region",region);
                    put("quesType",ques_type);
                }};
                params.put("Mean",resultMean);

                NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);
                namedParameterJdbcTemplate.update("insert into region_ques_type_excellent20251023(region,sub_subject,mean,ques_type) value (:region,:subSubject,:Mean,:quesType)",new MapSqlParameterSource(params));
            }

        }

    }

}
