package com.example.pdfgenerator.controller;

import com.example.pdfgenerator.Dto.ClassBasicReportParameters;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@RestController
@RequestMapping("/classController")
public class ClassController {

    @Autowired
    private COSClient cosClient;

    private static final String bucketName = "schoolreportpdf-1317275686";

    private JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();

    @GetMapping("/generatorClassBasic")
    public void GeneratorClassBasicController(@RequestParam(value = "examId",required = false) String examId) throws IOException, InterruptedException {

        HashMap<String,ClassBasicReportParameters> fileToCosPath = new HashMap<>();

        String suffix  = examId.trim().replace("TDA","").replace("G3","").replace("G2","").trim();

        String sqlStatement = "SELECT\n" +
                "\tclass AS class_name,\n" +
                "\tschool,\n" +
                "\texam_id,\n" +
                "\tprovince,\n" +
                "\tregion \n" +
                "FROM\n" +
                "\tbase_class_total_score_tda"+suffix+"\n" +
                "WHERE\n" +
                "\tsubject_type = '常规'\n" +
                "and province = '山东省'\n" +
                "GROUP BY\n" +
                "\tclass,\n" +
                "\tschool,\n" +
                "\texam_id,\n" +
                "\tprovince,\n" +
                "\tregion\n";

        List<ClassBasicReportParameters> parametersList = this.reportJdbcTemplate.query(sqlStatement,new Object[]{},new BeanPropertyRowMapper<>(ClassBasicReportParameters.class));

        Runtime runtime  = Runtime.getRuntime();

        List<String> basicReportCommands  =  new ArrayList<>();

        List<String> files = new ArrayList<>();

        String reformCommand = "node D:\\myWorkSpace\\pdfOfClassBasicGen.js \"http://localhost:8080/pdf/classBasic?province=condition5&school=condition1&examId=condition4&region=conditionC&subjectType=常规&className=conditionA\" pdf ";

        String unReformCommand = "node D:\\myWorkSpace\\pdfOfClassBasicGen.js \"http://localhost:8080/pdf/classBasic?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subjectType=常规&className=conditionA\" pdf ";

        for (ClassBasicReportParameters basicReportParameters : parametersList) {

            String command  = "";

            String fileName = "";

            if(basicReportParameters.getRegion().equals("改革")||basicReportParameters.getRegion().equals("改革A")){

                fileName = "D:\\Class\\Basic\\"+basicReportParameters.getRegion()+basicReportParameters.getProvince()+basicReportParameters.getSchool()+ basicReportParameters.getClassName()+basicReportParameters.getExamId()+".pdf";

                command = reformCommand.replace("condition1", basicReportParameters.getSchool()).replace("condition5", basicReportParameters.getProvince()).replace("conditionC",basicReportParameters.getRegion()).replace("condition4", basicReportParameters.getExamId()).replace("conditionA",basicReportParameters.getClassName())
                          .concat(" ").concat(fileName);

            } else {

                fileName = "D:\\Class\\Basic\\"+basicReportParameters.getRegion()+basicReportParameters.getProvince()+basicReportParameters.getSchool()+basicReportParameters.getClassName()+basicReportParameters.getExamId()+".pdf";

                command = unReformCommand.replace("condition1", basicReportParameters.getSchool()).replace("condition5", basicReportParameters.getProvince()).replace("condition3",basicReportParameters.getRegion()).replace("condition4", basicReportParameters.getExamId()).replace("conditionA",basicReportParameters.getClassName())
                          .concat(" ").concat(fileName);

            }

            basicReportCommands.add(command);

            fileToCosPath.put(fileName,basicReportParameters);

            files.add(fileName);

        }

        int i = 0;

        for (String command : basicReportCommands) {

            System.out.println("班级综合报告总共需生成:"+basicReportCommands.size());

            System.out.println("正在生成第"+(++i)+"报告");

            System.out.println("执行命令是:");

            System.out.println(command);

            runtime.exec(command);

            Thread.sleep(12000);
            //上传到cos当中去

            File file = new File("D:\\Class\\Basic");

            File[] files1 = file.listFiles();

            assert files1 != null;

            for (File file1 : files1) {

                ClassBasicReportParameters parameters = fileToCosPath.get(file1.getAbsolutePath());

                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, "class/"+parameters.getExamId()+"/"+parameters.getProvince()+"/"+parameters.getSchool()+"/班级综合报告/"+parameters.getClassName()+"/"+file1.getName(), file1);

                try {

                    PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);

                    System.out.println(putObjectResult.getRequestId());

                    file1.delete();

                } catch (CosServiceException e) {

                    System.out.println("cos服务出现问题");

                    e.printStackTrace();

                } catch (CosClientException e) {

                    System.out.println("cos客户端出现问题出现问题的文件是"+file1.getName());

                    e.printStackTrace();

                }
            }
        }
    }

   //待完成 ---- > subject of class
    @RequestMapping("/generatorClassSubject")
    public ResponseEntity BatchSubjectPdfGenerator(@RequestParam(value = "examId",required = false)String examId) throws IOException, InterruptedException {

        String suffix  = examId.trim().replace("TDA","").replace("G3","").replace("G2","").trim();

        HashMap<String,ClassBasicReportParameters> fileToCosPath = new HashMap<>();

        String sqlStatement = "SELECT\n" +
                "\tclass as class_name,\n" +
                "\tsub_subject,\n" +
                "\tschool,\n" +
                "\tprovince,\n" +
                "\tregion,\n" +
                "\texam_id\n" +
                "FROM\n" +
                "\tbase_student_subject_tda"+suffix+"\n" +
                "where\n" +
                "subject_type = '常规'\n" +
                "\tGROUP BY\n" +
                "\tclass,\n" +
                "\tsub_subject,\n" +
                "\tschool,\n" +
                "\tprovince,\n" +
                "\tregion,\n" +
                "\texam_id";

        List<ClassBasicReportParameters> parametersList = this.reportJdbcTemplate.query(sqlStatement, new Object[]{}, new BeanPropertyRowMapper<>(ClassBasicReportParameters.class));

        Runtime runtime = Runtime.getRuntime();

        List<String> basicReportCommands = new ArrayList<>();

        List<String> files = new ArrayList<>();

        String reformCommand = "node D:\\myWorkSpace\\pdfOfClassSubjectGen.js \"http://localhost:8080/pdf/classSubject?province=condition5&school=condition1&examId=condition4&region=conditionC&subSubject=condition6&subjectType=常规&className=conditionA\" pdf";

        String unReformCommand = "node D:\\myWorkSpace\\pdfOfClassSubjectGen.js \"http://localhost:8080/pdf/classSubject?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subSubject=condition6&subjectType=常规&className=conditionA\" pdf";

        for (int i = 0; i < parametersList.size(); i++) {
            String command = "";

            String fileName = "";

            ClassBasicReportParameters basicReportParameters = parametersList.get(i);

            if (basicReportParameters.getRegion().equals("改革")||basicReportParameters.getRegion().equals("改革A")) {
                fileName = "D:\\Class\\Subject\\" + basicReportParameters.getRegion() + basicReportParameters.getProvince() + basicReportParameters.getSchool() + basicReportParameters.getSubSubject() + basicReportParameters.getExamId() + basicReportParameters.getSubSubject() + basicReportParameters.getClassName().replace(" ","")+ ".pdf";
                command = reformCommand.replace("condition1", basicReportParameters.getSchool()).replace("condition5", basicReportParameters.getProvince()).replace("conditionC", basicReportParameters.getRegion()).replace("condition4", basicReportParameters.getExamId()).replace("condition6", basicReportParameters.getSubSubject()).replace("conditionA",basicReportParameters.getClassName())
                        .concat(" ").concat(fileName);
            } else {
                fileName = "D:\\Class\\Subject\\" + basicReportParameters.getRegion() + basicReportParameters.getProvince() + basicReportParameters.getSchool() + basicReportParameters.getSubSubject() + basicReportParameters.getExamId() + basicReportParameters.getSubSubject() + basicReportParameters.getClassName().replace(" ","")+".pdf";
                command = unReformCommand.replace("condition1", basicReportParameters.getSchool()).replace("condition5", basicReportParameters.getProvince()).replace("condition3", basicReportParameters.getRegion()).replace("condition4", basicReportParameters.getExamId()).replace("condition6", basicReportParameters.getSubSubject()).replace("conditionA",basicReportParameters.getClassName())
                        .concat(" ").concat(fileName);
                ;
            }
            basicReportCommands.add(command);
            fileToCosPath.put(fileName,basicReportParameters);
            files.add(fileName);
        }
//        for (ClassBasicReportParameters basicReportParameters : parametersList) {
//
//            String command = "";
//
//            String fileName = "";
//
//            if (basicReportParameters.getRegion().equals("改革")||basicReportParameters.getRegion().equals("改革A")) {
//                fileName = "D:\\Class\\Subject\\" + basicReportParameters.getRegion() + basicReportParameters.getProvince() + basicReportParameters.getSchool() + basicReportParameters.getSubSubject() + basicReportParameters.getExamId() + basicReportParameters.getSubSubject() + basicReportParameters.getClassName().replace(" ","")+ ".pdf";
//                command = reformCommand.replace("condition1", basicReportParameters.getSchool()).replace("condition5", basicReportParameters.getProvince()).replace("conditionC", basicReportParameters.getRegion()).replace("condition4", basicReportParameters.getExamId()).replace("condition6", basicReportParameters.getSubSubject()).replace("conditionA",basicReportParameters.getClassName())
//                        .concat(" ").concat(fileName);
//            } else {
//                fileName = "D:\\Class\\Subject\\" + basicReportParameters.getRegion() + basicReportParameters.getProvince() + basicReportParameters.getSchool() + basicReportParameters.getSubSubject() + basicReportParameters.getExamId() + basicReportParameters.getSubSubject() + basicReportParameters.getClassName().replace(" ","")+".pdf";
//                command = unReformCommand.replace("condition1", basicReportParameters.getSchool()).replace("condition5", basicReportParameters.getProvince()).replace("condition3", basicReportParameters.getRegion()).replace("condition4", basicReportParameters.getExamId()).replace("condition6", basicReportParameters.getSubSubject()).replace("conditionA",basicReportParameters.getClassName())
//                        .concat(" ").concat(fileName);
//                ;
//            }
//            basicReportCommands.add(command);
//            fileToCosPath.put(fileName,basicReportParameters);
//            files.add(fileName);
//        }

        int i = 0;

        //偶有出现 遗留两个文件的情况
        for (String command : basicReportCommands) {
            Thread.sleep(6125);
            System.err.println("学科报告总共需生成:" + parametersList.size());
            System.err.println("正在生成第" + (++i) + "报告");
            System.err.println("执行命令是:");
            System.err.println(command);
            runtime.exec(command);
//            执行完 上传文件 cos
            File file = new File("D:/Class/Subject");
            File[] files1 = file.listFiles();
            assert files1 != null;
            for (File file1 : files1) {
                ClassBasicReportParameters parameters = fileToCosPath.get(file1.getAbsolutePath());
                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, "class/"+parameters.getExamId()+"/"+parameters.getProvince()+"/"+parameters.getSchool()+"/班级学科报告/"+parameters.getClassName()+"/"+parameters.getSubSubject()+"/"+file1.getName(),file1);
                try {
                    PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                    System.out.println(putObjectResult.getRequestId());
                    file1.delete();
                } catch (CosServiceException e ) {
                    System.out.println("cos服务出现问题");
                    e.printStackTrace();
                } catch (CosClientException e ) {
                    System.out.println("cos客户端出现问题出现问题的文件是" + files.get(i));
                    e.printStackTrace();
                }
            }
        }
        return ResponseEntity.ok("done");
    }
}
