package com.example.pdfgenerator.controller;

import com.example.pdfgenerator.Dto.BasicReportParameters;
import com.example.pdfgenerator.Dto.ClassBasicReportParameters;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;


@RestController
public class PDFGeByProvinceBatchController {


    private static final Logger logger = LoggerFactory.getLogger(GeneratorAllTypePdfByProvinceController.class);

    @Autowired
    private COSClient cosClient;

    JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();

    private static final String bucketName = "schoolreportpdf-1317275686";



    @GetMapping("/BatchGeByProvinceName")
    public ResponseEntity generatorName(@RequestParam("examId")String examId, @RequestParam(value = "provinceName",required = false)String provinceName) throws IOException, InterruptedException {

        String suffix  = examId.trim().replace("TDA","").replace("G3","").replace("G2","").trim();

        String  synthesisSchoolSubjectReportSql = "select \n" +
                "school,exam_id,province,region,sub_subject\n" +
                "from \n" +
                "base_school_subject_tda"+suffix+" \n" +
                " where subject_type = '常规'\n";

        String  synthesisSchoolReportSql = "select \n" +
                "school,exam_id,province,region\n" +
                "from \n" +
                "base_school_total_score_tda"+suffix+"  where subject_type = '常规'\n";

        String synthesisClassSubjectReportSql = "SELECT\n" +
                "\tclass as class_name,\n" +
                "\tsub_subject,\n" +
                "\tschool,\n" +
                "\tprovince,\n" +
                "\tregion,\n" +
                "\texam_id\n" +
                "FROM\n" +
                "\tbase_student_subject_tda"+suffix+"\n" +
                "where\n" +
                "subject_type = '常规'\n" ;

        String synthesisClassReportSql = "SELECT\n" +
                "\tclass AS class_name,\n" +
                "\tschool,\n" +
                "\texam_id,\n" +
                "\tprovince,\n" +
                "\tregion \n" +
                "FROM\n" +
                "\tbase_class_total_score_tda"+suffix+"\n" +
                "WHERE\n" +
                "\tsubject_type = '常规'\n" ;

        if(provinceName!=null){

            List<String> provinceList = Arrays.asList(provinceName.split("#"));

            String appendStatement  = "and province in (" ;

            for (String s : provinceList) {
                appendStatement = appendStatement +"'"+s+"',";
            }

            appendStatement = appendStatement.substring(0,appendStatement.length()-1)+") ";

            synthesisSchoolSubjectReportSql = synthesisSchoolSubjectReportSql + " " + appendStatement;
            synthesisSchoolReportSql = synthesisSchoolReportSql + " " + appendStatement ;
            synthesisClassSubjectReportSql = synthesisClassSubjectReportSql + " " + appendStatement;
            synthesisClassReportSql = synthesisClassReportSql + " " + appendStatement;


        }

        synthesisSchoolSubjectReportSql = synthesisSchoolSubjectReportSql + "group by school,exam_id,province,region,sub_subject";

        synthesisSchoolReportSql = synthesisSchoolReportSql + " " + "group by school,exam_id,province,region";

        synthesisClassSubjectReportSql = synthesisClassSubjectReportSql + " " +  "\tGROUP BY\n" +"\tclass,\n" + "\tsub_subject,\n" + "\tschool,\n" + "\tprovince,\n" + "\tregion,\n" + "\texam_id";

        synthesisClassReportSql = synthesisClassReportSql + " " + "GROUP BY\n" + "\tclass,\n" + "\tschool,\n" + "\texam_id,\n" + "\tprovince,\n" + "\tregion\n";




        List<BasicReportParameters> synthesisSchoolSubjectReportParameters = this.reportJdbcTemplate.query(synthesisSchoolSubjectReportSql, new Object[]{}, new BeanPropertyRowMapper<>(BasicReportParameters.class));

        for (BasicReportParameters parameter : synthesisSchoolSubjectReportParameters) {
            if(parameter.getRegion().equals("改革")||parameter.getRegion().equals("改革A")){
                String command = "node /myworkSpace/puppeteer2.js \"http://localhost:8059/pdf/subject?province=condition5&school=condition1&examId=condition4&region=conditionC&subSubject=condition6&subjectType=常规\" pdf";
                command = command.replace("condition1", parameter.getSchool()).replace("condition5", parameter.getProvince()).replace("conditionC", parameter.getRegion()).replace("condition4", parameter.getExamId()).replace("condition6", parameter.getSubSubject())
                        .concat(" ").concat("/myworkSpace/subject/" + parameter.getRegion() + parameter.getProvince() + parameter.getSchool() + parameter.getSubSubject() + parameter.getExamId() + ".pdf");
                parameter.setCommand(command);
            }else{
                String command = "node /myworkSpace/puppeteer2.js \"http://localhost:8059/pdf/subject?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subSubject=condition6&subjectType=常规\" pdf";
                command = command.replace("condition1", parameter.getSchool()).replace("condition5", parameter.getProvince()).replace("condition3", parameter.getRegion()).replace("condition4", parameter.getExamId()).replace("condition6", parameter.getSubSubject())
                        .concat(" ").concat("/myworkSpace/subject/" + parameter.getRegion() + parameter.getProvince() + parameter.getSchool() + parameter.getSubSubject() + parameter.getExamId() + ".pdf");
                parameter.setCommand(command);
            }
        }

        List<BasicReportParameters> synthesisSchoolReportParameters = this.reportJdbcTemplate.query(synthesisSchoolReportSql, new Object[]{}, new BeanPropertyRowMapper<>(BasicReportParameters.class));

        for (BasicReportParameters synthesisSchoolReportParameter : synthesisSchoolReportParameters) {
            if(synthesisSchoolReportParameter.getRegion().equals("改革")||synthesisSchoolReportParameter.getRegion().equals("改革A")){
                String command = "node /myworkSpace/puppeteer.js \"http://localhost:8059/pdf/basic?province=condition5&school=condition1&examId=condition4&region=conditionC&subjectType=常规\" pdf ";
                command = command.replace("condition1", synthesisSchoolReportParameter.getSchool()).replace("condition5", synthesisSchoolReportParameter.getProvince()).replace("conditionC",synthesisSchoolReportParameter.getRegion()).replace("condition4", synthesisSchoolReportParameter.getExamId())
                        .concat(" ").concat("/myworkSpace/basic/"+synthesisSchoolReportParameter.getRegion()+synthesisSchoolReportParameter.getProvince()+synthesisSchoolReportParameter.getSchool()+synthesisSchoolReportParameter.getExamId()+".pdf");
                synthesisSchoolReportParameter.setCommand(command);
            }else{
                String command = "node /myworkSpace/puppeteer.js \"http://localhost:8059/pdf/basic?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subjectType=常规\" pdf ";
                command = command.replace("condition1", synthesisSchoolReportParameter.getSchool()).replace("condition5", synthesisSchoolReportParameter.getProvince()).replace("condition3",synthesisSchoolReportParameter.getRegion()).replace("condition4", synthesisSchoolReportParameter.getExamId())
                        .concat(" ").concat("/myworkSpace/basic/"+synthesisSchoolReportParameter.getRegion()+synthesisSchoolReportParameter.getProvince()+synthesisSchoolReportParameter.getSchool()+synthesisSchoolReportParameter.getExamId()+".pdf");
                synthesisSchoolReportParameter.setCommand(command);
            }
        }

        List<ClassBasicReportParameters> synthesisClassSubjectReportParameters = this.reportJdbcTemplate.query(synthesisClassSubjectReportSql,new Object[]{},new BeanPropertyRowMapper<>(ClassBasicReportParameters.class));

        for (ClassBasicReportParameters synthesisClassSubjectReportParameter : synthesisClassSubjectReportParameters) {

            if (synthesisClassSubjectReportParameter.getRegion().equals("改革")||synthesisClassSubjectReportParameter.getRegion().equals("改革A")) {
                String command = "node /myworkSpace/pdfOfClassSubjectGen.js \"http://localhost:8059/pdf/classSubject?province=condition5&school=condition1&examId=condition4&region=conditionC&subSubject=condition6&subjectType=常规&className=conditionA\" pdf";
                String fileName = "/myworkSpace/Class/subject/" + synthesisClassSubjectReportParameter.getRegion() + synthesisClassSubjectReportParameter.getProvince() + synthesisClassSubjectReportParameter.getSchool() + synthesisClassSubjectReportParameter.getSubSubject() + synthesisClassSubjectReportParameter.getExamId() + synthesisClassSubjectReportParameter.getSubSubject() + synthesisClassSubjectReportParameter.getClassName().replace(" ","")+ ".pdf";
                command = command.replace("condition1", synthesisClassSubjectReportParameter.getSchool()).replace("condition5", synthesisClassSubjectReportParameter.getProvince()).replace("conditionC", synthesisClassSubjectReportParameter.getRegion()).replace("condition4", synthesisClassSubjectReportParameter.getExamId()).replace("condition6", synthesisClassSubjectReportParameter.getSubSubject()).replace("conditionA",synthesisClassSubjectReportParameter.getClassName())
                        .concat(" ").concat(fileName);
                synthesisClassSubjectReportParameter.setCommand(command);
            } else {
                String command = "node /myworkSpace/pdfOfClassSubjectGen.js \"http://localhost:8059/pdf/classSubject?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subSubject=condition6&subjectType=常规&className=conditionA\" pdf";

                String fileName = "/myworkSpace/Class/subject/" + synthesisClassSubjectReportParameter.getRegion() + synthesisClassSubjectReportParameter.getProvince() + synthesisClassSubjectReportParameter.getSchool() + synthesisClassSubjectReportParameter.getSubSubject() + synthesisClassSubjectReportParameter.getExamId() + synthesisClassSubjectReportParameter.getSubSubject() + synthesisClassSubjectReportParameter.getClassName().replace(" ","")+".pdf";
                command = command.replace("condition1", synthesisClassSubjectReportParameter.getSchool()).replace("condition5", synthesisClassSubjectReportParameter.getProvince()).replace("condition3", synthesisClassSubjectReportParameter.getRegion()).replace("condition4", synthesisClassSubjectReportParameter.getExamId()).replace("condition6", synthesisClassSubjectReportParameter.getSubSubject()).replace("conditionA",synthesisClassSubjectReportParameter.getClassName())
                        .concat(" ").concat(fileName);
                synthesisClassSubjectReportParameter.setCommand(command);
            }
        }

        List<ClassBasicReportParameters> synthesisClassReportParameters = this.reportJdbcTemplate.query(synthesisClassReportSql,new Object[]{},new BeanPropertyRowMapper<>(ClassBasicReportParameters.class));

        for (ClassBasicReportParameters synthesisClassReportParameter : synthesisClassReportParameters) {
            if(synthesisClassReportParameter.getRegion().equals("改革")||synthesisClassReportParameter.getRegion().equals("改革A")){

                String  command = "node /myworkSpace/pdfOfClassBasicGen.js \"http://localhost:8059/pdf/classBasic?province=condition5&school=condition1&examId=condition4&region=conditionC&subjectType=常规&className=conditionA\" pdf ";

                String fileName = "/myworkSpace/Class/Basic/"+synthesisClassReportParameter.getRegion()+synthesisClassReportParameter.getProvince()+synthesisClassReportParameter.getSchool()+ synthesisClassReportParameter.getClassName()+synthesisClassReportParameter.getExamId()+".pdf";

                command = command.replace("condition1", synthesisClassReportParameter.getSchool()).replace("condition5", synthesisClassReportParameter.getProvince()).replace("conditionC",synthesisClassReportParameter.getRegion()).replace("condition4", synthesisClassReportParameter.getExamId()).replace("conditionA",synthesisClassReportParameter.getClassName())
                        .concat(" ").concat(fileName);

                synthesisClassReportParameter.setCommand(command);

            } else {

                String command = "node/myworkSpace/pdfOfClassBasicGen.js \"http://localhost:8059/pdf/classBasic?province=condition5&school=condition1&examId=condition4&region=非改革&branch=condition3&subjectType=常规&className=conditionA\" pdf ";

                String fileName = "/myworkSpace/Class/Basic/"+synthesisClassReportParameter.getRegion()+synthesisClassReportParameter.getProvince()+synthesisClassReportParameter.getSchool()+synthesisClassReportParameter.getClassName()+synthesisClassReportParameter.getExamId()+".pdf";

                command = command.replace("condition1", synthesisClassReportParameter.getSchool()).replace("condition5", synthesisClassReportParameter.getProvince()).replace("condition3",synthesisClassReportParameter.getRegion()).replace("condition4", synthesisClassReportParameter.getExamId()).replace("conditionA",synthesisClassReportParameter.getClassName())
                        .concat(" ").concat(fileName);

                synthesisClassReportParameter.setCommand(command);

            }
        }

        Map<String, List<BasicReportParameters>> schoolReport = synthesisSchoolReportParameters.stream().collect(Collectors.groupingBy(BasicReportParameters::getProvince));

//        Map<String, List<BasicReportParameters>>  schoolSubjectReport = synthesisSchoolSubjectReportParameters.stream().collect(Collectors.groupingBy(BasicReportParameters::getProvince));
//
//        Map<String, List<ClassBasicReportParameters>>  classReport = synthesisClassReportParameters.stream().collect(Collectors.groupingBy(ClassBasicReportParameters::getProvince));
//
//        Map<String, List<ClassBasicReportParameters>>  classSubjectReport = synthesisClassSubjectReportParameters.stream().collect(Collectors.groupingBy(ClassBasicReportParameters::getProvince));


        //分组开始执行记录
        for (String key : schoolReport.keySet()) {
            logger.info("province:"+key+ "Gen...............................................................");
            List<BasicReportParameters>  schoolBasicReport = schoolReport.get(key);
            for (BasicReportParameters schoolLevel : schoolBasicReport) {
                logger.info("school:"+schoolLevel.getSchool()+"loading---------------------------------------------------------------");
                logger.info("basicReport:loading******************************************");
                ProcessBuilder processBuilder = new ProcessBuilder();
                processBuilder.command("bash", "-c", schoolLevel.getCommand());
                processBuilder.redirectErrorStream(true); // 合并标准输出和错误输出
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line;
                while ((line = reader.readLine()) != null) {
                }
                int exitCode = process.waitFor();
                logger.info("exitCode:"+schoolLevel.getSchool());
                File file = new File("/myworkSpace/basic/");
                File[] files1 = file.listFiles();
                assert files1 != null;
                for (File file1 : files1) {
                    PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, "PdfTest/"+file1.getName(), file1);
                    try {
                        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                        logger.info(putObjectResult.getRequestId());
                        file1.delete();
                    } catch (CosServiceException e) {
                        logger.info("cos服务出现问题");
                        e.printStackTrace();
                    } catch (CosClientException e) {
                        logger.info("cos客户端出现问题"+file.getName()+"文件上传有误,重新上传");
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }


}
