package com.example.pdfgenerator.config;

import com.alibaba.druid.pool.DruidDataSource;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;

/**
 * @author yn
 * @version 1.0
 * @date 2020/9/15 15:30
 */
@Configuration
public class MyDataSourceConfig {



    private static JdbcTemplate reportJdbcTemplate;

    private static JdbcTemplate mkReportJdbcTemplate;

    private static JdbcTemplate campsiteJdbcTemplate;


    @PostConstruct
    private void init() {
        initReport();
        initMkReport();
//        initCampCenter();
    }


    public static JdbcTemplate getReportJdbcTemplate(){
        return reportJdbcTemplate;
    }

    public static JdbcTemplate getMkReportJdbcTemplate() { return mkReportJdbcTemplate; }

    public static JdbcTemplate getCampsiteJdbcTemplate(){
        return campsiteJdbcTemplate;
    }



    public DataSource initReport(){

        System.err.println("print init reportSource...");
        //外网
        String url = "jdbc:mysql://192.168.0.46:3306/tempnew?useUnicode=true&characterEncoding=utf-8&useSSL=false&serverTimezone=GMT%2B8";
        DruidDataSource dataSource  = getDataSource(url);
        dataSource.setUsername("jiru");
        dataSource.setPassword("Jiru@20231026");
        reportJdbcTemplate = new JdbcTemplate(dataSource);
        return dataSource;

    }

    public DataSource initMkReport(){

        System.err.println("print init mkSource...");
        //外网
        String url = "jdbc:mysql://192.168.0.11:3306/boye_20240911?useUnicode=true&characterEncoding=utf-8&useSSL=false&serverTimezone=GMT%2B8";
        DruidDataSource dataSource  = getDataSource(url);
        dataSource.setUsername("root");
        dataSource.setPassword("Thu#DSS#0419");
        mkReportJdbcTemplate = new JdbcTemplate(dataSource);
        return dataSource;

    }

//    public DataSource initCampCenter(){
//        System.err.println("print init campsiteSource...");
//        //外网
//        String url = "jdbc:mysql://10.0.0.8:3306/yingdi?useUnicode=true&characterEncoding=utf-8&useSSL=false&serverTimezone=GMT%2B8";
//        DruidDataSource dataSource  = getDataSource(url);
//        dataSource.setUsername("root");
//        dataSource.setPassword("sunny@campcenter1017");
//        reportJdbcTemplate = new JdbcTemplate(dataSource);
//        return dataSource;
//    }

    private DruidDataSource getDataSource(String url) {
        DruidDataSource dataSource = new DruidDataSource();
        //设置连接池里面的连接连接池的必要参数
        dataSource.setDriverClassName("com.mysql.jdbc.Driver");
        dataSource.setUrl(url);
        dataSource.setUsername("thussat");
        dataSource.setPassword("Thussat@2020");
        dataSource.setInitialSize(8);
        dataSource.setMaxActive(20);
        dataSource.setMinIdle(5);
        dataSource.setMaxWait(60000);
        dataSource.setDefaultAutoCommit(true);
        dataSource.setValidationQuery("SELECT 1 FROM DUAL");
        dataSource.setValidationQueryTimeout(60000);
        dataSource.setTestOnBorrow(false);
        dataSource.setTestOnReturn(false);
        dataSource.setTestWhileIdle(true);
        dataSource.setTimeBetweenEvictionRunsMillis(60000);
        dataSource.setMinEvictableIdleTimeMillis(300000);

        dataSource.setBreakAfterAcquireFailure(false);//出错时不把正在提交的数据抛弃
        return dataSource;
    }
}
