package com.example.pdfgenerator.DataProcessing;

import com.example.pdfgenerator.Dto.Params;
import com.example.pdfgenerator.DtoKn;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@SpringBootTest
public class NumberTwo {

//    @Test
    public void ProvinceExKnow(){
        JdbcTemplate jdbcTemplate = MyDataSourceConfig.getReportJdbcTemplate();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);
        String sql = "select region,province from base_school_subject_tda20240919 where subject_type = '常规' group by region,province";
        List<Params> paramsList  = namedParameterJdbcTemplate.query(sql,new BeanPropertyRowMapper<>(Params.class));
        for (Params param : paramsList) {
            provinceExe(param.getRegion(),param.getProvince(),namedParameterJdbcTemplate);
        }
    }

    public void provinceExe(String region,String province,NamedParameterJdbcTemplate reportTemplate){

        String sql = "select \n" +
                "knowledge,\n" +
                "stu_kn_score_rate,\n" +
                "sub_subject,\n" +
                "stu_id\n" +
                "from\n" +
                "base_student_knowledge_tda20240919\n" +
                "where\n" +
                "region = '"+region+"' and subject_type = '常规' and province = '"+province+"'";

        List<DtoKn> list = reportTemplate.query(sql,new HashMap<>(),new BeanPropertyRowMapper<>(DtoKn.class));
        Map<String, List<DtoKn>> collect = list.stream().collect(Collectors.groupingBy(DtoKn::getSubSubject));
        for (String subject : collect.keySet()) {
            //单个科目
            List<DtoKn> data  = collect.get(subject);
            String sql3  = "\t\t\t\tSELECT\n" +
                    "\t\t\tstu_id \n" +
                    "\t\tFROM\n" +
                    "\t\t\tbase_student_subject_tda20240919 \n" +
                    "\t\tWHERE\n" +
                    "\t\t\tprovince = '"+province+"' \n" +
                    "\t\t\tAND region = '"+region+"' \n" +
                    "\t\t\tAND subject_type = '常规' \n" +
                    "\t\t\tAND exam_id = 'TDA20240919G2' \n" +
                    "\t\t\tAND sub_subject = '"+subject+"' \n" +
                    "\t\t\tAND stu_subject_score_rate_province_pct_rank >= (1-0.27) ";

            List<String> ids  = reportTemplate.queryForList(sql3,new HashMap<>(),String.class);

            List<DtoKn> collect1 = data.stream().filter(x -> ids.contains(x.getStuId())).collect(Collectors.toList());

            Map<String, List<DtoKn>> collect2 = collect1.stream().collect(Collectors.groupingBy(DtoKn::getKnowledge));

            for (String knowledge : collect2.keySet()) {
                List<DtoKn> goods = collect2.get(knowledge);
                Double sumRate = goods.stream().mapToDouble(DtoKn::getStuKnScoreRate).sum();
                Double result = sumRate/goods.size();
                if(Double.isNaN(result)||Double.isInfinite(result)){
                    result = 0.0;
                }

                HashMap paramsYi = new HashMap(){{
                    put("subSubject",subject);
                    put("knowledge",knowledge);
                    put("region",region);
                    put("province",province);
                }};
                paramsYi.put("rate",result);

                reportTemplate.update("insert into knowledge_province_excellent20240919(sub_subject,knowledge,region,rate,province) value (:subSubject,:knowledge,:region,:rate,:province)",new MapSqlParameterSource(paramsYi));
            }

        }



    }
}
