package com.example.pdfgenerator.controller;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.model.*;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.*;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@RestController
public class CosController {

    @Autowired
    private COSClient cosClient;

    private static final  String  BUCKET_NAME = "schoolreportpdf-1317275686";

    @GetMapping("/download-folder")
    public ResponseEntity<InputStreamResource> downloadFolder(@RequestParam(required = false ,defaultValue = "class/basic/改革/山东省/东平县高级中学") String folderPath) throws IOException {
        //删除目录下面的服务器本地上面的zip文件

        // List objects in the folder
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest()
                .withBucketName(BUCKET_NAME)
                .withPrefix(folderPath);

        ObjectListing listObjectsResponse = cosClient.listObjects(listObjectsRequest);

        List<COSObjectSummary> objectSummaries = listObjectsResponse.getObjectSummaries();

        // Create a temporary file for ZIP
        File tempZipFile = File.createTempFile("zipFile", ".zip");

        // Create ZIP file
        try (FileOutputStream fos = new FileOutputStream(tempZipFile);
             ZipOutputStream zos = new ZipOutputStream(fos)) {

            for (COSObjectSummary objectSummary : objectSummaries) {
                String key = objectSummary.getKey();
                String fileName = key.substring(key.lastIndexOf('/') + 1);

                COSObject s3Object = cosClient.getObject(BUCKET_NAME, key);
                try (COSObjectInputStream inputStream = s3Object.getObjectContent()) {
                    ZipEntry zipEntry = new ZipEntry(fileName);
                    zos.putNextEntry(zipEntry);

                    byte[] buffer = new byte[1024];
                    int length;
                    while ((length = inputStream.read(buffer)) > 0) {
                        zos.write(buffer, 0, length);
                    }
                    zos.closeEntry();
                }
            }

            var resource = new InputStreamResource(new ByteArrayInputStream(java.nio.file.Files.readAllBytes(tempZipFile.toPath())));

            return ResponseEntity.ok()
                    .header(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=\"zipFile.zip\"")
                    .contentType(MediaType.APPLICATION_OCTET_STREAM)
                    .body(resource);
        }finally {
            if(tempZipFile!=null&&tempZipFile.exists()){
                tempZipFile.delete();
            }
        }

    }
}
