package com.example.pdfgenerator;

import com.alibaba.druid.pool.DruidDataSource;
import com.example.pdfgenerator.config.MyDataSourceConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.annotation.PostConstruct;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Author ryze
 * @Date 2025/9/26
 */

@SpringBootTest
@Slf4j
public class UploadPdfToCosTest {

    String bucketName = "schoolreportpdf-1317275686";

    JdbcTemplate report = new JdbcTemplate();


    @PostConstruct
    public void init() {
        String url = "jdbc:mysql://192.168.0.46:3306/tempnew?useUnicode=true&characterEncoding=utf-8&useSSL=false&serverTimezone=GMT%2B8";
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(url);
        dataSource.setUsername("jiru");
        dataSource.setPassword("Jiru@20231026");
        report = new JdbcTemplate(dataSource);
    }

    String examUuid = "TDA20251023G12";

    String suffix = "20251023";
    @Autowired
    private COSClient cosClient;


    // 校验报告是否完整
    @Test
    public void test() {


        // 1.学校基础报告
        List<Map<String, Object>> mapList = report.queryForList("select \n" +
                "school,exam_id,province,region1 as region\n" +
                "from \n" +
                "base_school_subject_tda" + suffix + "  where subject_type = '常规' \n" +
                "\n" +
                "group by school,exam_id,province,region1");

        for (Map<String, Object> objectMap : mapList) {
            String region1 = objectMap.get("region").toString();
            String province = objectMap.get("province").toString();
            String school = objectMap.get("school").toString();
            File file = new File("E:\\myWorkSpace\\basic\\" + region1 + province + school + examUuid + ".pdf");
            if (!file.exists()) {
                System.out.println(region1 + province + school + examUuid + "不存在");
            }
        }

        System.out.println("学校基础报告校验完毕...");

        // 2 校验学校科目报告
        List<Map<String, Object>> mapList2 = report.queryForList("select \n" +
                "school,exam_id,province,region1 as  region,sub_subject\n" +
                "from \n" +
                "base_school_subject_tda" + suffix + "\n" +
                " where subject_type = '常规'    group by school,exam_id,province,region1,sub_subject");

        for (Map<String, Object> objectMap : mapList2) {
            String region1 = objectMap.get("region").toString();
            String province = objectMap.get("province").toString();
            String school = objectMap.get("school").toString();
            String subSubject = objectMap.get("sub_subject").toString();
            File file = new File("E:\\myWorkSpace\\subject\\" + region1 + province + school + subSubject + examUuid + ".pdf");
            if (!file.exists()) {
                System.out.println(region1 + province + school + subSubject + examUuid + "不存在");
            }
        }

        System.out.println("学校科目报告校验完毕...");

        // 3 班级综合报告
        List<Map<String, Object>> mapList3 = report.queryForList("SELECT\n" +
                "\tclass AS class_name,\n" +
                "\tschool,\n" +
                "\texam_id,\n" +
                "\tprovince,\n" +
                "\tregion1 as region \n" +
                "FROM\n" +
                "\tbase_class_subject_tda" + suffix + "\n" +
                "WHERE\n" +
                "\tsubject_type = '常规'   GROUP BY\n" +
                "\tclass,\n" +
                "\tschool,\n" +
                "\texam_id,\n" +
                "\tprovince,\n" +
                "\tregion1");

        for (Map<String, Object> objectMap : mapList3) {
            String region1 = objectMap.get("region").toString();
            String province = objectMap.get("province").toString();
            String school = objectMap.get("school").toString();
            String className = objectMap.get("class_name").toString();

            File file = new File("E:\\myWorkSpace\\Class\\Basic\\" + region1 + province + school + className + examUuid + ".pdf");
            if (!file.exists()) {
                System.out.println(region1 + province + school + className + examUuid + "不存在");
            }
        }

        System.out.println("班级综合报告校验完毕...");


        // 4.班级科目报告
        List<Map<String, Object>> mapList4 = report.queryForList("SELECT\n" +
                "\tclass as class_name,\n" +
                "\tsub_subject,\n" +
                "\tschool,\n" +
                "\tprovince,\n" +
                "\tregion1 as region,\n" +
                "\texam_id\n" +
                "FROM\n" +
                "\tbase_student_subject_tda" + suffix + "\n" +
                "where\n" +
                "subject_type = '常规'   \tGROUP BY\n" +
                "\tclass,\n" +
                "\tsub_subject,\n" +
                "\tschool,\n" +
                "\tprovince,\n" +
                "\tregion1,\n" +
                "\texam_id\n");

        for (Map<String, Object> objectMap : mapList4) {
            String region1 = objectMap.get("region").toString();
            String province = objectMap.get("province").toString();
            String school = objectMap.get("school").toString();
            String className = objectMap.get("class_name").toString();
            String subSubject = objectMap.get("sub_subject").toString();

            File file = new File("E:\\myWorkSpace\\Class\\subject\\" + region1 + province + school + subSubject + examUuid + subSubject + className + ".pdf");
            if (!file.exists()) {
                System.out.println(region1 + province + school + subSubject + examUuid + subSubject + className + "不存在");
            }
        }

        System.out.println("班级学科报告校验完毕...");

    }


    @Test
    public void test1() {
        // 1.上传学校报告
        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getTestJdbcTemplate();

        reportJdbcTemplate.queryForList("select * from dp_total_score");
        File basicFile = new File("E:\\myworkSpace\\basic\\");
        File[] basicFiles = basicFile.listFiles();
        assert basicFiles != null;

        for (File file : basicFiles) {
            String prefix = "PdfDir/" + file.getName();
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, prefix, file);
            try {
                PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                log.info(putObjectResult.getRequestId());
                //file.delete();
            } catch (CosServiceException e) {
                log.info("cos服务出现问题");
                e.printStackTrace();
            } catch (CosClientException e) {
                log.info("cos客户端出现问题" + file.getName() + "文件上传有误,重新上传");
                e.printStackTrace();
            }
        }


        //3.上传班级综合报告

        //3.上传班级科目分析报告
    }


    @Test
    public void test2() {
        // 1.上传学校报告
//        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getTestJdbcTemplate();
//
//        reportJdbcTemplate.queryForList("select * from dp_total_score");
        File basicFile = new File("E:\\myworkSpace\\subject\\");
        File[] basicFiles = basicFile.listFiles();
        assert basicFiles != null;

        for (File file : basicFiles) {
            String prefix = "PdfSubject/" + file.getName();
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, prefix, file);
            try {
                PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                log.info(putObjectResult.getRequestId());
                //file.delete();
            } catch (CosServiceException e) {
                log.info("cos服务出现问题");
                e.printStackTrace();
            } catch (CosClientException e) {
                log.info("cos客户端出现问题" + file.getName() + "文件上传有误,重新上传");
                e.printStackTrace();
            }
        }


    }

    //3.上传班级综合报告
    @Test
    public void testZh() {


        String examUuid = "TDA20251023G12";
        String typeName = "班级综合报告";

//        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getTestJdbcTemplate();

        List<Map<String, Object>> mapList = report.queryForList("\tSELECT\n" +
                "\tclass AS class_name,\n" +
                "\tschool,\n" +
                "\texam_id,\n" +
                "\tprovince,\n" +
                "\tregion1 as region \n" +
                "FROM\n" +
                "\tbase_class_subject_tda20251023\n" +
                "WHERE\n" +
                "\tsubject_type = '常规'   GROUP BY\n" +
                "\tclass,\n" +
                "\tschool,\n" +
                "\texam_id,\n" +
                "\tprovince,\n" +
                "\tregion1");
        File basicFile = new File("E:\\myworkSpace\\Class\\Basic");

        for (Map<String, Object> map : mapList) {
            String provinceName = map.get("province").toString();
            String schoolName = map.get("school").toString();
            String banjiName = map.get("class_name").toString();
            String region = map.get("region").toString();
            String exam_id = map.get("exam_id").toString();
            String path = region + provinceName + schoolName + banjiName + exam_id + ".pdf";

            File file2 = new File(basicFile, path);
            if (!file2.exists()) {
                System.out.println(path + "  不存在");
            } else {
                System.out.println("存在");

                String prefix = "class/" + examUuid + "/" + provinceName + "/" + schoolName + "/" + typeName + "/" + banjiName + "/" + path;
                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, prefix, file2);
                try {
                    PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                    log.info(putObjectResult.getRequestId());
                    //file.delete();
                } catch (CosServiceException e) {
                    log.info("cos服务出现问题");
                    e.printStackTrace();
                } catch (CosClientException e) {
                    log.info("cos客户端出现问题" + file2.getName() + "文件上传有误,重新上传");
                    e.printStackTrace();
                }
            }
        }
    }


    //4.上传班级科目分析报告
    @Test
    public void testFx() {


        String examUuid = "TDA20251023G12";
        String typeName = "班级学科报告";

//        JdbcTemplate reportJdbcTemplate = MyDataSourceConfig.getTestJdbcTemplate();

        List<Map<String, Object>> mapList = report.queryForList("\tSELECT\n" +
                "\tclass as class_name,\n" +
                "\tsub_subject,\n" +
                "\tschool,\n" +
                "\tprovince,\n" +
                "\tregion1 as region,\n" +
                "\texam_id\n" +
                "FROM\n" +
                "\tbase_student_subject_tda20251023\n" +
                "where\n" +
                "subject_type = '常规'   \tGROUP BY\n" +
                "\tclass,\n" +
                "\tsub_subject,\n" +
                "\tschool,\n" +
                "\tprovince,\n" +
                "\tregion1,\n" +
                "\texam_id");
        File basicFile = new File("E:\\myworkSpace\\Class\\Subject");

        for (Map<String, Object> map : mapList) {
            String region = map.get("region").toString();
            String provinceName = map.get("province").toString();
            String schoolName = map.get("school").toString();
            String banjiName = map.get("class_name").toString();
            String subjectName = map.get("sub_subject").toString();
            String examId = map.get("exam_id").toString();

            String path = region + provinceName + schoolName + subjectName + examId + subjectName + banjiName + ".pdf";


            File file2 = new File(basicFile, path);
            if (!file2.exists()) {
                System.out.println(path + "  不存在");
            } else {
                System.out.println("存在");

                String prefix = "class/" + examUuid + "/" + provinceName + "/" + schoolName + "/" + typeName + "/" + banjiName + "/" + subjectName + "/" + path;
                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, prefix, file2);
                try {
                    PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                    log.info(putObjectResult.getRequestId());
                    //file.delete();
                } catch (CosServiceException e) {
                    log.info("cos服务出现问题");
                    e.printStackTrace();
                } catch (CosClientException e) {
                    log.info("cos客户端出现问题" + file2.getName() + "文件上传有误,重新上传");
                    e.printStackTrace();
                }
            }
        }
    }

}
