package com.example.studentworkgenerator.config;

import com.example.studentworkgenerator.dto.Province;
import com.example.studentworkgenerator.dto.School;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class DataCacheInit {

    public static final Map<String,Long> schoolMaps = new HashMap<>();

    public static final Map<String,Long> provinceMaps = new HashMap<>();

    @Resource
    private JdbcTemplate BaoMingJdbcTemplate;

    @PostConstruct
    public void InitSomeDatas(){
        List<Province> provinces = BaoMingJdbcTemplate.query("select * from sparta_province",new Object[]{},new BeanPropertyRowMapper<>(Province.class));
        List<School> schools = BaoMingJdbcTemplate.query("select * from sparta_school",new Object[]{},new BeanPropertyRowMapper<>(School.class));
        for (School school : schools) {
            schoolMaps.put(school.getName(),school.getId());
        }
        for (Province province : provinces) {
            provinceMaps.put(province.getName(),province.getId());
        }
    }
}
