package com.example.studentworkgenerator.controller;

import com.example.studentworkgenerator.config.DataCacheInit;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/studentGen")
public class studentPaperReportGeneratorController {

    private static final Logger logger = LoggerFactory.getLogger(studentPaperReportGeneratorController.class);

    @Resource
    private JdbcTemplate baoMingJdbcTemplate;

    @Autowired
    private COSClient cosClient;

    private static final String bucketName = "scorereport-1317275686";

    private static final String requestHeader = "http://localhost:18388";

    @GetMapping("/generatorPaperWork")
    public String generatorPaperWork(@RequestParam(value = "schoolName",required = false)String schoolName,@RequestParam(value = "provinceName",required = false)String provinceName){
        String sql = "select zkz_num from dp_total_score ";
        String appendStatement = "";

        if(!(null==provinceName)&&null==schoolName){
            List<String>  provinceList = Arrays.asList(provinceName.split("#"));
            List<Long> provinceIds = provinceList.stream().map(x->(Long)DataCacheInit.provinceMaps.get(x)).collect(Collectors.toList());
            String provinceStatement = " ( ";
            int i = 1;
            for (Long provinceId : provinceIds) {
                if(i==provinceIds.size()){
                    provinceStatement = provinceStatement + provinceId+ " ) ";
                }else{
                    provinceStatement = provinceStatement + provinceId + "," ;
                }
                i++;
            }
            appendStatement =  appendStatement + "where province_id in "+ provinceStatement;
        }

        if(!(null==schoolName)&&null==provinceName){
            List<String>  schoolList = Arrays.asList(schoolName.split("#"));
            List<Long> schoolIds  = schoolList.stream().map(x->(Long)DataCacheInit.provinceMaps.get(x)).collect(Collectors.toList());
            String schoolStatement = " ( ";
            int i = 1;
            for (Long schoolId : schoolIds) {
                if(i==schoolIds.size()){
                    schoolStatement = schoolStatement + schoolId + " ) ";
                }else{
                    schoolStatement = schoolStatement + schoolId + "," ;
                }
                i++;
            }
            appendStatement =  appendStatement + "where school_id in "+ schoolStatement;
        }

        if(!(null==schoolName)&&!(null==provinceName)){
            List<String>  provinceList = Arrays.asList(provinceName.split("#"));
            List<Long> provinceIds = provinceList.stream().map(x->(Long)DataCacheInit.provinceMaps.get(x)).collect(Collectors.toList());
            String provinceStatement = " ( ";
            int i = 1;
            for (Long provinceId : provinceIds) {
                if(i==provinceIds.size()){
                    provinceStatement = provinceStatement + provinceId + " ) ";
                }else{
                    provinceStatement = provinceStatement + provinceId + "," ;
                }
                i++;
            }
            appendStatement =  appendStatement + " where province_id in "+ provinceStatement;
            List<String>  schoolList = Arrays.asList(schoolName.split("#"));
            List<Long> schoolIds  = schoolList.stream().map(x->(Long)DataCacheInit.provinceMaps.get(x)).collect(Collectors.toList());
            String schoolStatement = " ( ";
            int j = 1;
            for (Long schoolId : schoolIds) {
                if(j==schoolIds.size()){
                    schoolStatement = schoolStatement + schoolId + " ) ";
                }else{
                    schoolStatement = schoolStatement + schoolId + "," ;
                }
                j++;
            }
            appendStatement = appendStatement + " and school_id in "+ schoolStatement;
        }

        sql = sql + appendStatement;

        List<String> zkzNums = baoMingJdbcTemplate.queryForList(sql,new Object[]{},String.class);

        int i = 1;
        for (String zkzNum : zkzNums) {
            logger.info("正在生成"+zkzNum+"学生的基础报告");
            logger.info("完成进度"+i+"/"+zkzNums.size());
            ProcessBuilder processBuilderSubject = new ProcessBuilder();
            String httpRequest = requestHeader + "/student/taca/20241201/"+zkzNum+"/md5";
            String fileLocalPath = "/myworkSpace/jichu/"+zkzNum+".pdf";
            processBuilderSubject.command("bash", "-c", "node /myworkSpace/puppeteer.js "+httpRequest+" pdf "+fileLocalPath);
            processBuilderSubject.redirectErrorStream(true); // 合并标准输出和错误输出
            Process processSubject = null;
            try {
                processSubject = processBuilderSubject.start();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
            BufferedReader readerSubject = new BufferedReader(new InputStreamReader(processSubject.getInputStream()));
            String lineSubject;
            while (true) {
                try {
                    if (!((lineSubject = readerSubject.readLine()) != null)) break;
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                int exitCodeSubject = processSubject.waitFor();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            File subjectFile = new File("/myworkSpace/jichu/");
            File[] subjectFiles = subjectFile.listFiles();
            assert subjectFiles != null;
            for (File file : subjectFiles) {
                String fileName = file.getName();
                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName,"/CACA20241201/jichu/"+fileName, file);
                try {
                    PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                    logger.info(putObjectResult.getRequestId());
                    file.delete();
                } catch (CosServiceException e) {
                    logger.info("cos服务出现问题");
                    e.printStackTrace();
                } catch (CosClientException e) {
                    logger.info("cos客户端出现问题");
                    e.printStackTrace();
                }
            }
            i++;
        }

        return "操作成功";
    }


    @GetMapping("/generatorLocalPaperWork")
    public String localPaperWork(@RequestParam(value = "schoolName",required = false)String schoolName,@RequestParam(value = "provinceName",required = false)String provinceName){
        String sql = "select zkz_num from dp_total_score ";
        String appendStatement = "";

        if(!(null==provinceName)&&null==schoolName){
            List<String>  provinceList = Arrays.asList(provinceName.split("#"));
            List<Long> provinceIds = provinceList.stream().map(x->(Long)DataCacheInit.provinceMaps.get(x)).collect(Collectors.toList());
            String provinceStatement = " ( ";
            int i = 1;
            for (Long provinceId : provinceIds) {
                if(i==provinceIds.size()){
                    provinceStatement = provinceStatement + provinceId+ " ) ";
                }else{
                    provinceStatement = provinceStatement + provinceId + "," ;
                }
                i++;
            }
            appendStatement =  appendStatement + "where province_id in "+ provinceStatement;
        }

        if(!(null==schoolName)&&null==provinceName){
            List<String>  schoolList = Arrays.asList(schoolName.split("#"));
            List<Long> schoolIds  = schoolList.stream().map(x->(Long)DataCacheInit.provinceMaps.get(x)).collect(Collectors.toList());
            String schoolStatement = " ( ";
            int i = 1;
            for (Long schoolId : schoolIds) {
                if(i==schoolIds.size()){
                    schoolStatement = schoolStatement + schoolId + " ) ";
                }else{
                    schoolStatement = schoolStatement + schoolId + "," ;
                }
                i++;
            }
            appendStatement =  appendStatement + "where school_id in "+ schoolStatement;
        }

        if(!(null==schoolName)&&!(null==provinceName)){
            List<String>  provinceList = Arrays.asList(provinceName.split("#"));
            List<Long> provinceIds = provinceList.stream().map(x->(Long)DataCacheInit.provinceMaps.get(x)).collect(Collectors.toList());
            String provinceStatement = " ( ";
            int i = 1;
            for (Long provinceId : provinceIds) {
                if(i==provinceIds.size()){
                    provinceStatement = provinceStatement + provinceId + " ) ";
                }else{
                    provinceStatement = provinceStatement + provinceId + "," ;
                }
                i++;
            }
            appendStatement =  appendStatement + " where province_id in "+ provinceStatement;
            List<String>  schoolList = Arrays.asList(schoolName.split("#"));
            List<Long> schoolIds  = schoolList.stream().map(x->(Long)DataCacheInit.provinceMaps.get(x)).collect(Collectors.toList());
            String schoolStatement = " ( ";
            int j = 1;
            for (Long schoolId : schoolIds) {
                if(j==schoolIds.size()){
                    schoolStatement = schoolStatement + schoolId + " ) ";
                }else{
                    schoolStatement = schoolStatement + schoolId + "," ;
                }
                j++;
            }
            appendStatement = appendStatement + " and school_id in "+ schoolStatement;
        }

        sql = sql + appendStatement;

        List<String> zkzNums = baoMingJdbcTemplate.queryForList(sql,new Object[]{},String.class);

        int i = 1;
        for (String zkzNum : zkzNums) {
            logger.info("正在生成"+zkzNum+"学生的基础报告");
            logger.info("完成进度"+i+"/"+zkzNums.size());
            ProcessBuilder processBuilderSubject = new ProcessBuilder();
            String httpRequest = requestHeader + "/student/taca/20241201/"+zkzNum+"/md5";
            String fileLocalPath = "D:/myworkSpace/jichu/"+zkzNum+".pdf";
            processBuilderSubject.command("cmd.exe", "/c", "node D:/myworkSpace/puppeteer.js "+"www.baidu.com "+" pdf "+fileLocalPath);
            processBuilderSubject.redirectErrorStream(true); // 合并标准输出和错误输出
            Process processSubject = null;
            try {
                processSubject = processBuilderSubject.start();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
            BufferedReader readerSubject = new BufferedReader(new InputStreamReader(processSubject.getInputStream()));
            String lineSubject;
            while (true) {
                try {
                    if (!((lineSubject = readerSubject.readLine()) != null)) break;
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                int exitCodeSubject = processSubject.waitFor();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            File subjectFile = new File("D:/myworkSpace/jichu/");
            File[] subjectFiles = subjectFile.listFiles();
            assert subjectFiles != null;
            for (File file : subjectFiles) {
                String fileName = file.getName();
                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName,"/CACA20241201Test/jichu/"+fileName, file);
                try {
                    PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
                    logger.info(putObjectResult.getRequestId());
                    file.delete();
                } catch (CosServiceException e) {
                    logger.info("cos服务出现问题");
                    e.printStackTrace();
                } catch (CosClientException e) {
                    logger.info("cos客户端出现问题");
                    e.printStackTrace();
                }
            }
            i++;
        }

        return "操作成功";
    }
}