/* eslint-disable */

import Vue from 'vue'
import VueRouter from 'vue-router'
// import store from '@/store'

import indexLogin from './index/login'
import indexCamp from './index/camp'

Vue.use(VueRouter)

const routes = [{
    path: '/',
    name: 'recruit',
    meta: {
      title: '招生简章'
    },
    component: () =>
      import('v/index/recruit/Index.vue')
  },
  {
    path: '/login',
    name: 'loginIndex',
    meta: {
      title: '登录'
    },
    component: () =>
      import('v/index/login/Index.vue'),
    children: [...indexLogin]
  },
  {
    path: '/:cerificate',
    name: 'cerificateIndex',
    meta: {
      title: '营地报名'
    },
    // redirect: '/cerificate/signUp',
    component: () =>
      import('v/index/camp/Index.vue'),
    children: [...indexCamp]
  }
 
 
]

const originalPush = VueRouter.prototype.push
VueRouter.prototype.push = function push(location) {
  return originalPush.call(this, location).catch(err => err)
}

const router = new VueRouter({
  mode: 'history',
  // base: process.env.BASE_URL,
  routes
})
//   运用vue-router的错误处理函数 onError 捕获错误
router.onError((error) => {
  const pattern = /Loading chunk (\d)+ failed/g
  const isChunkLoadFailed = error.message.match(pattern)
  const targetPath = router.history.pending.fullPath
  if (isChunkLoadFailed) {
    router.replace(targetPath)
  }
})
// router.beforeEach((to, from, next) => {
//   // 记录上一页
//   if (from) {
//     store.commit('setPrePage', from.path)
//   }
//   // 1.修改页面标题
//   document.title = to.meta.title

//   let token = localStorage.getItem(tokenKey)
//   if (to.meta.authorization && to.meta.authorization === true) {
//     store.commit('setPrePage', to.path)
//     // 2.1.获取登录信息
//     if (token == null) {
//       // 2.1.1.未登录，跳转到登录页面
//       router.push({
//         path: toLogin
//       })
//     } else {
//       next()
//       // authInfo = JSON.parse(authInfo);
//       // // 2.1.2.判断token是否过期
//       // let dt = new Date(authInfo.dt);
//       // let overDt = new Date(dt.getTime() + authInfo.data.expires_in * 1000);
//       // if (overDt >= new Date()) {
//       //   // 2.1.2.1未过期
//       //   next();
//       // } else {
//       //   // 2.1.2.2过期，刷新token
//       //   next();
//       // }
//     }
//   } else {
//     if (token) {
//       router.push({
//         path: toPage
//       })
//     } else {
//       next()
//     }
//   }
// })

export default router
