/* eslint-disable */

//用户名
const name = /^[a-zA-Z_0-9]*[a-zA-Z][a-zA-Z_0-9]*$/
// 数字
const numberReg = /^\d+$|^\d+[.]?\d+$/
// 中文
const cnReg = /^[\u4e00-\u9fa5]+$/

// 邮箱
const emailReg = /^([a-zA-Z0-9_.-])+@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/

// 手机号
const phoneReg = /^1(3|4|5|6|7|8|9)\d{9}$/

export default {
  //手机号验证
  validatePhone: function (rule, value, callback) {
    if (!phoneReg.test(value) || value.length !== 11) {
      callback(new Error('手机号格式错误！'))
    } else {
      callback()
    }
  },

  validateid_card: function (rule, value, callback) {
    // console.log(value, 'sss')
    if (!value) {
      return callback(new Error("身份证号不能为空"));
    }
    if (!/(^\d{15}$)|(^\d{17}(\d|X|x)$)/.test(value)) {
      return callback(new Error("你输入的身份证长度或格式错误"));
    }
    //身份证城市
    var aCity = {
      11: "北京",
      12: "天津",
      13: "河北",
      14: "山西",
      15: "内蒙古",
      21: "辽宁",
      22: "吉林",
      23: "黑龙江",
      31: "上海",
      32: "江苏",
      33: "浙江",
      34: "安徽",
      35: "福建",
      36: "江西",
      37: "山东",
      41: "河南",
      42: "湖北",
      43: "湖南",
      44: "广东",
      45: "广西",
      46: "海南",
      50: "重庆",
      51: "四川",
      52: "贵州",
      53: "云南",
      54: "西藏",
      61: "陕西",
      62: "甘肃",
      63: "青海",
      64: "宁夏",
      65: "新疆",
      71: "台湾",
      81: "香港",
      82: "澳门",
      91: "国外"
    };
    if (!aCity[parseInt(value.substr(0, 2))]) {
      return callback(new Error("你的身份证地区非法"));
    }
    return callback();
  },
  // 数字验证
  validateNumber: function (rule, value, callback) {
    if (!numberReg.test(value)) {
      callback(new Error('请输入数字'))
    } else {
      callback()
    }
  },
  // 中文验证
  validateCn: function (rule, value, callback) {
    if (!cnReg.test(value)) {
      callback(new Error("请输入中文"));
    } else {
      callback()
    }
  },
  // 邮箱验证
  validateEmail: function (rule, value, callback) {
    if (!emailReg.test(value)) {
      callback(new Error('邮箱格式错误！'))
    } else {
      callback()
    }
  },
}
